/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class AbstractCreateFormAction
extends CreateElementActionBase
implements DumbAware {
    public AbstractCreateFormAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon) {
        if (dynamicText == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            if (view != null) {
                PsiDirectory[] dirs;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                for (PsiDirectory dir : dirs = view.getDirectories()) {
                    if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                    return;
                }
            }
            presentation.setEnabledAndVisible(false);
        }
    }

    protected String createFormBody(@Nullable String fqn, @NonNls String formName, String layoutManager) throws IncorrectOperationException {
        String s;
        try {
            s = FileUtil.loadTextAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(formName));
        }
        catch (IOException e) {
            throw new IncorrectOperationException(UIDesignerBundle.message("error.cannot.read", formName), (Throwable)e);
        }
        s = fqn != null ? StringUtil.replace((String)s, (String)"$CLASS$", (String)fqn) : StringUtil.replace((String)s, (String)"bind-to-class=\"$CLASS$\"", (String)"");
        s = StringUtil.replace((String)s, (String)"$LAYOUT$", (String)layoutManager);
        return StringUtil.convertLineSeparators((String)s);
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        if (directory == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(4);
        }
        String string = UIDesignerBundle.message("progress.creating.class", JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName(), newName);
        if (string == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/actions/AbstractCreateFormAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/actions/AbstractCreateFormAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    protected class JavaNameValidator
    extends CreateElementActionBase.MyInputValidator {
        private final Project myProject;

        public JavaNameValidator(Project project, PsiDirectory directory) {
            super((CreateElementActionBase)AbstractCreateFormAction.this, project, directory);
            this.myProject = project;
        }

        public boolean checkInput(String inputString) {
            return !inputString.isEmpty() && PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(inputString);
        }
    }
}

