/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.execution.process.OSProcessUtil;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadMXBean;
import java.lang.module.FindException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010$\u001a\u00020#H\u0016J-\u0010%\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0+H\u0002\u00a2\u0006\u0002\u0010,R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\f\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "Ljava/lang/AutoCloseable;", "pid", "", "(I)V", "connector", "Ljavax/management/remote/JMXConnector;", "diagnosticBean", "Lcom/sun/management/HotSpotDiagnosticMXBean;", "getDiagnosticBean", "()Lcom/sun/management/HotSpotDiagnosticMXBean;", "diagnosticBean$delegate", "Lkotlin/Lazy;", "memoryBean", "Ljava/lang/management/MemoryMXBean;", "getMemoryBean", "()Ljava/lang/management/MemoryMXBean;", "memoryBean$delegate", "notificationListener", "Ljavax/management/NotificationListener;", "osBean", "Lcom/sun/management/OperatingSystemMXBean;", "getOsBean", "()Lcom/sun/management/OperatingSystemMXBean;", "osBean$delegate", "getPid", "()I", "threadBean", "Ljava/lang/management/ThreadMXBean;", "getThreadBean", "()Ljava/lang/management/ThreadMXBean;", "threadBean$delegate", "vm", "Lcom/sun/tools/attach/VirtualMachine;", "addNotificationListener", "", "close", "getMXBean", "T", "Ljava/lang/management/PlatformManagedObject;", "beanName", "", "beanInterface", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/management/PlatformManagedObject;", "Companion", "intellij.profiler.common"})
public final class JavaProcessMonitor
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @Nullable
    private final VirtualMachine vm;
    @Nullable
    private final JMXConnector connector;
    @Nullable
    private NotificationListener notificationListener;
    @NotNull
    private final Lazy osBean$delegate;
    @NotNull
    private final Lazy memoryBean$delegate;
    @NotNull
    private final Lazy threadBean$delegate;
    @NotNull
    private final Lazy diagnosticBean$delegate;
    @NotNull
    public static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";

    /*
     * WARNING - void declaration
     */
    private JavaProcessMonitor(int pid) {
        this.pid = pid;
        this.osBean$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OperatingSystemMXBean>(this){
            final /* synthetic */ JavaProcessMonitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OperatingSystemMXBean invoke() {
                return (OperatingSystemMXBean)JavaProcessMonitor.access$getMXBean(this.this$0, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            }
        }));
        this.memoryBean$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MemoryMXBean>(this){
            final /* synthetic */ JavaProcessMonitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MemoryMXBean invoke() {
                return (MemoryMXBean)JavaProcessMonitor.access$getMXBean(this.this$0, "java.lang:type=Memory", MemoryMXBean.class);
            }
        }));
        this.threadBean$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ThreadMXBean>(this){
            final /* synthetic */ JavaProcessMonitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ThreadMXBean invoke() {
                return (ThreadMXBean)JavaProcessMonitor.access$getMXBean(this.this$0, "java.lang:type=Threading", ThreadMXBean.class);
            }
        }));
        this.diagnosticBean$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HotSpotDiagnosticMXBean>(this){
            final /* synthetic */ JavaProcessMonitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HotSpotDiagnosticMXBean invoke() {
                return (HotSpotDiagnosticMXBean)JavaProcessMonitor.access$getMXBean(this.this$0, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            }
        }));
        if (this.pid == OSProcessUtil.getCurrentProcessId()) {
            this.vm = null;
            this.connector = null;
        } else {
            JMXConnector jMXConnector;
            this.vm = VirtualMachine.attach(String.valueOf(this.pid));
            String string = this.vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            if (string == null) {
                string = this.vm.startLocalManagementAgent();
            }
            String address = string;
            JMXConnector jMXConnector2 = jMXConnector = JMXConnectorFactory.connect(new JMXServiceURL(address));
            JavaProcessMonitor javaProcessMonitor = this;
            boolean bl = false;
            if (this.notificationListener != null) {
                void $this$_init__u24lambda_u240;
                $this$_init__u24lambda_u240.addConnectionNotificationListener(this.notificationListener, null, null);
            }
            javaProcessMonitor.connector = jMXConnector;
        }
    }

    public final int getPid() {
        return this.pid;
    }

    @NotNull
    public final OperatingSystemMXBean getOsBean() {
        Lazy lazy = this.osBean$delegate;
        return (OperatingSystemMXBean)lazy.getValue();
    }

    @NotNull
    public final MemoryMXBean getMemoryBean() {
        Lazy lazy = this.memoryBean$delegate;
        return (MemoryMXBean)lazy.getValue();
    }

    @NotNull
    public final ThreadMXBean getThreadBean() {
        Lazy lazy = this.threadBean$delegate;
        return (ThreadMXBean)lazy.getValue();
    }

    @NotNull
    public final HotSpotDiagnosticMXBean getDiagnosticBean() {
        Lazy lazy = this.diagnosticBean$delegate;
        return (HotSpotDiagnosticMXBean)lazy.getValue();
    }

    public final void addNotificationListener(@NotNull NotificationListener notificationListener) {
        Intrinsics.checkNotNullParameter((Object)notificationListener, (String)"notificationListener");
        JMXConnector jMXConnector = this.connector;
        if (jMXConnector != null) {
            jMXConnector.addConnectionNotificationListener(notificationListener, null, null);
        }
        this.notificationListener = notificationListener;
    }

    private final <T extends PlatformManagedObject> T getMXBean(String beanName, Class<T> beanInterface) {
        PlatformManagedObject platformManagedObject;
        PlatformManagedObject platformManagedObject2;
        Object object = this.connector;
        if (object != null && (object = object.getMBeanServerConnection()) != null) {
            Object server = object;
            boolean bl = false;
            v1 = (PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy((MBeanServerConnection)server, beanName, beanInterface);
        } else {
            v1 = platformManagedObject2 = null;
        }
        if (platformManagedObject2 == null) {
            T t = ManagementFactory.getPlatformMXBean(beanInterface);
            platformManagedObject = (PlatformManagedObject)t;
            Intrinsics.checkNotNullExpressionValue(t, (String)"getPlatformMXBean(...)");
        } else {
            platformManagedObject = platformManagedObject2;
        }
        return (T)platformManagedObject;
    }

    @Override
    public void close() {
        try {
            JMXConnector jMXConnector;
            if (this.notificationListener != null) {
                JMXConnector jMXConnector2 = this.connector;
                if (jMXConnector2 != null) {
                    jMXConnector2.removeConnectionNotificationListener(this.notificationListener);
                }
            }
            VirtualMachine virtualMachine = this.vm;
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
            JMXConnector jMXConnector3 = jMXConnector = this.connector;
            if (jMXConnector3 != null) {
                jMXConnector3.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    @NotNull
    public static final JavaProcessMonitor connect(int pid) {
        return Companion.connect(pid);
    }

    @JvmStatic
    public static final <T> T connect(int pid, @NotNull Function1<? super JavaProcessMonitor, ? extends T> block) {
        return Companion.connect(pid, block);
    }

    @JvmStatic
    @NotNull
    public static final JavaProcessMonitor getConnection(int pid) {
        return Companion.getConnection(pid);
    }

    @JvmStatic
    public static final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
        Companion.dumpHeap(pid, filePath);
    }

    public /* synthetic */ JavaProcessMonitor(int pid, DefaultConstructorMarker $constructor_marker) {
        this(pid);
    }

    public static final /* synthetic */ PlatformManagedObject access$getMXBean(JavaProcessMonitor $this, String beanName, Class beanInterface) {
        return $this.getMXBean(beanName, beanInterface);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J/\u0010\u0005\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\t0\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/api/monitor/JavaProcessMonitor$Companion;", "", "()V", "CONNECTOR_ADDRESS", "", "connect", "Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "pid", "", "T", "block", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dumpHeap", "", "filePath", "getConnection", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JavaProcessMonitor connect(int pid) {
            return new JavaProcessMonitor(pid, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T connect(int pid, @NotNull Function1<? super JavaProcessMonitor, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            AutoCloseable autoCloseable = new JavaProcessMonitor(pid, null);
            Throwable throwable = null;
            try {
                object = block.invoke((Object)autoCloseable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        @JvmStatic
        @NotNull
        public final JavaProcessMonitor getConnection(int pid) {
            return new JavaProcessMonitor(pid, null);
        }

        @JvmStatic
        public final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.connect(pid, (Function1)new Function1<JavaProcessMonitor, Unit>(filePath){
                final /* synthetic */ String $filePath;
                {
                    this.$filePath = $filePath;
                    super(1);
                }

                public final void invoke(@NotNull JavaProcessMonitor connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    HotSpotDiagnosticMXBean bean = connection.getDiagnosticBean();
                    bean.dumpHeap(this.$filePath, true);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

