/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model.impl;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.DataContextFactory;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.service.IgnorableDependenciesServiceKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\u0014\u0010)\u001a\u00020\u00002\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\f0\u0003\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "Lcom/intellij/packageChecker/model/ModuleModel;", "id", "", "platformModule", "Lcom/intellij/openapi/module/Module;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Set;Lcom/intellij/openapi/project/Project;)V", "getBuildFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getDataContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "dataContext$delegate", "Lkotlin/Lazy;", "getDependencies", "()Ljava/util/Set;", "setDependencies", "(Ljava/util/Set;)V", "getId", "()Ljava/lang/String;", "parentModuleName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getParentModuleName", "getPlatformModule", "()Lcom/intellij/openapi/module/Module;", "equals", "", "other", "", "hashCode", "", "toString", "withDependencies", "dependencyList", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nMutableModuleModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableModuleModel.kt\ncom/intellij/packageChecker/model/impl/MutableModuleModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n819#2:62\n847#2,2:63\n*S KotlinDebug\n*F\n+ 1 MutableModuleModel.kt\ncom/intellij/packageChecker/model/impl/MutableModuleModel\n*L\n27#1:62\n27#1:63,2\n*E\n"})
public class MutableModuleModel
implements ModuleModel {
    @NotNull
    private final String id;
    @Nullable
    private final Module platformModule;
    @Nullable
    private final VirtualFile buildFile;
    @NotNull
    private Set<Dependency> dependencies;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy dataContext$delegate;
    @NotNull
    private final String parentModuleName;

    public MutableModuleModel(@NotNull String id, @Nullable Module platformModule, @Nullable VirtualFile buildFile, @NotNull Set<Dependency> dependencies2, @NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.id = id;
        this.platformModule = platformModule;
        this.buildFile = buildFile;
        this.dependencies = dependencies2;
        this.project = project;
        this.dataContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DataContext>(this){
            final /* synthetic */ MutableModuleModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DataContext invoke() {
                return DataContextFactory.Companion.getInstance(MutableModuleModel.access$getProject$p(this.this$0)).getOrCreateDataContext(this.this$0.getBuildFile(), this.this$0.getPlatformModule(), MutableModuleModel.access$getProject$p(this.this$0));
            }
        }));
        if (this.getBuildFile() != null) {
            VirtualFile virtualFile = this.getBuildFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            string = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.project);
            if (string == null || (string = string.getName()) == null) {
                string = this.getId();
            }
        } else {
            string = this.getId();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        this.parentModuleName = string2;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getPlatformModule() {
        return this.platformModule;
    }

    @Override
    @Nullable
    public VirtualFile getBuildFile() {
        return this.buildFile;
    }

    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(@NotNull Set<Dependency> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.dependencies = set;
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        Lazy lazy = this.dataContext$delegate;
        return (DataContext)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableModuleModel withDependencies(@NotNull Iterable<Dependency> dependencyList) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(dependencyList, (String)"dependencyList");
        Iterable<Dependency> $this$filterNot$iv = dependencyList;
        boolean $i$f$filterNot = false;
        Iterable<Dependency> iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Dependency it = (Dependency)element$iv$iv;
            boolean bl = false;
            if (IgnorableDependenciesServiceKt.isPackageIgnored(this.project, it.getPkg(), this.getParentModuleName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set filteredSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new MutableModuleModel(this.getId(), this.getPlatformModule(), this.getBuildFile(), filteredSet, this.project);
    }

    @Override
    @NotNull
    public String getParentModuleName() {
        return this.parentModuleName;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.packageChecker.model.impl.MutableModuleModel");
        MutableModuleModel cfr_ignored_0 = (MutableModuleModel)other;
        return Intrinsics.areEqual((Object)this.getId(), (Object)((MutableModuleModel)other).getId()) && Intrinsics.areEqual((Object)this.getPlatformModule(), (Object)((MutableModuleModel)other).getPlatformModule()) && Intrinsics.areEqual((Object)this.getBuildFile(), (Object)((MutableModuleModel)other).getBuildFile()) && Intrinsics.areEqual(this.getDependencies(), ((MutableModuleModel)other).getDependencies());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId(), this.getPlatformModule(), this.getBuildFile()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "MutableModuleModel(id='" + this.getId() + "', platformModule=" + this.getPlatformModule() + ", buildFile=" + this.getBuildFile() + ")";
    }

    public static final /* synthetic */ Project access$getProject$p(MutableModuleModel $this) {
        return $this.project;
    }
}

