/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageChecker.DataContextFactory;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.IJModuleModel;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.java.JpsBuildFileProvider;
import com.intellij.packageChecker.java.ProjectDependenciesModels;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J4\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0014\u0010\u001a\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/packageChecker/java/IntellijModuleProjectDependenciesModel;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/java/IJModuleModel;", "Lcom/intellij/openapi/project/ModuleListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "module", "Lcom/intellij/openapi/module/Module;", "copyModule", "newDependencies", "createModule", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getAllModules", "moduleRemoved", "", "modulesAdded", "modules", "modulesRenamed", "oldNameProvider", "Lcom/intellij/util/Function;", "", "shouldProcess", "", "supports", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nIntellijModuleProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijModuleProjectDependenciesModel.kt\ncom/intellij/packageChecker/java/IntellijModuleProjectDependenciesModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n23#2:149\n1747#3,3:150\n1549#3:156\n1620#3,3:157\n3792#4:153\n4307#4,2:154\n*S KotlinDebug\n*F\n+ 1 IntellijModuleProjectDependenciesModel.kt\ncom/intellij/packageChecker/java/IntellijModuleProjectDependenciesModel\n*L\n56#1:149\n64#1:150,3\n118#1:156\n118#1:157,3\n116#1:153\n116#1:154,2\n*E\n"})
public final class IntellijModuleProjectDependenciesModel
extends ProjectDependenciesModelBase<IJModuleModel>
implements ModuleListener {
    @NotNull
    private final Project project;

    public IntellijModuleProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = IntellijModuleProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        this.init();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
    }

    public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        for (Module module : modules) {
            if (!this.shouldProcess(module)) continue;
            this.addModule((MutableModuleModel)this.createModule(module));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldProcess(@NotNull Module module) {
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) {
            return false;
        }
        try {
            string = ExternalSystemModulePropertyManager.Companion.getInstance(module).getExternalSystemId();
        }
        catch (Exception e) {
            IntellijModuleProjectDependenciesModel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IntellijModuleProjectDependenciesModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Can't get externalSystemId for module: " + module + ", module.isLoaded: " + module.isLoaded() + ", module.project: " + module.getProject() + ", module.file: " + module.getModuleFile(), (Throwable)e);
            return false;
        }
        String externalSystemId = string;
        if (Intrinsics.areEqual((Object)ProjectDependenciesModels.INSTANCE.getGRADLE_SYSTEM_ID().getId(), (Object)externalSystemId)) return false;
        Iterable $this$any$iv = BuildFileProvider.Companion.getEP_NAME().getExtensions((AreaInstance)this.project);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            BuildFileProvider it = (BuildFileProvider)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getId(), (Object)"maven") && it.supports(module)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
        this.refresh();
    }

    private final IJModuleModel createModule(Module module) {
        Iterable<Dependency> dependencies2 = this.collectDependencies(module);
        return new IJModuleModel(module.getName() + " IJ module", module, CollectionsKt.toSet(dependencies2), this.project);
    }

    private final Iterable<Dependency> collectDependencies(Module module) {
        List deps = new ArrayList();
        if (module.isDisposed()) {
            return deps;
        }
        DataContextFactory dataContextFactory = DataContextFactory.Companion.getInstance(this.project);
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> IntellijModuleProjectDependenciesModel.collectDependencies$lambda$1((Function1)new Function1<Library, Boolean>((List<Dependency>)deps, dataContextFactory){
            final /* synthetic */ List<Dependency> $deps;
            final /* synthetic */ DataContextFactory $dataContextFactory;
            {
                this.$deps = $deps;
                this.$dataContextFactory = $dataContextFactory;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library library) {
                Intrinsics.checkNotNull((Object)library);
                Package pkg = JavaPackageUtilKt.createPackage(library);
                if (pkg != null) {
                    this.$deps.add(new Dependency(pkg, SetsKt.emptySet(), this.$dataContextFactory.getOrCreateDataContext(library)));
                }
                return true;
            }
        }, arg_0));
        return deps;
    }

    public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.refresh();
    }

    @Override
    @NotNull
    protected IJModuleModel copyModule(@NotNull IJModuleModel module, @NotNull Iterable<Dependency> newDependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(newDependencies, (String)"newDependencies");
        return new IJModuleModel(module.getId(), module.getPlatformModule(), CollectionsKt.toSet(newDependencies), this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<IJModuleModel> getAllModules() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this.project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Module element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!this.shouldProcess((Module)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module element$iv$iv;
            element$iv$iv = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createModule((Module)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).supports(module);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).declaredDependencies(psiFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = ReadAction.compute(() -> IntellijModuleProjectDependenciesModel.declaredDependencies$lambda$5(this, module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private static final boolean collectDependencies$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List declaredDependencies$lambda$5(IntellijModuleProjectDependenciesModel this$0, Module $module) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
                JpsBuildFileProvider jpsFileProvider = (JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this$0.project);
                object = jpsFileProvider.moduleScript($module);
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                List<PackageDeclaration> list = jpsFileProvider.declaredPackages(it, $module);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

