/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.ProjectLibraryNavigatable;
import com.intellij.psi.PsiElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nJ\"\u0010\u0015\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u0003Jq\u0010\u0015\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u000e2M\u0010\u0018\u001aI\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0019R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/packageChecker/DataContextFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dataContextFile", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/actionSystem/DataContext;", "dataContextLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "dataContextModule", "Lcom/intellij/openapi/module/Module;", "dataContextPackage", "Lorg/jetbrains/security/package/Package;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createModuleNavigatableDataContext", "module", "createOpenFileDescriptorDataContext", "file", "getOrCreateDataContext", "library", "pkg", "findPackageDeclaration", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nDataContextFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataContextFactory.kt\ncom/intellij/packageChecker/DataContextFactory\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n72#2,2:130\n72#2,2:133\n72#2,2:136\n72#2,2:139\n72#2,2:142\n72#2,2:145\n1#3:132\n1#3:135\n1#3:138\n1#3:141\n1#3:144\n1#3:147\n*S KotlinDebug\n*F\n+ 1 DataContextFactory.kt\ncom/intellij/packageChecker/DataContextFactory\n*L\n37#1:130,2\n40#1:133,2\n50#1:136,2\n64#1:139,2\n67#1:142,2\n75#1:145,2\n37#1:132\n40#1:135\n50#1:138\n64#1:141\n67#1:144\n75#1:147\n*E\n"})
public final class DataContextFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Package, DataContext> dataContextPackage;
    @NotNull
    private final ConcurrentHashMap<Module, DataContext> dataContextModule;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, DataContext> dataContextFile;
    @NotNull
    private final ConcurrentHashMap<Library, DataContext> dataContextLibrary;

    public DataContextFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dataContextPackage = new ConcurrentHashMap();
        this.dataContextModule = new ConcurrentHashMap();
        this.dataContextFile = new ConcurrentHashMap();
        this.dataContextLibrary = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DataContext getOrCreateDataContext(@Nullable VirtualFile file2, @Nullable Module module, @NotNull Project project) {
        DataContext dataContext2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file2 != null) {
            ConcurrentMap $this$getOrPut$iv = this.dataContextFile;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file2);
            if (object == null) {
                boolean bl = false;
                DataContext default$iv = this.createOpenFileDescriptorDataContext(project, file2);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file2, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            dataContext2 = (DataContext)object;
        } else if (module != null) {
            ConcurrentMap $this$getOrPut$iv = this.dataContextModule;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(module);
            if (object == null) {
                boolean bl = false;
                DataContext default$iv = this.createModuleNavigatableDataContext(module);
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(module, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            dataContext2 = (DataContext)object;
        } else {
            DataContext dataContext3 = DataContext.EMPTY_CONTEXT;
            dataContext2 = dataContext3;
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"EMPTY_CONTEXT");
        }
        return dataContext2;
    }

    @NotNull
    public final DataContext getOrCreateDataContext(@Nullable VirtualFile file2, @Nullable Module module, @NotNull Package pkg, @NotNull Function3<? super VirtualFile, ? super Module, ? super Package, ? extends PsiElement> findPackageDeclaration) {
        DataContext dataContext2;
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter(findPackageDeclaration, (String)"findPackageDeclaration");
        if (module != null && file2 != null) {
            ConcurrentMap $this$getOrPut$iv = this.dataContextPackage;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(pkg);
            if (object == null) {
                boolean bl = false;
                DataContext default$iv = arg_0 -> DataContextFactory.getOrCreateDataContext$lambda$3$lambda$2(findPackageDeclaration, file2, module, pkg, this, arg_0);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(pkg, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            dataContext2 = (DataContext)object;
        } else if (module != null) {
            ConcurrentMap $this$getOrPut$iv = this.dataContextModule;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(module);
            if (object == null) {
                boolean bl = false;
                DataContext default$iv = this.createModuleNavigatableDataContext(module);
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(module, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            dataContext2 = (DataContext)object;
        } else if (file2 != null) {
            ConcurrentMap $this$getOrPut$iv = this.dataContextFile;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file2);
            if (object == null) {
                boolean bl = false;
                DataContext default$iv = this.createOpenFileDescriptorDataContext(this.project, file2);
                boolean bl4 = false;
                object = $this$getOrPut$iv.putIfAbsent(file2, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            dataContext2 = (DataContext)object;
        } else {
            DataContext dataContext3 = DataContext.EMPTY_CONTEXT;
            dataContext2 = dataContext3;
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"EMPTY_CONTEXT");
        }
        return dataContext2;
    }

    @NotNull
    public final DataContext getOrCreateDataContext(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        ConcurrentMap $this$getOrPut$iv = this.dataContextLibrary;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(library);
        if (object == null) {
            boolean bl = false;
            DataContext default$iv = arg_0 -> DataContextFactory.getOrCreateDataContext$lambda$7$lambda$6(library, this, arg_0);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(library, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (DataContext)object;
    }

    private final DataContext createModuleNavigatableDataContext(Module module) {
        return arg_0 -> DataContextFactory.createModuleNavigatableDataContext$lambda$8(module, arg_0);
    }

    private final DataContext createOpenFileDescriptorDataContext(Project project, VirtualFile file2) {
        return arg_0 -> DataContextFactory.createOpenFileDescriptorDataContext$lambda$9(project, file2, arg_0);
    }

    private static final Object getOrCreateDataContext$lambda$3$lambda$2(Function3 $findPackageDeclaration, VirtualFile $file, Module $module, Package $pkg, DataContextFactory this$0, String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$findPackageDeclaration, (String)"$findPackageDeclaration");
        Intrinsics.checkNotNullParameter((Object)$pkg, (String)"$pkg");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            object = (PsiElement)$findPackageDeclaration.invoke((Object)$file, (Object)$module, (Object)$pkg);
            if (object == null) {
                object = new OpenFileDescriptor(this$0.project, $file);
            }
        } else {
            object = PlatformCoreDataKeys.MODULE.is(dataId) ? $module : null;
        }
        return object;
    }

    private static final Object getOrCreateDataContext$lambda$7$lambda$6(Library $library, DataContextFactory this$0, String dataKey) {
        Intrinsics.checkNotNullParameter((Object)$library, (String)"$library");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        return CommonDataKeys.NAVIGATABLE.is(dataKey) ? new ProjectLibraryNavigatable($library, this$0.project) : null;
    }

    private static final Object createModuleNavigatableDataContext$lambda$8(Module $module, String dataId) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return CommonDataKeys.NAVIGATABLE.is(dataId) ? new ModuleNavigatable($module) : (PlatformCoreDataKeys.MODULE.is(dataId) ? $module : null);
    }

    private static final Object createOpenFileDescriptorDataContext$lambda$9(Project $project, VirtualFile $file, String dataId) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return CommonDataKeys.NAVIGATABLE.is(dataId) ? new OpenFileDescriptor($project, $file) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/packageChecker/DataContextFactory$Companion;", "", "()V", "getInstance", "Lcom/intellij/packageChecker/DataContextFactory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataContextFactory getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DataContextFactory.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DataContextFactory)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

