/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.inspectionKts.InspectionKtsClassLoader;
import org.jetbrains.qodana.inspectionKts.InspectionKtsPluginWithSubModulesClassLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\b\u001a\u00020\tH\u0014J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/inspectionKts/InspectionKtsClassLoader;", "Ljava/lang/ClassLoader;", "()V", "myLuckyGuess", "Ljava/util/concurrent/ConcurrentMap;", "", "findClass", "Ljava/lang/Class;", "name", "", "findResource", "Ljava/net/URL;", "findResources", "Ljava/util/Enumeration;", "getUrls", "", "Companion", "intellij.qodana"})
public final class InspectionKtsClassLoader
extends ClassLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Long, ClassLoader> myLuckyGuess = new ConcurrentHashMap();

    public InspectionKtsClassLoader() {
        super(null);
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        String string;
        int p1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int p0 = StringsKt.indexOf$default((CharSequence)name, (String)"$", (int)0, (boolean)false, (int)6, null);
        boolean hasBase = p0 > 0;
        int n = p1 = hasBase ? StringsKt.indexOf$default((CharSequence)name, (String)"$", (int)(p0 + 1), (boolean)false, (int)4, null) : -1;
        if (hasBase) {
            String string2 = name.substring(0, (int)Math.max((double)p0, (double)p1));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = name;
        }
        String base = string;
        long hash2 = StringHash.calc((String)base);
        Class<?> c = null;
        ClassLoader guess1 = (ClassLoader)this.myLuckyGuess.get(hash2);
        ClassLoader guess2 = (ClassLoader)this.myLuckyGuess.get(0L);
        Object[] objectArray = new ClassLoader[]{guess1, guess2};
        for (ClassLoader loader : JBIterable.of((Object[])objectArray)) {
            if (loader == this) {
                throw new ClassNotFoundException(name);
            }
            if (loader == null) continue;
            try {
                c = loader.loadClass(name);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (c == null) {
            for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                InspectionKtsPluginWithSubModulesClassLoader l = InspectionKtsPluginWithSubModulesClassLoader.Companion.forPlugin(descriptor2);
                if (l == null || !hasBase && (l == guess1 || l == guess2)) continue;
                try {
                    if (hasBase) {
                        l.loadClass(base);
                        this.myLuckyGuess.putIfAbsent(hash2, l);
                    }
                    try {
                        c = l.loadClass(name);
                        this.myLuckyGuess.putIfAbsent(hash2, l);
                        ((Map)this.myLuckyGuess).put(0L, l);
                    }
                    catch (ClassNotFoundException e) {
                        if (hasBase || StringsKt.startsWith$default((String)name, (String)"java.", (boolean)false, (int)2, null)) break;
                        if (!StringsKt.startsWith$default((String)name, (String)"groovy.", (boolean)false, (int)2, null)) continue;
                    }
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (c != null) {
            return c;
        }
        this.myLuckyGuess.putIfAbsent(hash2, this);
        throw new ClassNotFoundException(name);
    }

    @Override
    @NotNull
    protected URL findResource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (InspectionKtsClassLoader.Companion.isAllowedPluginResource(name)) {
            for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                URL url;
                ClassLoader l;
                ClassLoader classLoader = l = descriptor2.getPluginClassLoader();
                URL uRL = url = classLoader != null ? classLoader.getResource(name) : null;
                if (uRL == null) continue;
                return uRL;
            }
        }
        URL uRL = this.getClass().getClassLoader().getResource(name);
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
        return uRL;
    }

    @Override
    @NotNull
    protected Enumeration<URL> findResources(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (InspectionKtsClassLoader.Companion.isAllowedPluginResource(name)) {
            Set result2 = null;
            for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                Enumeration<URL> urls;
                ClassLoader l;
                ClassLoader classLoader = l = descriptor2.getPluginClassLoader();
                Enumeration<URL> enumeration = urls = classLoader != null ? classLoader.getResources(name) : null;
                if (urls == null || !urls.hasMoreElements()) continue;
                if (result2 == null) {
                    result2 = new LinkedHashSet();
                }
                ContainerUtil.addAll((Collection)result2, urls);
            }
            if (result2 != null) {
                Enumeration<URL> enumeration = Collections.enumeration(result2);
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
                return enumeration;
            }
        }
        Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(name);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        return enumeration;
    }

    @NotNull
    public final List<URL> getUrls() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        List list2 = JBIterable.of((Object[])Arrays.copyOf(ideaPluginDescriptorArray, ideaPluginDescriptorArray.length)).map((Function)getUrls.1.INSTANCE).unique().flatMap((Function)getUrls.2.INSTANCE).unique().toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        return CollectionsKt.filterNotNull((Iterable)list2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/inspectionKts/InspectionKtsClassLoader$Companion;", "", "()V", "isAllowedPluginResource", "", "name", "", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAllowedPluginResource(String name) {
            return Intrinsics.areEqual((Object)"META-INF/services/javax.script.ScriptEngineFactory", (Object)name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

