/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystemProvider;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiRoutingFileSystem
extends DelegatingFileSystem<MultiRoutingFileSystemProvider> {
    private final MultiRoutingFileSystemProvider myProvider;
    private final FileSystem myLocalFS;
    private final AtomicReference<@NotNull List<@NotNull Backend>> myBackends = new AtomicReference(Collections.emptyList());

    public MultiRoutingFileSystem(MultiRoutingFileSystemProvider provider, FileSystem localFS) {
        this.myProvider = provider;
        this.myLocalFS = localFS;
    }

    void computeBackend(@NotNull String root, boolean isPrefix, boolean caseSensitive, BiFunction<? super @NotNull FileSystemProvider, ? super @Nullable FileSystem, @Nullable FileSystem> compute) {
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(0);
        }
        this.myBackends.updateAndGet(oldList -> {
            ArrayList<@NotNull E> newList = new ArrayList(oldList);
            ListIterator<@NotNull Backend> iter = newList.listIterator();
            FileSystem newFs = null;
            while (iter.hasNext()) {
                Backend current = (Backend)iter.next();
                if (!current.root.equals(root)) continue;
                iter.remove();
                newFs = (FileSystem)compute.apply(this.myProvider.myLocalProvider, current.fileSystem);
                if (newFs != null) break;
                return newList;
            }
            if (newFs == null && (newFs = (FileSystem)compute.apply(this.myProvider.myLocalProvider, null)) == null) {
                return newList;
            }
            iter.add(new Backend(root, isPrefix, caseSensitive, newFs));
            newList.sort((r1, r2) -> r2.root.length() - r1.root.length());
            return newList;
        });
    }

    @Override
    @NotNull
    public MultiRoutingFileSystemProvider provider() {
        MultiRoutingFileSystemProvider multiRoutingFileSystemProvider = this.myProvider;
        if (multiRoutingFileSystemProvider == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(1);
        }
        return multiRoutingFileSystemProvider;
    }

    @Override
    @NotNull
    protected FileSystem getDelegate() {
        FileSystem fileSystem = this.myLocalFS;
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(2);
        }
        return fileSystem;
    }

    @Override
    @NotNull
    protected FileSystem getDelegate(@NotNull String root) {
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(3);
        }
        if (MultiRoutingFileSystemProvider.ourForceDefaultFs) {
            FileSystem fileSystem = this.myLocalFS;
            if (fileSystem == null) {
                MultiRoutingFileSystem.$$$reportNull$$$0(4);
            }
            return fileSystem;
        }
        FileSystem fileSystem = this.getBackend(root);
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(5);
        }
        return fileSystem;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        LinkedHashMap<String, Path> rootDirectories = new LinkedHashMap<String, Path>();
        for (Path root : this.myLocalFS.getRootDirectories()) {
            rootDirectories.put(root.toString(), root);
        }
        block1: for (Backend backend : this.myBackends.get()) {
            for (Path candidate : backend.fileSystem.getRootDirectories()) {
                if (!backend.matchRoot(candidate.toString())) continue;
                rootDirectories.put(candidate.toString(), candidate);
                continue block1;
            }
        }
        return rootDirectories.values();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        LinkedHashSet<FileStore> result = new LinkedHashSet<FileStore>();
        for (FileStore fileStore : this.myLocalFS.getFileStores()) {
            result.add(fileStore);
        }
        for (Backend backend : this.myBackends.get()) {
            for (FileStore fileStore : backend.fileSystem.getFileStores()) {
                result.add(fileStore);
            }
        }
        return result;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        HashSet<String> result = new HashSet<String>(this.myLocalFS.supportedFileAttributeViews());
        for (Backend backend : this.myBackends.get()) {
            result.addAll(backend.fileSystem.supportedFileAttributeViews());
        }
        return result;
    }

    @NotNull
    FileSystem getBackend(@NotNull String root) {
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(6);
        }
        for (Backend backend : this.myBackends.get()) {
            if (!backend.matchRoot(root)) continue;
            FileSystem fileSystem = backend.fileSystem;
            if (fileSystem == null) {
                MultiRoutingFileSystem.$$$reportNull$$$0(7);
            }
            return fileSystem;
        }
        FileSystem fileSystem = this.myLocalFS;
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(8);
        }
        return fileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "provider";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeBackend";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBackend";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Backend {
        @NotNull
        final String root;
        final boolean prefix;
        final boolean caseSensitive;
        @NotNull
        final FileSystem fileSystem;

        Backend(@NotNull String root, boolean prefix, boolean caseSensitive, @NotNull FileSystem fileSystem) {
            if (root == null) {
                Backend.$$$reportNull$$$0(0);
            }
            if (fileSystem == null) {
                Backend.$$$reportNull$$$0(1);
            }
            this.root = root;
            this.prefix = prefix;
            this.caseSensitive = caseSensitive;
            this.fileSystem = fileSystem;
        }

        boolean matchRoot(@NotNull String candidate) {
            if (candidate == null) {
                Backend.$$$reportNull$$$0(2);
            }
            if (!this.prefix && candidate.length() != this.root.length()) {
                return false;
            }
            return candidate.regionMatches(!this.caseSensitive, 0, this.root, 0, this.root.length());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSystem";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem$Backend";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

