/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.wrapper;

import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.wrapper.MethodCall;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TraceUtil {
    private static final String THREE_DOTS = "...";

    public static List<TraceElement> sortedByTime(@NotNull Collection<? extends TraceElement> values) {
        if (values == null) {
            TraceUtil.$$$reportNull$$$0(0);
        }
        return values.stream().sorted(Comparator.comparing(TraceElement::getTime)).collect(Collectors.toList());
    }

    @Nullable
    public static Object extractKey(@NotNull TraceElement element) {
        Value value;
        if (element == null) {
            TraceUtil.$$$reportNull$$$0(1);
        }
        if (!((value = element.getValue()) instanceof PrimitiveValue)) {
            return value;
        }
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).value();
        }
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).value();
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).value();
        }
        if (value instanceof ByteValue) {
            return ((ByteValue)value).value();
        }
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).value());
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).value());
        }
        throw new RuntimeException("unknown primitive value: " + value.type().name());
    }

    @NotNull
    @NlsSafe
    public static String formatWithArguments(@NotNull MethodCall call2) {
        if (call2 == null) {
            TraceUtil.$$$reportNull$$$0(2);
        }
        String string = call2.getName() + StreamEx.of(call2.getArguments()).map(x -> StringUtil.shortenTextWithEllipsis((String)x.getText().replaceAll("\\s", ""), (int)30, (int)5, (String)THREE_DOTS)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        if (string == null) {
            TraceUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String formatQualifierExpression(@NotNull String expression, int maxLength) {
        if (expression == null) {
            TraceUtil.$$$reportNull$$$0(4);
        }
        if ((expression = expression.replaceAll("\\s", "").replaceAll(",", ", ")).length() < maxLength) {
            String string = expression;
            if (string == null) {
                TraceUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (expression.isEmpty()) {
            return "qualifier";
        }
        String string = StringUtil.shortenTextWithEllipsis((String)expression, (int)(maxLength - 8), (int)5, (String)THREE_DOTS);
        if (string == null) {
            TraceUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/wrapper/TraceUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/wrapper/TraceUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatWithArguments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatQualifierExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortedByTime";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractKey";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatWithArguments";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatQualifierExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

