/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.deobfuscator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.CancellationManager;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.GenericDominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraph;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;
import org.jetbrains.java.decompiler.struct.StructClass;

public final class ExceptionDeobfuscator {
    public static void restorePopRanges(ControlFlowGraph graph) {
        CancellationManager cancellationManager = DecompilerContext.getCancellationManager();
        ArrayList<Range> lstRanges = new ArrayList<Range>();
        for (ExceptionRangeCFG exceptionRangeCFG : graph.getExceptions()) {
            boolean found = false;
            for (Range arr : lstRanges) {
                if (arr.handler != exceptionRangeCFG.getHandler() || !Objects.equals(exceptionRangeCFG.getUniqueExceptionsString(), arr.uniqueStr)) continue;
                arr.protectedRange.addAll(exceptionRangeCFG.getProtectedRange());
                found = true;
                break;
            }
            if (found) continue;
            lstRanges.add(new Range(exceptionRangeCFG.getHandler(), exceptionRangeCFG.getUniqueExceptionsString(), new HashSet<BasicBlock>(exceptionRangeCFG.getProtectedRange()), exceptionRangeCFG));
        }
        for (Range range : lstRanges) {
            BasicBlock handler;
            InstructionSequence seq;
            if (range.uniqueStr == null || (seq = (handler = range.handler).getSeq()).isEmpty()) continue;
            Instruction firstinstr = seq.getInstr(0);
            if (firstinstr.opcode != 87 && firstinstr.opcode != 58) continue;
            HashSet<BasicBlock> setrange = new HashSet<BasicBlock>(range.protectedRange);
            for (Range range_super : lstRanges) {
                cancellationManager.checkCanceled();
                if (range == range_super) continue;
                HashSet<BasicBlock> setrange_super = new HashSet<BasicBlock>(range_super.protectedRange);
                if (setrange.contains(range_super.handler) || setrange_super.contains(handler) || range_super.uniqueStr != null && !setrange_super.containsAll(setrange)) continue;
                if (range_super.uniqueStr == null) {
                    setrange_super.retainAll(setrange);
                } else {
                    setrange_super.removeAll(setrange);
                }
                if (setrange_super.isEmpty()) continue;
                BasicBlock newBlock = handler;
                if (seq.length() > 1) {
                    SimpleInstructionSequence newSeq = new SimpleInstructionSequence();
                    newSeq.addInstruction(firstinstr.clone(), -1);
                    newBlock = new BasicBlock(++graph.last_id, newSeq);
                    graph.getBlocks().addWithKey(newBlock, newBlock.id);
                    ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>();
                    lstTemp.addAll(handler.getPredecessors());
                    lstTemp.addAll(handler.getPredecessorExceptions());
                    for (BasicBlock pred : lstTemp) {
                        pred.replaceSuccessor(handler, newBlock);
                    }
                    for (ExceptionRangeCFG range_ext : graph.getExceptions()) {
                        if (range_ext.getHandler() == handler) {
                            range_ext.setHandler(newBlock);
                            continue;
                        }
                        if (!range_ext.getProtectedRange().contains(handler)) continue;
                        newBlock.addSuccessorException(range_ext.getHandler());
                        range_ext.getProtectedRange().add(newBlock);
                    }
                    newBlock.addSuccessor(handler);
                    if (graph.getFirst() == handler) {
                        graph.setFirst(newBlock);
                    }
                    seq.removeInstruction(0);
                }
                newBlock.addSuccessorException(range_super.handler);
                range_super.rangeCFG.getProtectedRange().add(newBlock);
                handler = range.rangeCFG.getHandler();
                seq = handler.getSeq();
            }
        }
    }

    public static void insertEmptyExceptionHandlerBlocks(ControlFlowGraph graph) {
        HashSet<BasicBlock> setVisited = new HashSet<BasicBlock>();
        for (ExceptionRangeCFG range : graph.getExceptions()) {
            BasicBlock handler = range.getHandler();
            if (setVisited.contains(handler)) continue;
            setVisited.add(handler);
            BasicBlock emptyblock = new BasicBlock(++graph.last_id);
            graph.getBlocks().addWithKey(emptyblock, emptyblock.id);
            ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>(handler.getPredecessorExceptions());
            for (BasicBlock pred : lstTemp) {
                pred.replaceSuccessor(handler, emptyblock);
            }
            for (ExceptionRangeCFG range_ext : graph.getExceptions()) {
                if (range_ext.getHandler() == handler) {
                    range_ext.setHandler(emptyblock);
                    continue;
                }
                if (!range_ext.getProtectedRange().contains(handler)) continue;
                emptyblock.addSuccessorException(range_ext.getHandler());
                range_ext.getProtectedRange().add(emptyblock);
            }
            emptyblock.addSuccessor(handler);
            if (graph.getFirst() != handler) continue;
            graph.setFirst(emptyblock);
        }
    }

    public static void removeEmptyRanges(ControlFlowGraph graph) {
        List<ExceptionRangeCFG> lstRanges = graph.getExceptions();
        for (int i = lstRanges.size() - 1; i >= 0; --i) {
            ExceptionRangeCFG range = lstRanges.get(i);
            boolean isEmpty = true;
            for (BasicBlock block : range.getProtectedRange()) {
                if (block.getSeq().isEmpty()) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            for (BasicBlock block : range.getProtectedRange()) {
                block.removeSuccessorException(range.getHandler());
            }
            lstRanges.remove(i);
        }
    }

    public static void removeCircularRanges(final ControlFlowGraph graph) {
        GenericDominatorEngine engine = new GenericDominatorEngine(new IGraph(){

            @Override
            public List<? extends IGraphNode> getReversePostOrderList() {
                return graph.getReversePostOrder();
            }

            @Override
            public Set<? extends IGraphNode> getRoots() {
                return new HashSet<BasicBlock>(Collections.singletonList(graph.getFirst()));
            }
        });
        engine.initialize();
        List<ExceptionRangeCFG> lstRanges = graph.getExceptions();
        for (int i = lstRanges.size() - 1; i >= 0; --i) {
            ExceptionRangeCFG range = lstRanges.get(i);
            BasicBlock handler = range.getHandler();
            List<BasicBlock> rangeList = range.getProtectedRange();
            if (!rangeList.contains(handler)) continue;
            List<BasicBlock> lstRemBlocks = ExceptionDeobfuscator.getReachableBlocksRestricted(range.getHandler(), range, engine);
            if (lstRemBlocks.size() < rangeList.size() || rangeList.size() == 1) {
                for (BasicBlock block : lstRemBlocks) {
                    block.removeSuccessorException(handler);
                    rangeList.remove(block);
                }
            }
            if (!rangeList.isEmpty()) continue;
            lstRanges.remove(i);
        }
    }

    private static List<BasicBlock> getReachableBlocksRestricted(BasicBlock start, ExceptionRangeCFG range, GenericDominatorEngine engine) {
        ArrayList<BasicBlock> lstRes = new ArrayList<BasicBlock>();
        LinkedList<BasicBlock> stack = new LinkedList<BasicBlock>();
        HashSet<BasicBlock> setVisited = new HashSet<BasicBlock>();
        stack.addFirst(start);
        while (!stack.isEmpty()) {
            BasicBlock block = (BasicBlock)stack.removeFirst();
            setVisited.add(block);
            if (!range.getProtectedRange().contains(block) || !engine.isDominator(block, start)) continue;
            lstRes.add(block);
            ArrayList<BasicBlock> lstSuccs = new ArrayList<BasicBlock>(block.getSuccessors());
            lstSuccs.addAll(block.getSuccessorExceptions());
            for (BasicBlock succ : lstSuccs) {
                if (setVisited.contains(succ)) continue;
                stack.add(succ);
            }
        }
        return lstRes;
    }

    public static boolean hasObfuscatedExceptions(ControlFlowGraph graph) {
        HashMap<BasicBlock, Set> mapRanges = new HashMap<BasicBlock, Set>();
        for (ExceptionRangeCFG exceptionRangeCFG : graph.getExceptions()) {
            mapRanges.computeIfAbsent(exceptionRangeCFG.getHandler(), k -> new HashSet()).addAll(exceptionRangeCFG.getProtectedRange());
        }
        for (Map.Entry entry : mapRanges.entrySet()) {
            HashSet<BasicBlock> setEntries = new HashSet<BasicBlock>();
            for (BasicBlock block : (Set)entry.getValue()) {
                HashSet<BasicBlock> setTemp = new HashSet<BasicBlock>(block.getPredecessors());
                setTemp.removeAll((Collection)entry.getValue());
                if (setTemp.isEmpty()) continue;
                setEntries.add(block);
            }
            if (setEntries.isEmpty() || setEntries.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean handleMultipleEntryExceptionRanges(final ControlFlowGraph graph) {
        boolean found;
        boolean splitted;
        GenericDominatorEngine engine = new GenericDominatorEngine(new IGraph(){

            @Override
            public List<? extends IGraphNode> getReversePostOrderList() {
                return graph.getReversePostOrder();
            }

            @Override
            public Set<? extends IGraphNode> getRoots() {
                return new HashSet<BasicBlock>(Collections.singletonList(graph.getFirst()));
            }
        });
        engine.initialize();
        block0: do {
            found = false;
            splitted = false;
            for (ExceptionRangeCFG range : graph.getExceptions()) {
                Set<BasicBlock> setEntries = ExceptionDeobfuscator.getRangeEntries(range);
                if (setEntries.size() <= 1) continue;
                found = true;
                if (!ExceptionDeobfuscator.splitExceptionRange(range, setEntries, graph, engine)) continue;
                splitted = true;
                continue block0;
            }
        } while (splitted);
        return !found;
    }

    private static Set<BasicBlock> getRangeEntries(ExceptionRangeCFG range) {
        HashSet<BasicBlock> setEntries = new HashSet<BasicBlock>();
        HashSet<BasicBlock> setRange = new HashSet<BasicBlock>(range.getProtectedRange());
        for (BasicBlock block : range.getProtectedRange()) {
            HashSet<BasicBlock> setPreds = new HashSet<BasicBlock>(block.getPredecessors());
            setPreds.removeAll(setRange);
            if (setPreds.isEmpty()) continue;
            setEntries.add(block);
        }
        return setEntries;
    }

    private static boolean splitExceptionRange(ExceptionRangeCFG range, Set<BasicBlock> setEntries, ControlFlowGraph graph, GenericDominatorEngine engine) {
        for (BasicBlock entry : setEntries) {
            List<BasicBlock> lstSubrangeBlocks = ExceptionDeobfuscator.getReachableBlocksRestricted(entry, range, engine);
            if (!lstSubrangeBlocks.isEmpty() && lstSubrangeBlocks.size() < range.getProtectedRange().size()) {
                ExceptionRangeCFG subRange = new ExceptionRangeCFG(lstSubrangeBlocks, range.getHandler(), range.getExceptionTypes());
                graph.getExceptions().add(subRange);
                range.getProtectedRange().removeAll(lstSubrangeBlocks);
                return true;
            }
            DecompilerContext.getLogger().writeMessage("Inconsistency found while splitting protected range", IFernflowerLogger.Severity.WARN);
        }
        return false;
    }

    public static void duplicateMergedCatchBlocks(@NotNull ControlFlowGraph graph, @NotNull StructClass cl) {
        if (graph == null) {
            ExceptionDeobfuscator.$$$reportNull$$$0(0);
        }
        if (cl == null) {
            ExceptionDeobfuscator.$$$reportNull$$$0(1);
        }
        if (!cl.hasRecordPatternSupport()) {
            return;
        }
        HashMap<BasicBlock, Set> mapRanges = new HashMap<BasicBlock, Set>();
        for (ExceptionRangeCFG exceptionRangeCFG : graph.getExceptions()) {
            mapRanges.computeIfAbsent(exceptionRangeCFG.getHandler(), k -> new HashSet()).add(exceptionRangeCFG);
        }
        for (Map.Entry entry : mapRanges.entrySet()) {
            BasicBlock handler = (BasicBlock)entry.getKey();
            Set ranges = (Set)entry.getValue();
            if (ranges.size() == 1 || handler.getLastInstruction().opcode != 191) continue;
            Set exceptions = ranges.stream().map(t -> t.getExceptionTypes()).flatMap(t -> t != null ? t.stream() : Stream.empty()).collect(Collectors.toSet());
            List<BasicBlock> successors = handler.getSuccessors();
            if (successors == null || successors.size() != 1 || !successors.get(0).getSuccessors().isEmpty() || !successors.get(0).getSuccessorExceptions().isEmpty() || exceptions.size() != 1 || exceptions.contains(null)) continue;
            for (ExceptionRangeCFG range : ranges) {
                BasicBlock newHandler = handler.clone(++graph.last_id);
                graph.getBlocks().addWithKey(newHandler, newHandler.id);
                ArrayList<BasicBlock> lstPredExceptions = new ArrayList<BasicBlock>(handler.getPredecessorExceptions());
                lstPredExceptions.retainAll(range.getProtectedRange());
                for (BasicBlock pred : lstPredExceptions) {
                    ExceptionRangeCFG previousEdge = graph.getExceptionRange(handler, pred);
                    pred.replaceSuccessor(handler, newHandler);
                    if (previousEdge == null) continue;
                    previousEdge.setHandler(newHandler);
                }
                ArrayList<BasicBlock> scExceptions = new ArrayList<BasicBlock>(handler.getSuccessorExceptions());
                for (BasicBlock nextException : scExceptions) {
                    ExceptionRangeCFG nextEdge = graph.getExceptionRange(nextException, handler);
                    newHandler.addSuccessorException(nextException);
                    nextEdge.getProtectedRange().add(newHandler);
                }
                newHandler.addSuccessor(successors.get(0));
                for (BasicBlock successorException : handler.getSuccessorExceptions()) {
                    newHandler.addSuccessorException(successorException);
                    ExceptionRangeCFG previousEdge = graph.getExceptionRange(successorException, handler);
                    if (previousEdge == null) continue;
                    ArrayList<BasicBlock> newRanges = new ArrayList<BasicBlock>();
                    newRanges.add(newHandler);
                    ExceptionRangeCFG subRange = new ExceptionRangeCFG(newRanges, successorException, previousEdge.getExceptionTypes());
                    graph.getExceptions().add(subRange);
                    successorException.addPredecessorException(newHandler);
                }
                range.setHandler(newHandler);
            }
            for (BasicBlock successorException : handler.getSuccessorExceptions()) {
                successorException.removePredecessorException(handler);
                if (!successorException.getPredecessorExceptions().isEmpty()) continue;
                graph.removeBlock(successorException);
            }
            graph.removeBlock(handler);
        }
    }

    public static void insertDummyExceptionHandlerBlocks(ControlFlowGraph graph, int bytecode_version) {
        HashMap<BasicBlock, Set> mapRanges = new HashMap<BasicBlock, Set>();
        for (ExceptionRangeCFG exceptionRangeCFG : graph.getExceptions()) {
            mapRanges.computeIfAbsent(exceptionRangeCFG.getHandler(), k -> new HashSet()).add(exceptionRangeCFG);
        }
        for (Map.Entry entry : mapRanges.entrySet()) {
            BasicBlock handler = (BasicBlock)entry.getKey();
            Set ranges = (Set)entry.getValue();
            if (ranges.size() == 1) continue;
            for (ExceptionRangeCFG range : ranges) {
                SimpleInstructionSequence seq = new SimpleInstructionSequence();
                seq.addInstruction(Instruction.create(16, false, 1, bytecode_version, new int[]{0}), -1);
                seq.addInstruction(Instruction.create(87, false, 1, bytecode_version, null), -1);
                BasicBlock dummyBlock = new BasicBlock(++graph.last_id, seq);
                graph.getBlocks().addWithKey(dummyBlock, dummyBlock.id);
                ArrayList<BasicBlock> lstPredExceptions = new ArrayList<BasicBlock>(handler.getPredecessorExceptions());
                lstPredExceptions.retainAll(range.getProtectedRange());
                for (BasicBlock pred : lstPredExceptions) {
                    ExceptionRangeCFG previousEdge = graph.getExceptionRange(handler, pred);
                    pred.replaceSuccessor(handler, dummyBlock);
                    if (previousEdge == null) continue;
                    previousEdge.setHandler(dummyBlock);
                }
                range.setHandler(dummyBlock);
                HashSet<BasicBlock> commonHandlers = new HashSet<BasicBlock>(handler.getSuccessorExceptions());
                for (BasicBlock pred : lstPredExceptions) {
                    commonHandlers.retainAll(pred.getSuccessorExceptions());
                }
                for (BasicBlock commonHandler : commonHandlers) {
                    ExceptionRangeCFG commonRange = graph.getExceptionRange(commonHandler, handler);
                    dummyBlock.addSuccessorException(commonHandler);
                    commonRange.getProtectedRange().add(dummyBlock);
                }
                dummyBlock.addSuccessor(handler);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "graph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cl";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/java/decompiler/modules/decompiler/deobfuscator/ExceptionDeobfuscator";
        objectArray[2] = "duplicateMergedCatchBlocks";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Range {
        private final BasicBlock handler;
        private final String uniqueStr;
        private final Set<BasicBlock> protectedRange;
        private final ExceptionRangeCFG rangeCFG;

        private Range(BasicBlock handler, String uniqueStr, Set<BasicBlock> protectedRange, ExceptionRangeCFG rangeCFG) {
            this.handler = handler;
            this.uniqueStr = uniqueStr;
            this.protectedRange = protectedRange;
            this.rangeCFG = rangeCFG;
        }
    }
}

