/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;

public final class MergeHelper {
    public static void enhanceLoops(Statement root) {
        while (MergeHelper.enhanceLoopsRec(root)) {
        }
        SequenceHelper.condenseSequences(root);
    }

    private static boolean enhanceLoopsRec(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            if (st.getExprents() != null) continue;
            res |= MergeHelper.enhanceLoopsRec(st);
        }
        if (stat.type == Statement.StatementType.DO) {
            res |= MergeHelper.enhanceLoop((DoStatement)stat);
        }
        return res;
    }

    private static boolean enhanceLoop(DoStatement stat) {
        DoStatement.LoopType oldLoop = stat.getLoopType();
        switch (oldLoop) {
            case DO: {
                if (MergeHelper.matchWhile(stat)) {
                    MergeHelper.matchFor(stat);
                    break;
                }
                MergeHelper.matchDoWhile(stat);
                break;
            }
            case WHILE: {
                MergeHelper.matchFor(stat);
            }
        }
        return stat.getLoopType() != oldLoop;
    }

    private static void matchDoWhile(DoStatement stat) {
        Statement last = stat.getFirst();
        while (last.type == Statement.StatementType.SEQUENCE) {
            last = last.getStats().getLast();
        }
        if (last.type == Statement.StatementType.IF) {
            IfStatement lastif = (IfStatement)last;
            if (lastif.iftype == 0 && lastif.getIfstat() == null) {
                StatEdge ifedge = lastif.getIfEdge();
                StatEdge elseedge = lastif.getAllSuccessorEdges().get(0);
                if (ifedge.getType() == StatEdge.EdgeType.BREAK && elseedge.getType() == StatEdge.EdgeType.CONTINUE && elseedge.closure == stat && MergeHelper.isDirectPath(stat, ifedge.getDestination()) || ifedge.getType() == StatEdge.EdgeType.CONTINUE && elseedge.getType() == StatEdge.EdgeType.BREAK && ifedge.closure == stat && MergeHelper.isDirectPath(stat, elseedge.getDestination())) {
                    Set<Statement> set = stat.getNeighboursSet(StatEdge.EdgeType.CONTINUE, StatEdge.EdgeDirection.BACKWARD);
                    set.remove(last);
                    if (!set.isEmpty()) {
                        return;
                    }
                    stat.setLoopType(DoStatement.LoopType.DO_WHILE);
                    IfExprent ifexpr = (IfExprent)lastif.getHeadexprent().copy();
                    if (ifedge.getType() == StatEdge.EdgeType.BREAK) {
                        ifexpr.negateIf();
                    }
                    stat.setConditionExprent(ifexpr.getCondition());
                    lastif.getFirst().removeSuccessor(ifedge);
                    lastif.removeSuccessor(elseedge);
                    if (lastif.getFirst().getExprents().isEmpty()) {
                        MergeHelper.removeLastEmptyStatement(stat, lastif);
                    } else {
                        lastif.setExprents(lastif.getFirst().getExprents());
                        StatEdge newedge = new StatEdge(StatEdge.EdgeType.CONTINUE, (Statement)lastif, stat);
                        lastif.addSuccessor(newedge);
                        stat.addLabeledEdge(newedge);
                    }
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        StatEdge edge = elseedge.getType() == StatEdge.EdgeType.CONTINUE ? ifedge : elseedge;
                        edge.setSource(stat);
                        if (edge.closure == stat) {
                            edge.closure = stat.getParent();
                        }
                        stat.addSuccessor(edge);
                    }
                }
            }
        }
    }

    private static boolean matchWhile(DoStatement stat) {
        IfStatement firstif;
        Statement first = stat.getFirst();
        while (first.type == Statement.StatementType.SEQUENCE) {
            first = first.getFirst();
        }
        if (first.type == Statement.StatementType.IF && (firstif = (IfStatement)first).getFirst().getExprents().isEmpty() && firstif.iftype == 0) {
            if (firstif.getIfstat() == null) {
                StatEdge ifedge = firstif.getIfEdge();
                if (MergeHelper.isDirectPath(stat, ifedge.getDestination())) {
                    stat.setLoopType(DoStatement.LoopType.WHILE);
                    IfExprent ifexpr = (IfExprent)firstif.getHeadexprent().copy();
                    ifexpr.negateIf();
                    stat.setConditionExprent(ifexpr.getCondition());
                    firstif.getFirst().removeSuccessor(ifedge);
                    firstif.removeSuccessor(firstif.getAllSuccessorEdges().get(0));
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        ifedge.setSource(stat);
                        if (ifedge.closure == stat) {
                            ifedge.closure = stat.getParent();
                        }
                        stat.addSuccessor(ifedge);
                    }
                    if (firstif == stat.getFirst()) {
                        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                        bstat.setExprents(new ArrayList<Exprent>());
                        stat.replaceStatement(firstif, bstat);
                    } else {
                        Statement sequence = firstif.getParent();
                        sequence.getStats().removeWithKey(firstif.id);
                        sequence.setFirst((Statement)sequence.getStats().get(0));
                    }
                    return true;
                }
            } else {
                StatEdge elseedge = firstif.getAllSuccessorEdges().get(0);
                if (MergeHelper.isDirectPath(stat, elseedge.getDestination())) {
                    stat.setLoopType(DoStatement.LoopType.WHILE);
                    stat.setConditionExprent(((IfExprent)firstif.getHeadexprent().copy()).getCondition());
                    StatEdge ifedge = firstif.getIfEdge();
                    firstif.getFirst().removeSuccessor(ifedge);
                    firstif.removeSuccessor(elseedge);
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        elseedge.setSource(stat);
                        if (elseedge.closure == stat) {
                            elseedge.closure = stat.getParent();
                        }
                        stat.addSuccessor(elseedge);
                    }
                    if (firstif.getIfstat() == null) {
                        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                        bstat.setExprents(new ArrayList<Exprent>());
                        ifedge.setSource(bstat);
                        bstat.addSuccessor(ifedge);
                        stat.replaceStatement(firstif, bstat);
                    } else {
                        first.getParent().replaceStatement(first, firstif.getIfstat());
                        for (StatEdge prededge : elseedge.getDestination().getPredecessorEdges(StatEdge.EdgeType.BREAK)) {
                            if (!stat.containsStatementStrict(prededge.closure)) continue;
                            stat.addLabeledEdge(prededge);
                        }
                        LabelHelper.lowClosures(stat);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDirectPath(Statement stat, Statement endstat) {
        Set<Statement> setStat = stat.getNeighboursSet(StatEdge.EdgeType.DIRECT_ALL, StatEdge.EdgeDirection.FORWARD);
        if (setStat.isEmpty()) {
            Statement parent = stat.getParent();
            if (parent == null) {
                return false;
            }
            switch (parent.type) {
                case ROOT: {
                    return endstat.type == Statement.StatementType.DUMMY_EXIT;
                }
                case DO: {
                    return endstat == parent;
                }
                case SWITCH: {
                    SwitchStatement swst = (SwitchStatement)parent;
                    for (int i = 0; i < swst.getCaseStatements().size() - 1; ++i) {
                        Statement stt = swst.getCaseStatements().get(i);
                        if (stt != stat) continue;
                        Statement stnext = swst.getCaseStatements().get(i + 1);
                        if (stnext.getExprents() != null && stnext.getExprents().isEmpty()) {
                            stnext = stnext.getAllSuccessorEdges().get(0).getDestination();
                        }
                        return endstat == stnext;
                    }
                    break;
                }
            }
            return MergeHelper.isDirectPath(parent, endstat);
        }
        return setStat.contains(endstat);
    }

    private static void matchFor(DoStatement stat) {
        Statement parent;
        boolean haslast;
        Statement preData = null;
        Statement lastData = MergeHelper.getLastDirectData(stat.getFirst());
        if (lastData == null || lastData.getExprents().isEmpty()) {
            return;
        }
        List<Exprent> lstExpr = lastData.getExprents();
        Exprent lastDoExprent = lstExpr.get(lstExpr.size() - 1);
        boolean issingle = false;
        if (lstExpr.size() == 1 && lastData.getAllPredecessorEdges().size() > 1) {
            issingle = true;
        }
        boolean bl = haslast = issingle || lastDoExprent.type == 2 || lastDoExprent.type == 6;
        if (!haslast) {
            return;
        }
        boolean hasinit = false;
        Statement current = stat;
        while ((parent = current.getParent()) != null && parent.type == Statement.StatementType.SEQUENCE) {
            if (current == parent.getFirst()) {
                current = parent;
                continue;
            }
            preData = current.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.BACKWARD).get(0);
            if ((preData = MergeHelper.getLastDirectData(preData)) == null || preData.getExprents().isEmpty()) break;
            Exprent initDoExprent = preData.getExprents().get(preData.getExprents().size() - 1);
            if (initDoExprent.type != 2) break;
            hasinit = true;
            break;
        }
        if (hasinit || issingle) {
            Set<Statement> set = stat.getNeighboursSet(StatEdge.EdgeType.CONTINUE, StatEdge.EdgeDirection.BACKWARD);
            set.remove(lastData);
            if (!set.isEmpty()) {
                return;
            }
            stat.setLoopType(DoStatement.LoopType.FOR);
            if (hasinit) {
                stat.setInitExprent(preData.getExprents().remove(preData.getExprents().size() - 1));
            }
            stat.setIncExprent(lastData.getExprents().remove(lastData.getExprents().size() - 1));
        }
        if (lastData.getExprents().isEmpty()) {
            List<StatEdge> lst = lastData.getAllSuccessorEdges();
            if (!lst.isEmpty()) {
                lastData.removeSuccessor(lst.get(0));
            }
            MergeHelper.removeLastEmptyStatement(stat, lastData);
        }
    }

    private static void removeLastEmptyStatement(DoStatement dostat, Statement stat) {
        if (stat == dostat.getFirst()) {
            BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            bstat.setExprents(new ArrayList<Exprent>());
            dostat.replaceStatement(stat, bstat);
        } else {
            for (StatEdge edge : stat.getAllPredecessorEdges()) {
                edge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, edge, StatEdge.EdgeType.CONTINUE);
                stat.removePredecessor(edge);
                edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, dostat);
                dostat.addPredecessor(edge);
                dostat.addLabeledEdge(edge);
            }
            stat.getParent().getStats().removeWithKey(stat.id);
        }
    }

    private static Statement getLastDirectData(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        if (stat.type == Statement.StatementType.SEQUENCE) {
            for (int i = stat.getStats().size() - 1; i >= 0; --i) {
                Statement tmp = MergeHelper.getLastDirectData((Statement)stat.getStats().get(i));
                if (tmp != null && tmp.getExprents().isEmpty()) continue;
                return tmp;
            }
        }
        return null;
    }
}

