/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ShortDescriptionProvider;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FalseFriendRuleLoader
extends DefaultHandler {
    private final String falseFriendHint;
    private final String falseFriendSugg;

    public FalseFriendRuleLoader(Language motherTongue) {
        ResourceBundle messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", motherTongue.getLocale());
        this.falseFriendHint = messages.getString("false_friend_hint");
        this.falseFriendSugg = messages.getString("false_friend_suggestion");
    }

    public FalseFriendRuleLoader(String falseFriendHint, String falseFriendSugg) {
        this.falseFriendHint = Objects.requireNonNull(falseFriendHint);
        this.falseFriendSugg = Objects.requireNonNull(falseFriendSugg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<AbstractPatternRule> getRules(File file2, Language language, Language motherTongue) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file2);){
            List<AbstractPatternRule> list = this.getRules(inputStream, language, motherTongue);
            return list;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Could not load false friend rules from " + file2, e);
        }
    }

    public final List<AbstractPatternRule> getRules(InputStream stream, Language textLanguage, Language motherTongue) throws ParserConfigurationException, SAXException, IOException {
        FalseFriendRuleHandler handler = new FalseFriendRuleHandler(textLanguage, motherTongue, this.falseFriendHint);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxParser.parse(stream, (DefaultHandler)handler);
        List<AbstractPatternRule> rules = handler.getRules();
        ArrayList<AbstractPatternRule> filteredRules = new ArrayList<AbstractPatternRule>();
        MessageFormat msgFormat = new MessageFormat(this.falseFriendSugg);
        ShortDescriptionProvider descProvider = new ShortDescriptionProvider();
        for (AbstractPatternRule rule : rules) {
            String patternStr = rule.getPatternTokens().stream().map(k -> k.getString()).collect(Collectors.joining(" "));
            List<String> suggestions = handler.getSuggestionMap().get(rule.getId());
            if (suggestions == null) continue;
            ArrayList<String> formattedSuggestions = new ArrayList<String>();
            for (String suggestion : suggestions) {
                if (patternStr.equalsIgnoreCase(suggestion)) continue;
                String desc = descProvider.getShortDescription(suggestion, textLanguage);
                if (desc != null) {
                    formattedSuggestions.add("<suggestion>" + suggestion + "</suggestion> (" + desc + ")");
                    continue;
                }
                formattedSuggestions.add("<suggestion>" + suggestion + "</suggestion>");
            }
            if (formattedSuggestions.size() <= 0) continue;
            String joined = String.join((CharSequence)", ", formattedSuggestions);
            rule.setMessage(rule.getMessage() + " " + msgFormat.format(new String[]{joined}));
            filteredRules.add(rule);
        }
        return filteredRules;
    }
}

