/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.similarity;

import ai.grazie.nlp.similarity.TextDistance;
import ai.grazie.nlp.similarity.TextSimilarity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\f"}, d2={"Lai/grazie/nlp/similarity/Levenshtein;", "Lai/grazie/nlp/similarity/TextDistance;", "Lai/grazie/nlp/similarity/TextSimilarity;", "()V", "distance", "", "first", "", "second", "limit", "similarity", "", "nlp-similarity"})
public final class Levenshtein
implements TextDistance,
TextSimilarity {
    @NotNull
    public static final Levenshtein INSTANCE = new Levenshtein();

    private Levenshtein() {
    }

    @Override
    public int distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return this.distance(first, second, Integer.MAX_VALUE);
    }

    @Override
    public double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return this.similarity(first, second, Integer.MAX_VALUE);
    }

    public final double similarity(@NotNull String first, @NotNull String second, int limit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        return 1.0 - (double)this.distance(first, second, limit) / (double)Math.max(first.length(), second.length());
    }

    public final int distance(@NotNull String first, @NotNull String second, int limit) {
        int i;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0;
        }
        if (((CharSequence)first).length() == 0) {
            return second.length();
        }
        if (((CharSequence)second).length() == 0) {
            return first.length();
        }
        int[] v0 = new int[second.length() + 1];
        int[] v1 = new int[second.length() + 1];
        int[] vtemp = null;
        int n = v0.length;
        for (i = 0; i < n; ++i) {
            v0[i] = i;
        }
        n = first.length();
        for (i = 0; i < n; ++i) {
            v1[0] = i + 1;
            int minv1 = v1[0];
            int n2 = second.length();
            for (int j = 0; j < n2; ++j) {
                int cost = 1;
                if (first.charAt(i) == second.charAt(j)) {
                    cost = 0;
                }
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + cost));
                minv1 = Math.min(minv1, v1[j + 1]);
            }
            if (minv1 >= limit) {
                return limit;
            }
            vtemp = v0;
            v0 = v1;
            v1 = vtemp;
        }
        return v0[second.length()];
    }
}

