/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/DownToHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "preferJavaLikeCounterLoop", "", "progressionElementTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "matchIterable", "expression", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionHeaderInfo;", "data", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "convertToExclusiveLowerBound", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "progressionType", "ir.backend.common"})
public final class DownToHandler
implements HeaderInfoHandler<IrCall, ProgressionType> {
    @NotNull
    private final CommonBackendContext context;
    private final boolean preferJavaLikeCounterLoop;
    @NotNull
    private final Collection<IrType> progressionElementTypes;

    public DownToHandler(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.preferJavaLikeCounterLoop = this.context.getPreferJavaLikeCounterLoop();
        this.progressionElementTypes = this.context.getIr().getSymbols().getProgressionElementTypes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchIterable(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression.getSymbol().getOwner();
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(callee.getValueParameters());
        if (!CollectionsKt.contains((Iterable)this.progressionElementTypes, (Object)(irValueParameter != null ? irValueParameter.getType() : null))) return false;
        IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
        if (!CollectionsKt.contains((Iterable)this.progressionElementTypes, (Object)(irValueParameter2 != null ? irValueParameter2.getType() : null))) return false;
        if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)new FqName("kotlin.ranges.downTo"))) return false;
        return true;
    }

    @NotNull
    public ProgressionHeaderInfo build(@NotNull IrCall expression, @NotNull ProgressionType data, @NotNull IrSymbol scopeOwner) {
        IrExpression lastExclusive;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder $this$build_u24lambda_u240 = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression.getStartOffset(), expression.getEndOffset());
        boolean bl = false;
        IrExpression irExpression = expression.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression first = irExpression;
        IrExpression irExpression2 = expression.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression2);
        IrExpression last = irExpression2;
        IrConstImpl step = ExpressionHelpersKt.irInt$default($this$build_u24lambda_u240, -1, null, 2, null);
        ProgressionDirection direction = ProgressionDirection.DECREASING;
        return this.preferJavaLikeCounterLoop && (lastExclusive = this.convertToExclusiveLowerBound(last, data)) != null ? new ProgressionHeaderInfo(data, first, lastExclusive, step, false, false, false, direction, null, last, 288, null) : new ProgressionHeaderInfo(data, first, last, step, false, false, null, direction, null, null, 880, null);
    }

    private final IrExpression convertToExclusiveLowerBound(IrExpression $this$convertToExclusiveLowerBound, ProgressionType progressionType) {
        long longValue;
        int intValue;
        short shortValue;
        byte byteValue;
        char charValue;
        block4: {
            block5: {
                if (!(progressionType instanceof UnsignedProgressionType)) break block4;
                if (this.preferJavaLikeCounterLoop) break block5;
                Long l = UtilsKt.getConstLongValue($this$convertToExclusiveLowerBound);
                long l2 = 0L;
                if (l == null || l != l2) break block4;
            }
            return null;
        }
        IrConst irConst = $this$convertToExclusiveLowerBound instanceof IrConst ? (IrConst)$this$convertToExclusiveLowerBound : null;
        if (irConst == null) {
            return null;
        }
        IrConst irConst2 = irConst;
        IrConstKind irConstKind = irConst2.getKind();
        return Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Char.INSTANCE) ? (IrExpression)((charValue = ((Character)IrConstKind.Char.INSTANCE.valueOf(irConst2)).charValue()) != '\u0000' ? IrConstImpl.Companion.char($this$convertToExclusiveLowerBound.getStartOffset(), $this$convertToExclusiveLowerBound.getEndOffset(), $this$convertToExclusiveLowerBound.getType(), (char)(charValue + -1)) : null) : (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Byte.INSTANCE) ? (IrExpression)((byteValue = ((Number)IrConstKind.Byte.INSTANCE.valueOf(irConst2)).byteValue()) != -128 ? IrConstImpl.Companion.byte($this$convertToExclusiveLowerBound.getStartOffset(), $this$convertToExclusiveLowerBound.getEndOffset(), $this$convertToExclusiveLowerBound.getType(), (byte)(byteValue + -1)) : null) : (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Short.INSTANCE) ? (IrExpression)((shortValue = ((Number)IrConstKind.Short.INSTANCE.valueOf(irConst2)).shortValue()) != Short.MIN_VALUE ? IrConstImpl.Companion.short($this$convertToExclusiveLowerBound.getStartOffset(), $this$convertToExclusiveLowerBound.getEndOffset(), $this$convertToExclusiveLowerBound.getType(), (short)(shortValue + -1)) : null) : (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Int.INSTANCE) ? (IrExpression)((intValue = ((Number)IrConstKind.Int.INSTANCE.valueOf(irConst2)).intValue()) != Integer.MIN_VALUE ? IrConstImpl.Companion.int($this$convertToExclusiveLowerBound.getStartOffset(), $this$convertToExclusiveLowerBound.getEndOffset(), $this$convertToExclusiveLowerBound.getType(), intValue + -1) : null) : (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Long.INSTANCE) ? (IrExpression)((longValue = ((Number)IrConstKind.Long.INSTANCE.valueOf(irConst2)).longValue()) != Long.MIN_VALUE ? IrConstImpl.Companion.long($this$convertToExclusiveLowerBound.getStartOffset(), $this$convertToExclusiveLowerBound.getEndOffset(), $this$convertToExclusiveLowerBound.getType(), longValue + -1L) : null) : null))));
    }
}

