/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.reset.GitNewResetDialog;
import git4idea.reset.GitOneCommitPerRepoLogAction;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GitResetAction
extends GitOneCommitPerRepoLogAction {
    protected void actionPerformed(final @NotNull Project project, final @NotNull Map<GitRepository, VcsFullCommitDetails> commits2) {
        GitVcsSettings settings;
        GitResetMode defaultMode;
        GitNewResetDialog dialog;
        if (project == null) {
            GitResetAction.$$$reportNull$$$0(0);
        }
        if (commits2 == null) {
            GitResetAction.$$$reportNull$$$0(1);
        }
        if ((dialog = new GitNewResetDialog(project, commits2, defaultMode = (GitResetMode)((Object)ObjectUtils.notNull((Object)((Object)(settings = GitVcsSettings.getInstance(project)).getResetMode()), (Object)((Object)GitResetMode.getDefault()))))).showAndGet()) {
            final GitResetMode selectedMode = dialog.getResetMode();
            settings.setResetMode(selectedMode);
            new Task.Backgroundable(project, GitBundle.message("git.reset.process", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Map<GitRepository, Hash> hashes2 = commits2.keySet().stream().collect(Collectors.toMap(Function.identity(), repo2 -> (Hash)((VcsFullCommitDetails)commits2.get(repo2)).getId()));
                    new GitResetOperation(project, hashes2, selectedMode, indicator).execute();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitResetAction$1", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "commits";
                break;
            }
        }
        objectArray[1] = "git4idea/reset/GitResetAction";
        objectArray[2] = "actionPerformed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

