/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitConfigurationCacheBase;
import git4idea.repo.GitProjectConfigurationCache;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryConfigKey;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u0004\u0018\u00010\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lgit4idea/repo/GitProjectConfigurationCache;", "Lgit4idea/repo/GitConfigurationCacheBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "clearInvalidKeys", "", "readRepositoryConfig", "", "T", "repository", "Lgit4idea/repo/GitRepository;", "key", "Companion", "RepoConfigKey", "intellij.vcs.git"})
@ApiStatus.Experimental
public final class GitProjectConfigurationCache
extends GitConfigurationCacheBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public GitProjectConfigurationCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_REPOSITORY_MAPPING_UPDATED");
        connection.subscribe(topic, () -> GitProjectConfigurationCache._init_$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @RequiresBackgroundThread
    @Nullable
    public final <T> String readRepositoryConfig(@NotNull GitRepository repository, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (String)this.computeCachedValue(new RepoConfigKey(repository, key), (Function0)new Function0<String>(repository, key){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ String $key;
            {
                this.$repository = $repository;
                this.$key = $key;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string;
                try {
                    string = GitConfigUtil.getValue(this.$repository.getProject(), this.$repository.getRoot(), this.$key);
                }
                catch (VcsException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(GitProjectConfigurationCache.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn((Throwable)e);
                    string = null;
                }
                return string;
            }
        });
    }

    private final void clearInvalidKeys() {
        this.getCache().keySet().removeIf(arg_0 -> GitProjectConfigurationCache.clearInvalidKeys$lambda$1(clearInvalidKeys.1.INSTANCE, arg_0));
    }

    private static final void _init_$lambda$0(GitProjectConfigurationCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clearInvalidKeys();
    }

    private static final boolean clearInvalidKeys$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final GitProjectConfigurationCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lgit4idea/repo/GitProjectConfigurationCache$Companion;", "", "()V", "getInstance", "Lgit4idea/repo/GitProjectConfigurationCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitConfigurationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitProjectConfigurationCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,133:1\n31#2,2:134\n*S KotlinDebug\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitProjectConfigurationCache$Companion\n*L\n40#1:134,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitProjectConfigurationCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitProjectConfigurationCache> serviceClass$iv = GitProjectConfigurationCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitProjectConfigurationCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0002H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgit4idea/repo/GitProjectConfigurationCache$RepoConfigKey;", "Lgit4idea/repo/GitRepositoryConfigKey;", "", "repository", "Lgit4idea/repo/GitRepository;", "key", "(Lgit4idea/repo/GitRepository;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getRepository", "()Lgit4idea/repo/GitRepository;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
    public static final class RepoConfigKey
    implements GitRepositoryConfigKey<String> {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final String key;

        public RepoConfigKey(@NotNull GitRepository repository, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.repository = repository;
            this.key = key;
        }

        @Override
        @NotNull
        public GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final GitRepository component1() {
            return this.repository;
        }

        @NotNull
        public final String component2() {
            return this.key;
        }

        @NotNull
        public final RepoConfigKey copy(@NotNull GitRepository repository, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new RepoConfigKey(repository, key);
        }

        public static /* synthetic */ RepoConfigKey copy$default(RepoConfigKey repoConfigKey, GitRepository gitRepository, String string, int n, Object object) {
            if ((n & 1) != 0) {
                gitRepository = repoConfigKey.repository;
            }
            if ((n & 2) != 0) {
                string = repoConfigKey.key;
            }
            return repoConfigKey.copy(gitRepository, string);
        }

        @NotNull
        public String toString() {
            return "RepoConfigKey(repository=" + this.repository + ", key=" + this.key + ")";
        }

        public int hashCode() {
            int result2 = this.repository.hashCode();
            result2 = result2 * 31 + this.key.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepoConfigKey)) {
                return false;
            }
            RepoConfigKey repoConfigKey = (RepoConfigKey)other;
            if (!Intrinsics.areEqual((Object)this.repository, (Object)repoConfigKey.repository)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.key, (Object)repoConfigKey.key);
        }
    }
}

