/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.ArrayUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordBuilder;
import git4idea.history.GitLogRecordCollector;
import git4idea.history.GitLogUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 0*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u00010B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ+\u0010\u0011\u001a\u00028\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0013\u0012\u0004\u0012\u00020\u001d0\u001cH$J?\u0010\u001e\u001a\u00020\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%\u00a2\u0006\u0002\u0010&J4\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010 JA\u0010)\u001a\u00020\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010 2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%H\u0002\u00a2\u0006\u0002\u0010,J7\u0010-\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%H\u0002\u00a2\u0006\u0002\u0010/R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lgit4idea/history/GitDetailsCollector;", "R", "Lgit4idea/history/GitLogRecord;", "C", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "recordBuilder", "Lgit4idea/history/GitLogRecordBuilder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lgit4idea/history/GitLogRecordBuilder;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createCommit", "records", "", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "requirements", "Lgit4idea/history/GitCommitRequirements;", "(Ljava/util/List;Lcom/intellij/vcs/log/VcsLogObjectsFactory;Lgit4idea/history/GitCommitRequirements;)Lcom/intellij/vcs/log/VcsCommitMetadata;", "createRecordsCollector", "Lgit4idea/history/GitLogRecordCollector;", "consumer", "Lkotlin/Function1;", "", "readFullDetails", "commitConsumer", "Ljava/util/function/Consumer;", "lowPriorityProcess", "", "parameters", "", "", "(Ljava/util/function/Consumer;Lgit4idea/history/GitCommitRequirements;Z[Ljava/lang/String;)V", "readFullDetailsForHashes", "hashes", "readFullDetailsFromHandler", "handler", "Lgit4idea/commands/GitLineHandler;", "(Ljava/util/function/Consumer;Lgit4idea/commands/GitLineHandler;Lgit4idea/history/GitCommitRequirements;[Ljava/lang/String;)V", "readRecordsFromHandler", "converter", "(Lgit4idea/commands/GitLineHandler;Ljava/util/function/Consumer;[Ljava/lang/String;)V", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDetailsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDetailsCollector.kt\ngit4idea/history/GitDetailsCollector\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,134:1\n32#2:135\n141#2,2:136\n33#2,2:138\n158#2:140\n144#2,12:141\n*S KotlinDebug\n*F\n+ 1 GitDetailsCollector.kt\ngit4idea/history/GitDetailsCollector\n*L\n92#1:135\n92#1:136,2\n92#1:138,2\n92#1:140\n92#1:141,12\n*E\n"})
public abstract class GitDetailsCollector<R extends GitLogRecord, C extends VcsCommitMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final GitLogRecordBuilder<R> recordBuilder;
    @NotNull
    private static final Logger LOG;

    public GitDetailsCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogRecordBuilder<R> recordBuilder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(recordBuilder, (String)"recordBuilder");
        this.project = project;
        this.root = root;
        this.recordBuilder = recordBuilder;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final VirtualFile getRoot() {
        return this.root;
    }

    public final void readFullDetails(@NotNull Consumer<? super C> commitConsumer, @NotNull GitCommitRequirements requirements, boolean lowPriorityProcess, String ... parameters) throws VcsException {
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        List<String> configParameters = requirements.configParameters();
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, this.root, configParameters, lowPriorityProcess);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"createGitHandler(...)");
        GitLineHandler handler = gitLineHandler;
        this.readFullDetailsFromHandler(commitConsumer, handler, requirements, Arrays.copyOf(parameters, parameters.length));
    }

    public final void readFullDetailsForHashes(@NotNull List<String> hashes2, @NotNull GitCommitRequirements requirements, boolean lowPriorityProcess, @NotNull Consumer<? super C> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter(hashes2, (String)"hashes");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        if (hashes2.isEmpty()) {
            return;
        }
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, this.root, requirements.configParameters(), lowPriorityProcess);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"createGitHandler(...)");
        GitLineHandler handler = gitLineHandler;
        GitLogUtil.sendHashesToStdin((Collection<String>)hashes2, handler);
        String[] stringArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)GitLogUtil.getNoWalkParameter(this.project), (String)"getNoWalkParameter(...)");
        stringArray[1] = "--stdin";
        this.readFullDetailsFromHandler(commitConsumer, handler, requirements, stringArray);
    }

    private final void readFullDetailsFromHandler(Consumer<? super C> commitConsumer, GitLineHandler handler, GitCommitRequirements requirements, String ... parameters) throws VcsException {
        VcsLogObjectsFactory vcsLogObjectsFactory = GitLogUtil.getObjectsFactoryWithDisposeCheck(this.project);
        if (vcsLogObjectsFactory == null) {
            return;
        }
        VcsLogObjectsFactory factory = vcsLogObjectsFactory;
        GitExecutable gitExecutable = handler.getExecutable();
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        String[] stringArray = ArrayUtil.mergeArrays((String[])ArrayUtil.toStringArray((Collection)requirements.commandParameters(this.project, gitExecutable)), (String[])Arrays.copyOf(parameters, parameters.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mergeArrays(...)");
        String[] commandParameters = stringArray;
        if (requirements.getDiffInMergeCommits() == GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS) {
            Function1 consumer2 = new Function1<List<? extends R>, Unit>(commitConsumer, this, factory, requirements){
                final /* synthetic */ Consumer<? super C> $commitConsumer;
                final /* synthetic */ GitDetailsCollector<R, C> this$0;
                final /* synthetic */ VcsLogObjectsFactory $factory;
                final /* synthetic */ GitCommitRequirements $requirements;
                {
                    this.$commitConsumer = $commitConsumer;
                    this.this$0 = $receiver;
                    this.$factory = $factory;
                    this.$requirements = $requirements;
                    super(1);
                }

                public final void invoke(@NotNull List<? extends R> records) {
                    Intrinsics.checkNotNullParameter(records, (String)"records");
                    GitLogRecord firstRecord = (GitLogRecord)CollectionsKt.first(records);
                    String[] stringArray = firstRecord.getParentsHashes();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getParentsHashes(...)");
                    String[] parents = stringArray;
                    if (parents.length == 0 || parents.length == records.size()) {
                        this.$commitConsumer.accept(this.this$0.createCommit(records, this.$factory, this.$requirements));
                    } else {
                        GitDetailsCollector.access$getLOG$cp().warn("Not enough records for commit " + firstRecord.getHash() + " expected " + parents.length + " records, but got " + records.size());
                    }
                }
            };
            GitLogRecordCollector<R> recordCollector = this.createRecordsCollector(consumer2);
            this.readRecordsFromHandler(handler, recordCollector, Arrays.copyOf(commandParameters, commandParameters.length));
            recordCollector.finish();
        } else {
            Consumer<GitLogRecord> consumer3 = arg_0 -> GitDetailsCollector.readFullDetailsFromHandler$lambda$0(commitConsumer, this, factory, requirements, arg_0);
            this.readRecordsFromHandler(handler, consumer3, Arrays.copyOf(commandParameters, commandParameters.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void readRecordsFromHandler(GitLineHandler handler, Consumer<R> converter, String ... parameters) throws VcsException {
        void $this$use$iv;
        String[] stringArray = GitLogUtil.COMMIT_METADATA_OPTIONS;
        GitLogParser<R> parser = new GitLogParser<R>(this.project, this.recordBuilder, GitLogParser.NameStatus.STATUS, Arrays.copyOf(stringArray, stringArray.length));
        handler.setStdoutSuppressed(true);
        handler.addParameters(Arrays.copyOf(parameters, parameters.length));
        stringArray = new String[]{parser.getPretty(), "--encoding=UTF-8"};
        handler.addParameters(stringArray);
        stringArray = new String[]{"--name-status"};
        handler.addParameters(stringArray);
        handler.endOptions();
        String[] stringArray2 = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder("LoadingFullCommitDetails");
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"spanBuilder(...)");
        stringArray = stringArray2;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan()");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Unit unit;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span2 = span$iv;
                boolean bl3 = false;
                span2.setAttribute("rootName", this.root.getName());
                GitLogOutputSplitter<R> handlerListener = new GitLogOutputSplitter<R>(handler, parser, converter);
                Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
                handlerListener.reportErrors();
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit2 = unit;
        }
        catch (CancellationException e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv;
        }
        catch (ProcessCanceledException e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    @NotNull
    protected abstract GitLogRecordCollector<R> createRecordsCollector(@NotNull Function1<? super List<? extends R>, Unit> var1);

    @NotNull
    protected abstract C createCommit(@NotNull List<? extends R> var1, @NotNull VcsLogObjectsFactory var2, @NotNull GitCommitRequirements var3);

    private static final void readFullDetailsFromHandler$lambda$0(Consumer $commitConsumer, GitDetailsCollector this$0, VcsLogObjectsFactory $factory, GitCommitRequirements $requirements, GitLogRecord record) {
        Intrinsics.checkNotNullParameter((Object)$commitConsumer, (String)"$commitConsumer");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
        Intrinsics.checkNotNullParameter((Object)$requirements, (String)"$requirements");
        Object[] objectArray = new GitLogRecord[]{record};
        $commitConsumer.accept(this$0.createCommit(CollectionsKt.mutableListOf((Object[])objectArray), $factory, $requirements));
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(GitDetailsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/history/GitDetailsCollector$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

