/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.collaboration.util.RefComparisonChange;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitBranchComparisonResult;
import git4idea.changes.GitBranchComparisonResultImplKt;
import git4idea.changes.GitCommitShaWithPatches;
import git4idea.changes.GitFileHistory;
import git4idea.changes.GitTextFilePatchWithHistory;
import git4idea.changes.MutableLinearGitFileHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u00020\u0001:\u00011BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ \u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\rH\u0002J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u0002002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0017R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgit4idea/changes/GitBranchComparisonResultImpl;", "Lgit4idea/changes/GitBranchComparisonResult;", "project", "Lcom/intellij/openapi/project/Project;", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "baseSha", "", "mergeBaseSha", "commits", "", "Lgit4idea/changes/GitCommitShaWithPatches;", "headPatches", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "_changes", "", "Lcom/intellij/collaboration/util/RefComparisonChange;", "_changesByCommits", "", "_diffDataByChange", "Lgit4idea/changes/GitTextFilePatchWithHistory;", "getBaseSha", "()Ljava/lang/String;", "changes", "getChanges", "()Ljava/util/List;", "changesByCommits", "", "getChangesByCommits", "()Ljava/util/Map;", "getCommits", "headSha", "getHeadSha", "getMergeBaseSha", "patchesByChange", "getPatchesByChange", "createChangeFromPatch", "beforeRef", "afterRef", "patch", "equals", "", "other", "", "hashCode", "", "initForLinearHistory", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchComparisonResultImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchComparisonResultImpl.kt\ngit4idea/changes/GitBranchComparisonResultImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n1549#2:140\n1620#2,3:141\n1774#2,4:144\n1238#2,4:151\n1#3:148\n468#4:149\n414#4:150\n13#5:155\n*S KotlinDebug\n*F\n+ 1 GitBranchComparisonResultImpl.kt\ngit4idea/changes/GitBranchComparisonResultImpl\n*L\n46#1:140\n46#1:141,3\n51#1:144,4\n79#1:151,4\n79#1:149\n79#1:150\n134#1:155\n*E\n"})
public final class GitBranchComparisonResultImpl
implements GitBranchComparisonResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile vcsRoot;
    @NotNull
    private final String baseSha;
    @NotNull
    private final String mergeBaseSha;
    @NotNull
    private final List<GitCommitShaWithPatches> commits;
    @NotNull
    private final List<FilePatch> headPatches;
    @NotNull
    private final String headSha;
    @NotNull
    private final List<RefComparisonChange> _changes;
    @NotNull
    private final List<RefComparisonChange> changes;
    @NotNull
    private final Map<String, List<RefComparisonChange>> _changesByCommits;
    @NotNull
    private final Map<String, List<RefComparisonChange>> changesByCommits;
    @NotNull
    private final Map<RefComparisonChange, GitTextFilePatchWithHistory> _diffDataByChange;
    @NotNull
    private final Map<RefComparisonChange, GitTextFilePatchWithHistory> patchesByChange;
    @NotNull
    private static final Logger LOG;

    public GitBranchComparisonResultImpl(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String baseSha, @NotNull String mergeBaseSha, @NotNull List<GitCommitShaWithPatches> commits2, @NotNull List<? extends FilePatch> headPatches) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter((Object)baseSha, (String)"baseSha");
        Intrinsics.checkNotNullParameter((Object)mergeBaseSha, (String)"mergeBaseSha");
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(headPatches, (String)"headPatches");
        this.project = project;
        this.vcsRoot = vcsRoot;
        this.baseSha = baseSha;
        this.mergeBaseSha = mergeBaseSha;
        this.commits = commits2;
        this.headPatches = headPatches;
        this.headSha = ((GitCommitShaWithPatches)CollectionsKt.last(this.getCommits())).getSha();
        this._changes = new ArrayList();
        List<RefComparisonChange> list2 = Collections.unmodifiableList(this._changes);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(...)");
        this.changes = list2;
        this._changesByCommits = new LinkedHashMap();
        Map<String, List<RefComparisonChange>> map2 = Collections.unmodifiableMap(this._changesByCommits);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.changesByCommits = map2;
        this._diffDataByChange = new LinkedHashMap();
        Map<RefComparisonChange, GitTextFilePatchWithHistory> map3 = Collections.unmodifiableMap(this._diffDataByChange);
        Intrinsics.checkNotNullExpressionValue(map3, (String)"unmodifiableMap(...)");
        this.patchesByChange = map3;
        try {
            this.initForLinearHistory(this.getCommits());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build branch comparison result between " + this.getBaseSha() + " and " + this.getHeadSha() + " via " + this.getMergeBaseSha() + " - " + e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    public String getBaseSha() {
        return this.baseSha;
    }

    @Override
    @NotNull
    public String getMergeBaseSha() {
        return this.mergeBaseSha;
    }

    @Override
    @NotNull
    public List<GitCommitShaWithPatches> getCommits() {
        return this.commits;
    }

    @Override
    @NotNull
    public String getHeadSha() {
        return this.headSha;
    }

    @Override
    @NotNull
    public List<RefComparisonChange> getChanges() {
        return this.changes;
    }

    @Override
    @NotNull
    public Map<String, List<RefComparisonChange>> getChangesByCommits() {
        return this.changesByCommits;
    }

    @Override
    @NotNull
    public Map<RefComparisonChange, GitTextFilePatchWithHistory> getPatchesByChange() {
        return this.patchesByChange;
    }

    /*
     * WARNING - void declaration
     */
    private final void initForLinearHistory(List<GitCommitShaWithPatches> commits2) {
        void $this$mapKeysTo$iv$iv;
        Object $this$initForLinearHistory_u24lambda_u243;
        Object commitChanges;
        Iterator it;
        void $this$mapTo$iv$iv;
        Iterator<GitCommitShaWithPatches> $this$map$iv;
        Map fileHistoriesByLastKnownFilePath = new LinkedHashMap();
        String previousCommitSha = null;
        previousCommitSha = this.getMergeBaseSha();
        Iterable iterable = commits2;
        Object object = CollectionsKt.listOf((Object)this.getMergeBaseSha());
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GitCommitShaWithPatches gitCommitShaWithPatches = (GitCommitShaWithPatches)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((GitCommitShaWithPatches)((Object)it)).getSha());
        }
        List commitsHashes = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv));
        for (GitCommitShaWithPatches commitWithPatches : commits2) {
            int n;
            String commitSha = commitWithPatches.getSha();
            commitChanges = new ArrayList();
            Iterable $this$count$iv = commitWithPatches.getParents();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                it = $this$count$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv = it.next();
                    String it2 = (String)element$iv;
                    boolean bl = false;
                    if (!commitsHashes.contains(it2) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n <= 1) {
                for (FilePatch patch : commitWithPatches.getPatches()) {
                    MutableLinearGitFileHistory historyBefore;
                    MutableLinearGitFileHistory mutableLinearGitFileHistory;
                    MutableLinearGitFileHistory mutableLinearGitFileHistory2;
                    Object it3;
                    RefComparisonChange change = this.createChangeFromPatch(previousCommitSha, commitSha, patch);
                    commitChanges.add(change);
                    if (!(patch instanceof TextFilePatch)) continue;
                    String beforePath = ((TextFilePatch)patch).getBeforeName();
                    String afterPath = ((TextFilePatch)patch).getAfterName();
                    String string = beforePath;
                    if (string != null) {
                        it3 = string;
                        boolean bl = false;
                        mutableLinearGitFileHistory2 = (MutableLinearGitFileHistory)fileHistoriesByLastKnownFilePath.remove(it3);
                    } else {
                        mutableLinearGitFileHistory2 = null;
                    }
                    if ((mutableLinearGitFileHistory = (historyBefore = mutableLinearGitFileHistory2)) == null) {
                        mutableLinearGitFileHistory = new MutableLinearGitFileHistory(commitsHashes);
                    }
                    $this$initForLinearHistory_u24lambda_u243 = it3 = mutableLinearGitFileHistory;
                    boolean bl = false;
                    ((MutableLinearGitFileHistory)$this$initForLinearHistory_u24lambda_u243).append(previousCommitSha, beforePath);
                    ((MutableLinearGitFileHistory)$this$initForLinearHistory_u24lambda_u243).append(commitSha, (TextFilePatch)patch);
                    Object fileHistory = it3;
                    String string2 = afterPath;
                    if (string2 == null) {
                        string2 = beforePath;
                    }
                    Intrinsics.checkNotNull((Object)string2);
                    String path = string2;
                    fileHistoriesByLastKnownFilePath.put(path, fileHistory);
                    ((TextFilePatch)patch).setBeforeVersionId(previousCommitSha);
                    ((TextFilePatch)patch).setAfterVersionId(commitSha);
                    this._diffDataByChange.put(change, new GitTextFilePatchWithHistory((TextFilePatch)patch, false, (GitFileHistory)fileHistory));
                }
            }
            this._changesByCommits.put(commitWithPatches.getSha(), (List<RefComparisonChange>)commitChanges);
            previousCommitSha = commitSha;
        }
        Map $this$mapKeys$iv = fileHistoriesByLastKnownFilePath;
        boolean $i$f$mapKeys = false;
        commitChanges = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it4;
            Map.Entry fileHistory = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            $this$initForLinearHistory_u24lambda_u243 = (Map.Entry)element$iv$iv$iv;
            String string = ((MutableLinearGitFileHistory)it4.getValue()).getLastKnownFilePath();
            Object object2 = object;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            object2.put(string, v);
        }
        Map fileHistoriesBySummaryFilePath = destination$iv$iv2;
        for (FilePatch patch : this.headPatches) {
            RefComparisonChange change = this.createChangeFromPatch(this.getMergeBaseSha(), this.getHeadSha(), patch);
            this._changes.add(change);
            if (!(patch instanceof TextFilePatch)) continue;
            String filePath = GitBranchComparisonResultImplKt.getFilePath(patch);
            MutableLinearGitFileHistory fileHistory = (MutableLinearGitFileHistory)fileHistoriesBySummaryFilePath.get(filePath);
            if (fileHistory == null) {
                LOG.warn("Unable to find file history for cumulative patch for " + filePath);
                continue;
            }
            ((TextFilePatch)patch).setBeforeVersionId(this.getBaseSha());
            ((TextFilePatch)patch).setAfterVersionId(this.getHeadSha());
            this._diffDataByChange.put(change, new GitTextFilePatchWithHistory((TextFilePatch)patch, true, fileHistory));
        }
    }

    private final RefComparisonChange createChangeFromPatch(String beforeRef, String afterRef, FilePatch patch) {
        FilePath beforePath = patch.isNewFile() ? null : VcsUtil.getFilePath((VirtualFile)this.vcsRoot, (String)patch.getBeforeName());
        FilePath afterPath = patch.isDeletedFile() ? null : VcsUtil.getFilePath((VirtualFile)this.vcsRoot, (String)patch.getAfterName());
        return new RefComparisonChange((ShortVcsRevisionNumber)new GitRevisionNumber(beforeRef), beforePath, (ShortVcsRevisionNumber)new GitRevisionNumber(afterRef), afterPath);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type git4idea.changes.GitBranchComparisonResultImpl");
        GitBranchComparisonResultImpl cfr_ignored_0 = (GitBranchComparisonResultImpl)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)((GitBranchComparisonResultImpl)other).project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vcsRoot, (Object)((GitBranchComparisonResultImpl)other).vcsRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBaseSha(), (Object)((GitBranchComparisonResultImpl)other).getBaseSha())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMergeBaseSha(), (Object)((GitBranchComparisonResultImpl)other).getMergeBaseSha())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getHeadSha(), (Object)((GitBranchComparisonResultImpl)other).getHeadSha());
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = 31 * result2 + this.vcsRoot.hashCode();
        result2 = 31 * result2 + this.getBaseSha().hashCode();
        result2 = 31 * result2 + this.getMergeBaseSha().hashCode();
        result2 = 31 * result2 + this.getHeadSha().hashCode();
        return result2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitBranchComparisonResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/changes/GitBranchComparisonResultImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

