/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a,\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\r\u001a4\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"suffixPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "suffixStart", "", "match", "Lit/unimi/dsi/fastutil/ints/IntSet;", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceBranchCommits", "targetBranchCommits", "reliable", "", "selectSourceCommits", "targetCommit", "", "sourceCandidates", "sourceCandidatesExtended", "intellij.vcs.git"})
public final class GitCompareUtilKt {
    @NotNull
    private static final String suffixStart = "cherry picked from commit";
    private static final Pattern suffixPattern = Pattern.compile("cherry picked from commit.*\\)");

    @NotNull
    public static final IntSet match(@NotNull IndexDataGetter $this$match, @NotNull VirtualFile root, @NotNull IntSet sourceBranchCommits, @NotNull IntSet targetBranchCommits, boolean reliable) {
        Intrinsics.checkNotNullParameter((Object)$this$match, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)sourceBranchCommits, (String)"sourceBranchCommits");
        Intrinsics.checkNotNullParameter((Object)targetBranchCommits, (String)"targetBranchCommits");
        Map map2 = IntCollectionUtil.groupByAsIntSet((IntCollection)((IntCollection)sourceBranchCommits), arg_0 -> GitCompareUtilKt.match$lambda$0($this$match, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"groupByAsIntSet(...)");
        Map timeToSourceCommit = map2;
        Map map3 = IntCollectionUtil.groupByAsIntSet((IntCollection)((IntCollection)sourceBranchCommits), arg_0 -> GitCompareUtilKt.match$lambda$1($this$match, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"groupByAsIntSet(...)");
        Map authorToSourceCommit = map3;
        IntOpenHashSet result2 = new IntOpenHashSet();
        for (Integer targetCommit : targetBranchCommits) {
            IntSet sourceCandidates;
            IntSet intSet;
            IntSet commitsForAuthor;
            Intrinsics.checkNotNull((Object)targetCommit);
            Long time = $this$match.getAuthorTime(targetCommit.intValue());
            VcsUser author = $this$match.getAuthor(targetCommit.intValue());
            IntSet intSet2 = (IntSet)authorToSourceCommit.get(author);
            if (intSet2 == null) {
                intSet2 = commitsForAuthor = (IntSet)new IntOpenHashSet();
            }
            if ((intSet = (IntSet)timeToSourceCommit.get(time)) == null) {
                intSet = (IntSet)new IntOpenHashSet();
            }
            if (IntCollectionUtil.intersect((IntSet)intSet, (IntSet)commitsForAuthor) == null || sourceCandidates.isEmpty()) continue;
            result2.addAll((IntCollection)GitCompareUtilKt.selectSourceCommits($this$match, targetCommit, root, sourceCandidates, commitsForAuthor, reliable));
        }
        return (IntSet)result2;
    }

    public static /* synthetic */ IntSet match$default(IndexDataGetter indexDataGetter, VirtualFile virtualFile, IntSet intSet, IntSet intSet2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return GitCompareUtilKt.match(indexDataGetter, virtualFile, intSet, intSet2, bl);
    }

    private static final IntSet selectSourceCommits(IndexDataGetter $this$selectSourceCommits, int targetCommit, VirtualFile root, IntSet sourceCandidates, IntSet sourceCandidatesExtended, boolean reliable) {
        String string = $this$selectSourceCommits.getFullMessage(targetCommit);
        if (string == null) {
            IntSet intSet = IntSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"of(...)");
            return intSet;
        }
        String targetMessage = string;
        IntOpenHashSet result2 = new IntOpenHashSet();
        Matcher matcher = suffixPattern.matcher(targetMessage);
        while (matcher.find()) {
            CharSequence match2 = targetMessage.subSequence(matcher.start(), matcher.end());
            CharSequence hashesString = match2.subSequence(25, match2.length() - 1);
            Object object = new String[]{",", " ", ";"};
            List hashesCandidates = StringsKt.split$default((CharSequence)hashesString, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = hashesCandidates.iterator();
            while (object.hasNext()) {
                Hash hash;
                String h = (String)object.next();
                if (!VcsLogUtil.HASH_REGEX.matcher(h).matches()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)h), (String)"build(...)");
                int index = $this$selectSourceCommits.getLogStorage().getCommitIndex(hash, root);
                if (!sourceCandidatesExtended.contains(index)) continue;
                result2.add(index);
            }
            if (!IntCollectionUtil.intersects((IntSet)sourceCandidates, (IntSet)((IntSet)result2))) continue;
            return (IntSet)result2;
        }
        if (!reliable) {
            Set inexactMatches = new LinkedHashSet();
            Set exactMatches = new LinkedHashSet();
            for (Integer sourceCandidate : sourceCandidates) {
                String sourceMessage;
                Intrinsics.checkNotNull((Object)sourceCandidate);
                if ($this$selectSourceCommits.getFullMessage(sourceCandidate.intValue()) == null) {
                    IntSet intSet = IntSet.of();
                    Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"of(...)");
                    return intSet;
                }
                if (!StringsKt.contains$default((CharSequence)targetMessage, (CharSequence)sourceMessage, (boolean)false, (int)2, null)) continue;
                if (targetMessage.length() == sourceMessage.length()) {
                    exactMatches.add(sourceCandidate);
                    continue;
                }
                inexactMatches.add(sourceCandidate);
            }
            Integer match3 = (Integer)CollectionsKt.singleOrNull((Iterable)(!((Collection)exactMatches).isEmpty() ? exactMatches : inexactMatches));
            if (match3 != null) {
                IntSet intSet = IntSet.of((int)match3);
                Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"of(...)");
                return intSet;
            }
        }
        IntSet intSet = IntSet.of();
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"of(...)");
        return intSet;
    }

    private static final Long match$lambda$0(IndexDataGetter $this_match, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_match, (String)"$this_match");
        return $this_match.getAuthorTime(it);
    }

    private static final VcsUser match$lambda$1(IndexDataGetter $this_match, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_match, (String)"$this_match");
        return $this_match.getAuthor(it);
    }
}

