/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.performancePlugin.commands.AbstractFileCommand;
import com.jetbrains.performancePlugin.commands.AddFileCommand;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/RenameFileCommand;", "Lcom/jetbrains/performancePlugin/commands/AbstractFileCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nRenameFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameFileCommand.kt\ncom/jetbrains/performancePlugin/commands/RenameFileCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,42:1\n13#2:43\n*S KotlinDebug\n*F\n+ 1 RenameFileCommand.kt\ncom/jetbrains/performancePlugin/commands/RenameFileCommand\n*L\n39#1:43\n*E\n"})
public final class RenameFileCommand
extends AbstractFileCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PREFIX = "%renameFile";

    public RenameFileCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line, 3);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) throws Exception {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList input = this.extractCommandList(PREFIX, ",");
        Intrinsics.checkNotNull((Object)input);
        if (!this.isCommandParametersRight(input)) {
            callback2.reject("Command %renameFile should have 3 non empty parameters (1 - path to directory, 2 - old file name, 3 - new file name) with delimiter ','.");
            return;
        }
        String path = (String)input.get(0);
        String oldName = (String)input.get(1);
        String newName = (String)input.get(2);
        String[] stringArray = new String[]{newName};
        if (VirtualFileManager.getInstance().findFileByNioPath(Paths.get(path, stringArray)) != null) {
            stringArray = new String[]{newName};
            callback2.reject("File by " + Paths.get(path, stringArray) + " path from parameters already exists.");
            return;
        }
        LOG.info("Rename file " + oldName + " to  " + newName + " (path: " + path + ")");
        String[] stringArray2 = new String[]{oldName};
        Path path2 = Paths.get(path, stringArray2);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        super.execute(path2, callback2, (Function1<? super VirtualFile, ? extends Object>)((Function1)new Function1<VirtualFile, Unit>(newName){
            final /* synthetic */ String $newName;
            {
                this.$newName = $newName;
                super(1);
            }

            public final void invoke(@NotNull VirtualFile virtualFile) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                virtualFile.rename(null, this.$newName);
            }
        }));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AddFileCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/RenameFileCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

