/*
 * Decompiled with CFR 0.152.
 */
package training.ui.welcomeScreen;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.wm.BannerStartPagePromoter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.FeaturesTrainerIcons;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.NewUsersOnboardingExperimentAccessor;
import training.learn.OpenLessonActivities;
import training.learn.course.Lesson;
import training.learn.lesson.LessonState;
import training.learn.lesson.LessonStateManager;
import training.statistic.StatisticBase;
import training.ui.OnboardingFeedbackFormKt;
import training.util.OnboardingFeedbackData;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0014J\b\u0010\u001d\u001a\u00020\rH\u0014J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0004R\u0014\u0010\u0007\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Ltraining/ui/welcomeScreen/OnboardingLessonPromoter;", "Lcom/intellij/openapi/wm/BannerStartPagePromoter;", "lessonId", "", "languageId", "lessonName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "actionLabel", "getActionLabel", "()Ljava/lang/String;", "closeAction", "Lkotlin/Function1;", "Ljavax/swing/JPanel;", "", "getCloseAction", "()Lkotlin/jvm/functions/Function1;", "description", "getDescription", "headerLabel", "getHeaderLabel", "getLessonId", "promoImage", "Ljavax/swing/Icon;", "getPromoImage", "()Ljavax/swing/Icon;", "canCreatePromo", "", "isEmptyState", "onBannerShown", "runAction", "scheduleOnboardingFeedback", "startOnboardingLessonWithSdk", "intellij.featuresTrainer"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nOnboardingLessonPromoter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnboardingLessonPromoter.kt\ntraining/ui/welcomeScreen/OnboardingLessonPromoter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1#2:109\n13#3:110\n*S KotlinDebug\n*F\n+ 1 OnboardingLessonPromoter.kt\ntraining/ui/welcomeScreen/OnboardingLessonPromoter\n*L\n70#1:110\n*E\n"})
public class OnboardingLessonPromoter
extends BannerStartPagePromoter {
    @NotNull
    private final String lessonId;
    @NotNull
    private final String languageId;
    @NotNull
    private final String lessonName;
    @NotNull
    private final Function1<JPanel, Unit> closeAction;

    public OnboardingLessonPromoter(@NonNls @NotNull String lessonId, @NonNls @NotNull String languageId, @Nls @NotNull String lessonName) {
        Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)lessonName, (String)"lessonName");
        this.lessonId = lessonId;
        this.languageId = languageId;
        this.lessonName = lessonName;
        this.closeAction = (Function1)new Function1<JPanel, Unit>(this){
            final /* synthetic */ OnboardingLessonPromoter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull JPanel promoPanel) {
                void it;
                Intrinsics.checkNotNullParameter((Object)promoPanel, (String)"promoPanel");
                PropertiesComponent.getInstance().setValue("ift.hide.welcome.screen.promo", true);
                promoPanel.removeAll();
                promoPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
                promoPanel.setOpaque(false);
                Object object = new Object[3];
                String string = ActionsBundle.message((String)"group.HelpMenu.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                object[0] = LessonUtilKt.dropMnemonic(string);
                object[1] = LearnBundle.INSTANCE.message("action.ShowLearnPanel.text", new Object[0]);
                object[2] = OnboardingLessonPromoter.access$getLessonName$p(this.this$0);
                String text2 = LearnBundle.INSTANCE.message("welcome.promo.close.hint", object);
                Object object2 = object = new JLabel("<html>" + text2 + "</html>");
                JPanel jPanel = promoPanel;
                boolean bl = false;
                it.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
                it.setFont((Font)JBUI.Fonts.label().deriveFont(JBUI.Fonts.label().getSize2D() + (float)JBUIScale.scale((int)-1)));
                jPanel.add((Component)object);
                promoPanel.revalidate();
            }
        };
    }

    @NotNull
    protected final String getLessonId() {
        return this.lessonId;
    }

    @NotNull
    protected Icon getPromoImage() {
        Icon icon = FeaturesTrainerIcons.PluginIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PluginIcon");
        return icon;
    }

    public boolean canCreatePromo(boolean isEmptyState) {
        boolean notificationScheduled = this.scheduleOnboardingFeedback();
        return UtilsKt.getEnableLessonsAndPromoters() && !notificationScheduled && !PropertiesComponent.getInstance().getBoolean("ift.hide.welcome.screen.promo", false) && RecentProjectsManagerBase.Companion.getInstanceEx().getRecentPaths().size() < 5 && LessonStateManager.INSTANCE.getStateFromBase(this.lessonId) == LessonState.NOT_PASSED && !NewUsersOnboardingExperimentAccessor.Companion.isExperimentEnabled();
    }

    @NotNull
    protected String getHeaderLabel() {
        return LearnBundle.INSTANCE.message("welcome.promo.header", new Object[0]);
    }

    @NotNull
    protected String getActionLabel() {
        return LearnBundle.INSTANCE.message("welcome.promo.start.tour", new Object[0]);
    }

    protected void runAction() {
        this.startOnboardingLessonWithSdk(this.lessonId, this.languageId);
    }

    @NotNull
    protected String getDescription() {
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.getProductName()};
        return LearnBundle.INSTANCE.message("welcome.promo.description", objectArray);
    }

    protected final void startOnboardingLessonWithSdk(@NotNull String lessonId, @NotNull String languageId) {
        block3: {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
                Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
                UtilsKt.resetPrimaryLanguage(languageId);
                Iterable iterable = CourseManager.Companion.getInstance().getLessonsForModules();
                for (Object t : iterable) {
                    Lesson it = (Lesson)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)lessonId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Lesson lesson = v0;
            if (lesson == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(OnboardingLessonPromoter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("No lesson with id " + lessonId);
                return;
            }
            LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport2 == null) break block3;
            langSupport2.startFromWelcomeFrame((Function1<? super Sdk, Unit>)((Function1)new Function1<Sdk, Unit>(lesson){
                final /* synthetic */ Lesson $lesson;
                {
                    this.$lesson = $lesson;
                    super(1);
                }

                public final void invoke(@Nullable Sdk selectedSdk) {
                    OpenLessonActivities.INSTANCE.openOnboardingFromWelcomeScreen(this.$lesson, selectedSdk);
                }
            }));
        }
    }

    private final boolean scheduleOnboardingFeedback() {
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return false;
        }
        LangSupport langSupport3 = langSupport2;
        OnboardingFeedbackData onboardingFeedbackData = langSupport3.getOnboardingFeedbackData();
        if (onboardingFeedbackData == null) {
            return false;
        }
        OnboardingFeedbackData onboardingFeedbackData2 = onboardingFeedbackData;
        langSupport3.setOnboardingFeedbackData(null);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(onboardingFeedbackData2){
            final /* synthetic */ OnboardingFeedbackData $onboardingFeedbackData;
            {
                this.$onboardingFeedbackData = $onboardingFeedbackData;
                super(0);
            }

            public final void invoke() {
                OnboardingFeedbackFormKt.showOnboardingFeedbackNotification(null, this.$onboardingFeedbackData);
            }
        }), (int)1, null);
        return true;
    }

    @NotNull
    protected Function1<JPanel, Unit> getCloseAction() {
        return this.closeAction;
    }

    protected void onBannerShown() {
        StatisticBase.INSTANCE.logOnboardingBannerShown(this.lessonId, this.languageId);
    }

    public static final /* synthetic */ String access$getLessonName$p(OnboardingLessonPromoter $this) {
        return $this.lessonName;
    }
}

