/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComboBox;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.ComponentFormatterTemplate;
import org.assertj.swing.util.Arrays;

public class JComboBoxFormatter
extends ComponentFormatterTemplate {
    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JComboBox comboBox = (JComboBox)c;
        String format = "%s[name=%s, selectedItem=%s, contents=%s, editable=%b, enabled=%b, visible=%b, showing=%b]";
        return String.format(format, this.getRealClassName(c), Strings.quote(comboBox.getName()), Strings.quote(comboBox.getSelectedItem()), Arrays.format(this.contentsOf(comboBox)), comboBox.isEditable(), comboBox.isEnabled(), comboBox.isVisible(), comboBox.isShowing());
    }

    @Nonnull
    @RunsInCurrentThread
    private Object[] contentsOf(@Nonnull JComboBox<?> comboBox) {
        ArrayList contents = Lists.newArrayList();
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            contents.add(comboBox.getItemAt(i));
        }
        return contents.toArray();
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JComboBox.class;
    }
}

