/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.method;

import java.lang.reflect.Method;
import org.assertj.swing.dependency.fest_reflect.exception.ReflectionError;
import org.assertj.swing.dependency.fest_reflect.util.Accessibles;
import org.assertj.swing.dependency.fest_reflect.util.Throwables;
import org.assertj.swing.dependency.fest_util.Arrays;
import org.assertj.swing.dependency.fest_util.Strings;

public final class Invoker<T> {
    private final Object target;
    private final Method method;

    static <T> Invoker<T> newInvoker(String methodName, Object target, Class<?> ... parameterTypes) {
        return Invoker.createInvoker(methodName, target, parameterTypes);
    }

    private static <T> Invoker<T> createInvoker(String methodName, Object target, Class<?> ... parameterTypes) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        Method method = Invoker.lookupInClassHierarchy(methodName, Invoker.typeOf(target), parameterTypes);
        return new Invoker<T>(target, method);
    }

    private static Class<?> typeOf(Object target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        return target.getClass();
    }

    private static Method lookupInClassHierarchy(String methodName, Class<?> targetType, Class<?>[] parameterTypes) {
        Method method = null;
        for (Class<?> type2 = targetType; type2 != null && (method = Invoker.method(methodName, type2, parameterTypes)) == null; type2 = type2.getSuperclass()) {
        }
        if (method == null) {
            throw new ReflectionError(Strings.concat("Unable to find method ", Strings.quote(methodName), " in ", targetType.getName(), " with parameter type(s) ", Arrays.format(parameterTypes)));
        }
        return method;
    }

    private static Method method(String methodName, Class<?> type2, Class<?>[] parameterTypes) {
        try {
            return type2.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Invoker(Object target, Method method) {
        this.target = target;
        this.method = method;
    }

    public T invoke(Object ... args) {
        boolean accessible = this.method.isAccessible();
        try {
            Accessibles.makeAccessible(this.method);
            Object object = this.method.invoke(this.target, args);
            return (T)object;
        }
        catch (Throwable t) {
            Throwable cause = Throwables.targetOf(t);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw this.cannotInvokeMethod(cause, args);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.method, accessible);
        }
    }

    private ReflectionError cannotInvokeMethod(Throwable cause, Object ... args) {
        String message = Strings.concat("Unable to invoke method ", Strings.quote(this.method.getName()), " with arguments ", Arrays.format(args));
        throw new ReflectionError(message, cause);
    }

    public Method info() {
        return this.method;
    }
}

