/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;

public class MavenWorkspaceMapWrapper {
    private final MavenWorkspaceMap myWorkspaceMap;
    private final Map<String, Set<MavenId>> myArtifactToIdToMavenIdMapping = new HashMap<String, Set<MavenId>>();

    public MavenWorkspaceMapWrapper(MavenWorkspaceMap workspaceMap) {
        this.myWorkspaceMap = workspaceMap;
        if (null != this.myWorkspaceMap) {
            for (MavenId mavenId : this.myWorkspaceMap.getAvailableIds()) {
                if (!this.myArtifactToIdToMavenIdMapping.containsKey(mavenId.getArtifactId())) {
                    this.myArtifactToIdToMavenIdMapping.put(mavenId.getArtifactId(), new HashSet());
                }
                this.myArtifactToIdToMavenIdMapping.get(mavenId.getArtifactId()).add(mavenId);
            }
        }
    }

    public MavenWorkspaceMap.Data findFileAndOriginalId(MavenId mavenId) {
        return this.myWorkspaceMap.findFileAndOriginalId(mavenId);
    }

    @NotNull
    public Set<MavenId> getAvailableIdsForArtifactId(String artifactId) {
        Set<MavenId> ids = this.myArtifactToIdToMavenIdMapping.get(artifactId);
        Set<Object> set = null == ids ? Collections.emptySet() : ids;
        if (set == null) {
            MavenWorkspaceMapWrapper.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/model/MavenWorkspaceMapWrapper", "getAvailableIdsForArtifactId"));
    }
}

