/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Collection;
import java.util.Vector;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Substitution;

public final class Util {
    public static final int SUBSTITUTE_ALL = -1;
    public static final int SPLIT_ALL = 0;

    private Util() {
    }

    public static void split(Collection collection, PatternMatcher patternMatcher, Pattern pattern, String string2, int n2) {
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string2);
        int n3 = 0;
        while (--n2 != 0 && patternMatcher.contains(patternMatcherInput, pattern)) {
            MatchResult matchResult = patternMatcher.getMatch();
            collection.add(string2.substring(n3, matchResult.beginOffset(0)));
            n3 = matchResult.endOffset(0);
        }
        collection.add(string2.substring(n3, string2.length()));
    }

    public static void split(Collection collection, PatternMatcher patternMatcher, Pattern pattern, String string2) {
        Util.split(collection, patternMatcher, pattern, string2, 0);
    }

    public static Vector split(PatternMatcher patternMatcher, Pattern pattern, String string2, int n2) {
        Vector vector = new Vector(20);
        Util.split(vector, patternMatcher, pattern, string2, n2);
        return vector;
    }

    public static Vector split(PatternMatcher patternMatcher, Pattern pattern, String string2) {
        return Util.split(patternMatcher, pattern, string2, 0);
    }

    public static String substitute(PatternMatcher patternMatcher, Pattern pattern, Substitution substitution, String string2, int n2) {
        PatternMatcherInput patternMatcherInput;
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        if (Util.substitute(stringBuffer, patternMatcher, pattern, substitution, patternMatcherInput = new PatternMatcherInput(string2), n2) != 0) {
            return stringBuffer.toString();
        }
        return string2;
    }

    public static String substitute(PatternMatcher patternMatcher, Pattern pattern, Substitution substitution, String string2) {
        return Util.substitute(patternMatcher, pattern, substitution, string2, 1);
    }

    public static int substitute(StringBuffer stringBuffer, PatternMatcher patternMatcher, Pattern pattern, Substitution substitution, String string2, int n2) {
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string2);
        return Util.substitute(stringBuffer, patternMatcher, pattern, substitution, patternMatcherInput, n2);
    }

    public static int substitute(StringBuffer stringBuffer, PatternMatcher patternMatcher, Pattern pattern, Substitution substitution, PatternMatcherInput patternMatcherInput, int n2) {
        int n3 = 0;
        int n4 = patternMatcherInput.getBeginOffset();
        char[] cArray = patternMatcherInput.getBuffer();
        while (n2 != 0 && patternMatcher.contains(patternMatcherInput, pattern)) {
            --n2;
            stringBuffer.append(cArray, n4, patternMatcherInput.getMatchBeginOffset() - n4);
            substitution.appendSubstitution(stringBuffer, patternMatcher.getMatch(), ++n3, patternMatcherInput, patternMatcher, pattern);
            n4 = patternMatcherInput.getMatchEndOffset();
        }
        stringBuffer.append(cArray, n4, patternMatcherInput.length() - n4);
        return n3;
    }
}

