/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.ChunkedDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001TB/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u000bH\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u00100\u001a\u00020\u0012H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0012H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0012H\u0002J\b\u00107\u001a\u00020 H\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010:\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J;\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00122\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0>2\b\u0010?\u001a\u0004\u0018\u0001H<H\u0016\u00a2\u0006\u0002\u0010@J!\u0010A\u001a\u0002H<\"\u0004\b\u0000\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0>H\u0016\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020FH\u0016J+\u0010G\u001a\u00020\u001e2!\u0010H\u001a\u001d\u0012\u0013\u0012\u00110F\u00a2\u0006\f\bJ\u0012\b\bK\u0012\u0004\b\b(L\u0012\u0004\u0012\u00020\u001e0IH\u0016J\b\u0010M\u001a\u00020FH\u0002J\u0010\u0010N\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010O\u001a\u00020 2\u0006\u0010P\u001a\u00020FH\u0002J\u0010\u0010Q\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010R\u001a\u00020 *\u0004\u0018\u00010\r2\u0006\u0010S\u001a\u00020FH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006U"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/ChunkedDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "lexer", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "discriminatorHolder", "Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;)V", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "currentIndex", "", "elementMarker", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "getJson", "()Lkotlinx/serialization/json/Json;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "checkLeadingComma", "", "coerceInputValue", "", "index", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "decodeInt", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeListIndex", "decodeLong", "", "decodeMapIndex", "decodeNotNullMark", "decodeNull", "", "decodeObjectIndex", "decodeSerializableElement", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "previousValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "decodeStringChunked", "consumeChunk", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "chunk", "decodeStringKey", "endStructure", "handleUnknown", "key", "skipLeftoverElements", "trySkip", "unknownKey", "DiscriminatorHolder", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStreamingJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoder\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 3 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 4 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoderKt\n*L\n1#1,391:1\n531#2,3:392\n531#2,3:395\n119#3,17:398\n384#4,5:415\n384#4,5:420\n*S KotlinDebug\n*F\n+ 1 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoder\n*L\n202#1:392,3\n203#1:395,3\n215#1:398,17\n308#1:415,5\n315#1:420,5\n*E\n"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder,
ChunkedDecoder {
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final AbstractJsonLexer lexer;
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @Nullable
    private DiscriminatorHolder discriminatorHolder;
    @NotNull
    private final JsonConfiguration configuration;
    @Nullable
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(@NotNull Json json, @NotNull WriteMode mode, @NotNull AbstractJsonLexer lexer, @NotNull SerialDescriptor descriptor2, @Nullable DiscriminatorHolder discriminatorHolder) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.json = json;
        this.mode = mode;
        this.lexer = lexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.discriminatorHolder = discriminatorHolder;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(descriptor2);
    }

    @Override
    @NotNull
    public final Json getJson() {
        return this.json;
    }

    private final boolean trySkip(DiscriminatorHolder $this$trySkip, String unknownKey) {
        if ($this$trySkip == null) {
            return false;
        }
        if (Intrinsics.areEqual($this$trySkip.discriminatorToSkip, unknownKey)) {
            $this$trySkip.discriminatorToSkip = null;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        try {
            DeserializationStrategy deserializationStrategy;
            if (!(deserializer instanceof AbstractPolymorphicSerializer) || this.json.getConfiguration().getUseArrayPolymorphism()) {
                return deserializer.deserialize(this);
            }
            String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), this.json);
            String string2 = this.lexer.peekLeadingMatchingValue(discriminator, this.configuration.isLenient());
            if (string2 == null) {
                return PolymorphicKt.decodeSerializableValuePolymorphic(this, deserializer);
            }
            String type2 = string2;
            try {
                deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer, this, type2);
            }
            catch (SerializationException it) {
                String string3 = it.getMessage();
                Intrinsics.checkNotNull(string3);
                String message = StringsKt.removeSuffix(StringsKt.substringBefore$default(string3, '\n', null, 2, null), (CharSequence)".");
                String string4 = it.getMessage();
                Intrinsics.checkNotNull(string4);
                String hint = StringsKt.substringAfter(string4, '\n', "");
                AbstractJsonLexer.fail$default(this.lexer, message, 0, hint, 2, null);
                throw new KotlinNothingValueException();
            }
            DeserializationStrategy deserializationStrategy2 = deserializationStrategy;
            Intrinsics.checkNotNull(deserializationStrategy2, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeSerializableValue>");
            DeserializationStrategy actualSerializer = deserializationStrategy2;
            this.discriminatorHolder = new DiscriminatorHolder(discriminator);
            return actualSerializer.deserialize(this);
        }
        catch (MissingFieldException e2) {
            String string5 = e2.getMessage();
            Intrinsics.checkNotNull(string5);
            if (StringsKt.contains$default((CharSequence)string5, "at path", false, 2, null)) {
                throw e2;
            }
            throw new MissingFieldException(e2.getMissingFields(), e2.getMessage() + " at path: " + this.lexer.path.getPath(), e2);
        }
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.json, descriptor2);
        this.lexer.path.pushDescriptor(descriptor2);
        this.lexer.consumeNextToken(newMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2, this.discriminatorHolder);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2, this.discriminatorHolder);
            }
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.json.getConfiguration().getIgnoreUnknownKeys() && descriptor2.getElementsCount() == 0) {
            this.skipLeftoverElements(descriptor2);
        }
        if (this.lexer.tryConsumeComma() && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma(this.lexer, "");
            throw new KotlinNothingValueException();
        }
        this.lexer.consumeNextToken(this.mode.end);
        this.lexer.path.popDescriptor();
    }

    private final void skipLeftoverElements(SerialDescriptor descriptor2) {
        while (this.decodeElementIndex(descriptor2) != -1) {
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker != null ? jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json() : false) && !AbstractJsonLexer.tryConsumeNull$default(this.lexer, false, 1, null);
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public <T> T decodeSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        boolean isMapKey;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        boolean bl2 = isMapKey = this.mode == WriteMode.MAP && (index & 1) == 0;
        if (isMapKey) {
            this.lexer.path.resetCurrentMapKey();
        }
        T value = super.decodeSerializableElement(descriptor2, index, deserializer, previousValue);
        if (isMapKey) {
            this.lexer.path.updateCurrentMapKey(value);
        }
        return value;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int index;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                int n2 = this.decodeObjectIndex(descriptor2);
                break;
            }
            case 2: {
                int n2 = this.decodeMapIndex();
                break;
            }
            default: {
                int n2 = index = this.decodeListIndex();
            }
        }
        if (this.mode != WriteMode.MAP) {
            this.lexer.path.updateDescriptorIndex(index);
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeMapIndex() {
        int n2;
        boolean decodingKey;
        boolean hasComma = false;
        boolean bl2 = decodingKey = this.currentIndex % 2 != 0;
        if (decodingKey) {
            if (this.currentIndex != -1) {
                hasComma = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (decodingKey) {
                if (this.currentIndex == -1) {
                    void $this$iv;
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean condition$iv = !hasComma;
                    int position$iv = $this$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        void var8_11 = $this$iv;
                        boolean bl3 = false;
                        AbstractJsonLexer.fail$default((AbstractJsonLexer)var8_11, "Unexpected leading comma", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer $this$iv = this.lexer;
                    int position$iv = $this$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!hasComma) {
                        AbstractJsonLexer abstractJsonLexer = $this$iv;
                        boolean bl4 = false;
                        AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected comma after the key-value pair", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            n2 = ++this.currentIndex;
        } else {
            if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
                throw new KotlinNothingValueException();
            }
            n2 = -1;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index) {
        boolean bl2;
        boolean it;
        Json $this$tryCoerceValue$iv = this.json;
        boolean $i$f$tryCoerceValue = false;
        if (!descriptor2.isElementOptional(index)) {
            return false;
        }
        SerialDescriptor elementDescriptor$iv = descriptor2.getElementDescriptor(index);
        if (!elementDescriptor$iv.isNullable()) {
            it = true;
            bl2 = false;
            if (this.lexer.tryConsumeNull(it)) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        if (elementDescriptor$iv.isNullable()) {
            it = false;
            bl2 = false;
            if (this.lexer.tryConsumeNull(it)) {
                return false;
            }
        }
        boolean bl3 = false;
        String string2 = this.lexer.peekString(this.configuration.isLenient());
        if (string2 == null) {
            return false;
        }
        String enumValue$iv = string2;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, $this$tryCoerceValue$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        boolean bl4 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor descriptor2) {
        boolean hasComma = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean isUnknown;
            boolean bl2;
            String key;
            block5: {
                hasComma = false;
                key = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int index = JsonNamesMapKt.getJsonNameIndex(descriptor2, this.json, key);
                if (index != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index)) {
                        hasComma = this.lexer.tryConsumeComma();
                        bl2 = false;
                        break block5;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) return index;
                        jsonElementMarker.mark$kotlinx_serialization_json(index);
                        return index;
                    }
                }
                bl2 = true;
            }
            if (!(isUnknown = bl2)) continue;
            hasComma = this.handleUnknown(key);
        }
        if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) return -1;
        int n2 = jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
        return n2;
    }

    private final boolean handleUnknown(String key) {
        if (this.configuration.getIgnoreUnknownKeys() || this.trySkip(this.discriminatorHolder, key)) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.failOnUnknownKey(key);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n2;
        boolean hasComma = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n2 = ++this.currentIndex;
        } else {
            if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma(this.lexer, "array");
                throw new KotlinNothingValueException();
            }
            n2 = -1;
        }
        return n2;
    }

    @Override
    public boolean decodeBoolean() {
        return this.lexer.consumeBooleanLenient();
    }

    @Override
    public byte decodeByte() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((byte)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (byte)value;
    }

    @Override
    public short decodeShort() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((short)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (short)value;
    }

    @Override
    public int decodeInt() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((int)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (int)value;
    }

    @Override
    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float decodeFloat() {
        float f2;
        float f3;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "float";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeFloat_u24lambda_u245 = input$iv;
            boolean bl2 = false;
            f3 = Float.parseFloat($this$decodeFloat_u24lambda_u245);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        float result2 = f3;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Float.isInfinite(f2 = result2) && !Float.isNaN(f2)) {
            return result2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(result2));
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double decodeDouble() {
        double d2;
        double d3;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "double";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeDouble_u24lambda_u246 = input$iv;
            boolean bl2 = false;
            d3 = Double.parseDouble($this$decodeDouble_u24lambda_u246);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        double result2 = d3;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Double.isInfinite(d2 = result2) && !Double.isNaN(d2)) {
            return result2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, result2);
        throw new KotlinNothingValueException();
    }

    @Override
    public char decodeChar() {
        String string2 = this.lexer.consumeStringLenient();
        if (string2.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string2 + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return string2.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    @Override
    public void decodeStringChunked(@NotNull Function1<? super String, Unit> consumeChunk) {
        Intrinsics.checkNotNullParameter(consumeChunk, "consumeChunk");
        this.lexer.consumeStringChunked(this.configuration.isLenient(), consumeChunk);
    }

    @Override
    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(descriptor2) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(descriptor2);
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(enumDescriptor, this.json, this.decodeString(), " at path " + this.lexer.path.getPath());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "", "discriminatorToSkip", "", "(Ljava/lang/String;)V", "kotlinx-serialization-json"})
    public static final class DiscriminatorHolder {
        @JvmField
        @Nullable
        public String discriminatorToSkip;

        public DiscriminatorHolder(@Nullable String discriminatorToSkip) {
            this.discriminatorToSkip = discriminatorToSkip;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.OBJ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

