/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.PlatformRandomKt;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b'\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lkotlin/random/Random;", "", "()V", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
@SourceDebugExtension(value={"SMAP\nRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Random.kt\nkotlin/random/Random\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
public abstract class Random {
    @NotNull
    public static final Default Default = new Default(null);
    @NotNull
    private static final Random defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    public int nextInt(int until) {
        return this.nextInt(0, until);
    }

    public int nextInt(int from, int until) {
        int rnd;
        boolean bl2;
        RandomKt.checkRangeBounds(from, until);
        int n2 = until - from;
        if (n2 > 0 || n2 == Integer.MIN_VALUE) {
            int n3;
            if ((n2 & -n2) == n2) {
                int bitCount = RandomKt.fastLog2(n2);
                n3 = this.nextBits(bitCount);
            } else {
                int bits;
                int v2 = 0;
                while ((bits = this.nextInt() >>> 1) - (v2 = bits % n2) + (n2 - 1) < 0) {
                }
                n3 = v2;
            }
            int rnd2 = n3;
            return from + rnd2;
        }
        do {
            if (from <= (rnd = this.nextInt())) {
                if (rnd < until) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        } while (!bl2);
        return rnd;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public long nextLong(long until) {
        return this.nextLong(0L, until);
    }

    public long nextLong(long from, long until) {
        long rnd;
        boolean bl2;
        RandomKt.checkRangeBounds(from, until);
        long n2 = until - from;
        if (n2 > 0L) {
            long rnd2 = 0L;
            if ((n2 & -n2) == n2) {
                long l2;
                int bitCount;
                int nLow = (int)n2;
                int nHigh = (int)(n2 >>> 32);
                if (nLow != 0) {
                    bitCount = RandomKt.fastLog2(nLow);
                    l2 = (long)this.nextBits(bitCount) & 0xFFFFFFFFL;
                } else if (nHigh == 1) {
                    l2 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    bitCount = RandomKt.fastLog2(nHigh);
                    l2 = ((long)this.nextBits(bitCount) << 32) + ((long)this.nextInt() & 0xFFFFFFFFL);
                }
                rnd2 = l2;
            } else {
                long bits;
                long v2 = 0L;
                while ((bits = this.nextLong() >>> 1) - (v2 = bits % n2) + (n2 - 1L) < 0L) {
                }
                rnd2 = v2;
            }
            return from + rnd2;
        }
        do {
            if (from <= (rnd = this.nextLong())) {
                if (rnd < until) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        } while (!bl2);
        return rnd;
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    public double nextDouble(double until) {
        return this.nextDouble(0.0, until);
    }

    public double nextDouble(double from, double until) {
        double d2;
        double d3;
        RandomKt.checkRangeBounds(from, until);
        double size = until - from;
        if (Double.isInfinite(size) && !Double.isInfinite(d3 = from) && !Double.isNaN(d3) && !Double.isInfinite(d3 = until) && !Double.isNaN(d3)) {
            double r1 = this.nextDouble() * (until / (double)2 - from / (double)2);
            d2 = from + r1 + r1;
        } else {
            d2 = from + this.nextDouble() * size;
        }
        double r2 = d2;
        return r2 >= until ? Math.nextAfter(until, Double.NEGATIVE_INFINITY) : r2;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / 1.6777216E7f;
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(array, "array");
        boolean bl3 = bl2 = new IntRange(0, array.length).contains(fromIndex) && new IntRange(0, array.length).contains(toIndex);
        if (!bl2) {
            boolean $i$a$-require-Random$nextBytes$32 = false;
            String $i$a$-require-Random$nextBytes$32 = "fromIndex (" + fromIndex + ") or toIndex (" + toIndex + ") are out of range: 0.." + array.length + '.';
            throw new IllegalArgumentException($i$a$-require-Random$nextBytes$32.toString());
        }
        boolean bl4 = bl2 = fromIndex <= toIndex;
        if (!bl2) {
            boolean $i$a$-require-Random$nextBytes$42 = false;
            String $i$a$-require-Random$nextBytes$42 = "fromIndex (" + fromIndex + ") must be not greater than toIndex (" + toIndex + ").";
            throw new IllegalArgumentException($i$a$-require-Random$nextBytes$42.toString());
        }
        int steps = (toIndex - fromIndex) / 4;
        int position = 0;
        position = fromIndex;
        int n2 = 0;
        while (n2 < steps) {
            int it = n2++;
            boolean bl5 = false;
            int v2 = this.nextInt();
            array[position] = (byte)v2;
            array[position + 1] = (byte)(v2 >>> 8);
            array[position + 2] = (byte)(v2 >>> 16);
            array[position + 3] = (byte)(v2 >>> 24);
            position += 4;
        }
        int remainder = toIndex - position;
        int vr = this.nextBits(remainder * 8);
        for (int i2 = 0; i2 < remainder; ++i2) {
            array[position + i2] = (byte)(vr >>> i2 * 8);
        }
        return array;
    }

    public static /* synthetic */ byte[] nextBytes$default(Random random2, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return random2.nextBytes(byArray, n2, n3);
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return this.nextBytes(array, 0, array.length);
    }

    @NotNull
    public byte[] nextBytes(int size) {
        return this.nextBytes(new byte[size]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlin/random/Random$Default;", "Lkotlin/random/Random;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "()V", "defaultRandom", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "writeReplace", "", "Serialized", "kotlin-stdlib"})
    public static final class Default
    extends Random
    implements Serializable {
        private Default() {
        }

        private final Object writeReplace() {
            return Serialized.INSTANCE;
        }

        @Override
        public int nextBits(int bitCount) {
            return defaultRandom.nextBits(bitCount);
        }

        @Override
        public int nextInt() {
            return defaultRandom.nextInt();
        }

        @Override
        public int nextInt(int until) {
            return defaultRandom.nextInt(until);
        }

        @Override
        public int nextInt(int from, int until) {
            return defaultRandom.nextInt(from, until);
        }

        @Override
        public long nextLong() {
            return defaultRandom.nextLong();
        }

        @Override
        public long nextLong(long until) {
            return defaultRandom.nextLong(until);
        }

        @Override
        public long nextLong(long from, long until) {
            return defaultRandom.nextLong(from, until);
        }

        @Override
        public boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public double nextDouble() {
            return defaultRandom.nextDouble();
        }

        @Override
        public double nextDouble(double until) {
            return defaultRandom.nextDouble(until);
        }

        @Override
        public double nextDouble(double from, double until) {
            return defaultRandom.nextDouble(from, until);
        }

        @Override
        public float nextFloat() {
            return defaultRandom.nextFloat();
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter(array, "array");
            return defaultRandom.nextBytes(array);
        }

        @Override
        @NotNull
        public byte[] nextBytes(int size) {
            return defaultRandom.nextBytes(size);
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
            Intrinsics.checkNotNullParameter(array, "array");
            return defaultRandom.nextBytes(array, fromIndex, toIndex);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkotlin/random/Random$Default$Serialized;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "()V", "serialVersionUID", "", "readResolve", "", "kotlin-stdlib"})
        private static final class Serialized
        implements Serializable {
            @NotNull
            public static final Serialized INSTANCE = new Serialized();
            private static final long serialVersionUID = 0L;

            private Serialized() {
            }

            private final Object readResolve() {
                return Default;
            }
        }
    }
}

