/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;

public final class FormFactory {
    public static final ColumnSpec MIN_COLSPEC = new ColumnSpec(Sizes.MINIMUM);
    public static final ColumnSpec PREF_COLSPEC = new ColumnSpec(Sizes.PREFERRED);
    public static final ColumnSpec DEFAULT_COLSPEC = new ColumnSpec(Sizes.DEFAULT);
    public static final ColumnSpec GLUE_COLSPEC = new ColumnSpec(ColumnSpec.DEFAULT, Sizes.ZERO, 1.0);
    public static final ColumnSpec LABEL_COMPONENT_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getLabelComponentPadX());
    public static final ColumnSpec RELATED_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getRelatedComponentsPadX());
    public static final ColumnSpec UNRELATED_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getUnrelatedComponentsPadX());
    public static final ColumnSpec BUTTON_COLSPEC = new ColumnSpec(Sizes.bounded(Sizes.PREFERRED, LayoutStyle.getCurrent().getDefaultButtonWidth(), null));
    public static final ColumnSpec GROWING_BUTTON_COLSPEC = new ColumnSpec(ColumnSpec.DEFAULT, BUTTON_COLSPEC.getSize(), 1.0);
    public static final RowSpec MIN_ROWSPEC = new RowSpec(Sizes.MINIMUM);
    public static final RowSpec PREF_ROWSPEC = new RowSpec(Sizes.PREFERRED);
    public static final RowSpec DEFAULT_ROWSPEC = new RowSpec(Sizes.DEFAULT);
    public static final RowSpec GLUE_ROWSPEC = new RowSpec(RowSpec.DEFAULT, Sizes.ZERO, 1.0);
    public static final RowSpec RELATED_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getRelatedComponentsPadY());
    public static final RowSpec UNRELATED_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getUnrelatedComponentsPadY());
    public static final RowSpec NARROW_LINE_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getNarrowLinePad());
    public static final RowSpec LINE_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getLinePad());
    public static final RowSpec PARAGRAPH_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getParagraphPad());

    private FormFactory() {
    }

    public static FormLayout createColumnLayout(int majorColumns, int minorColumns, ColumnSpec labelColumnSpec) {
        return FormFactory.createColumnLayout(majorColumns, minorColumns, labelColumnSpec, Sizes.DLUX14, Sizes.DLUX2);
    }

    public static FormLayout createColumnLayout(int majorColumns, int minorColumns, ColumnSpec labelColumnSpec, ConstantSize indent, ConstantSize minorColumnGap) {
        return FormFactory.createColumnLayout(majorColumns, minorColumns, labelColumnSpec, PREF_COLSPEC, indent, Sizes.DLUX14, minorColumnGap);
    }

    public static FormLayout createColumnLayout(int majorColumns, int minorColumns, ColumnSpec labelColumnSpec, ColumnSpec componentColumnSpec, ConstantSize indent, ConstantSize majorColumnGap, ConstantSize minorColumnGap) {
        ColumnSpec majorGapColSpec = FormFactory.createGapColumnSpec(majorColumnGap);
        ColumnSpec minorGapColSpec = FormFactory.createGapColumnSpec(minorColumnGap);
        FormLayout layout = new FormLayout(new ColumnSpec[0], new RowSpec[0]);
        if (indent != null) {
            layout.appendColumn(FormFactory.createGapColumnSpec(indent));
        }
        for (int i2 = 0; i2 < majorColumns; ++i2) {
            if (labelColumnSpec != null) {
                layout.appendColumn(labelColumnSpec);
                layout.appendColumn(RELATED_GAP_COLSPEC);
            }
            for (int j2 = 0; j2 < minorColumns; ++j2) {
                layout.appendColumn(componentColumnSpec);
                layout.addGroupedColumn(layout.getColumnCount());
                if (j2 >= minorColumns - 1) continue;
                layout.appendColumn(minorGapColSpec);
            }
            if (i2 >= majorColumns - 1) continue;
            layout.appendColumn(majorGapColSpec);
        }
        return layout;
    }

    public static ColumnSpec createGapColumnSpec(ConstantSize gapSize) {
        return new ColumnSpec(ColumnSpec.LEFT, gapSize, 0.0);
    }

    public static RowSpec createGapRowSpec(ConstantSize gapSize) {
        return new RowSpec(RowSpec.TOP, gapSize, 0.0);
    }
}

