/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderTextRanges {
    private PlaceholderTextRanges() {
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s2, @NotNull String prefix, @NotNull String suffix) {
        if (s2 == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(2);
        }
        return PlaceholderTextRanges.getPlaceholderRanges(s2, prefix, suffix, false);
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s2, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange) {
        if (s2 == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(5);
        }
        return PlaceholderTextRanges.getPlaceholderRanges(s2, prefix, suffix, useFullTextRange, false);
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s2, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange, boolean filterNestedRanges) {
        int nextSuffix;
        if (s2 == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(7);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(8);
        }
        if (!s2.contains(prefix)) {
            Set<TextRange> set = Collections.emptySet();
            if (set == null) {
                PlaceholderTextRanges.$$$reportNull$$$0(9);
            }
            return set;
        }
        LinkedHashSet<TextRange> ranges = new LinkedHashSet<TextRange>(2);
        ArrayDeque<Integer> prefixes = new ArrayDeque<Integer>();
        int searchFrom = 0;
        while (searchFrom < s2.length() && (nextSuffix = s2.indexOf(suffix, searchFrom)) >= 0) {
            int nextPrefix = s2.indexOf(prefix, searchFrom);
            if (prefixes.isEmpty()) {
                if (nextPrefix < 0) break;
                prefixes.push(nextPrefix);
                searchFrom = nextPrefix + 1;
                continue;
            }
            if (nextPrefix < 0 || nextSuffix <= nextPrefix || nextPrefix + prefix.length() > nextSuffix) {
                int prefixPairPos = (Integer)prefixes.pop();
                int startOffset = prefixPairPos + (useFullTextRange ? 0 : prefix.length());
                int endOffset = useFullTextRange ? nextSuffix + suffix.length() : nextSuffix;
                ranges.add(TextRange.create(startOffset, endOffset));
                while (!prefixes.isEmpty() && (Integer)prefixes.peek() + prefix.length() > prefixPairPos) {
                    prefixes.pop();
                }
                searchFrom = nextSuffix + suffix.length();
                continue;
            }
            prefixes.push(nextPrefix);
            searchFrom = nextPrefix + 1;
        }
        Set<TextRange> set = filterNestedRanges ? PlaceholderTextRanges.filterNested(ranges) : ranges;
        if (set == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static Set<TextRange> filterNested(Set<? extends TextRange> allRanges) {
        LinkedHashSet<TextRange> filtered = new LinkedHashSet<TextRange>(allRanges.size());
        for (TextRange textRange : allRanges) {
            boolean contains = PlaceholderTextRanges.anyRangeContains(allRanges, textRange);
            if (contains) continue;
            filtered.add(textRange);
        }
        return filtered;
    }

    private static boolean anyRangeContains(Set<? extends TextRange> allRanges, TextRange inner) {
        for (TextRange textRange : allRanges) {
            if (inner.equals(textRange) || !textRange.contains(inner)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/PlaceholderTextRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/PlaceholderTextRanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderRanges";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

