/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class Enumerator<T> {
    private static final LoggerRt LOG = LoggerRt.getInstance(Enumerator.class);
    private final Object2IntMap<T> myNumbers;
    private int myNextNumber;

    public Enumerator(int expectNumber) {
        this(expectNumber, HashingStrategy.canonical());
    }

    public Enumerator(int expectNumber, final @NotNull HashingStrategy<? super T> strategy) {
        if (strategy == null) {
            Enumerator.$$$reportNull$$$0(0);
        }
        this.myNextNumber = 1;
        this.myNumbers = strategy == HashingStrategy.canonical() ? new Object2IntOpenHashMap(expectNumber) : new Object2IntOpenCustomHashMap(expectNumber, new Hash.Strategy<T>(){

            @Override
            public int hashCode(@Nullable T o2) {
                return strategy.hashCode(o2);
            }

            @Override
            public boolean equals(@Nullable T a2, @Nullable T b2) {
                return strategy.equals(a2, b2);
            }
        });
    }

    public void clear() {
        this.myNumbers.clear();
        this.myNextNumber = 1;
    }

    public int @NotNull [] enumerate(T @NotNull [] objects) {
        if (objects == null) {
            Enumerator.$$$reportNull$$$0(1);
        }
        int[] nArray = this.enumerate(objects, 0, 0);
        if (nArray == null) {
            Enumerator.$$$reportNull$$$0(2);
        }
        return nArray;
    }

    public int @NotNull [] enumerate(T @NotNull [] objects, int startShift, int endCut) {
        if (objects == null) {
            Enumerator.$$$reportNull$$$0(3);
        }
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i2 = startShift; i2 < objects.length - endCut; ++i2) {
            int number;
            T object = objects[i2];
            idx[i2 - startShift] = number = this.enumerate(object);
        }
        if (idx == null) {
            Enumerator.$$$reportNull$$$0(4);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res = this.enumerateImpl(object);
        return Math.abs(res);
    }

    public boolean add(T object) {
        int res = this.enumerateImpl(object);
        return res < 0;
    }

    protected int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.getInt(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public boolean contains(@NotNull T object) {
        if (object == null) {
            Enumerator.$$$reportNull$$$0(5);
        }
        return this.myNumbers.getInt(object) != 0;
    }

    public int get(T object) {
        if (object == null) {
            return 0;
        }
        int res = this.myNumbers.getInt(object);
        if (res == 0) {
            LOG.error("Object " + object + " must be already added to enumerator!");
        }
        return res;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Object2IntMap.Entry entry : this.myNumbers.object2IntEntrySet()) {
            buffer.append(entry.getIntValue()).append(": ").append(entry.getKey()).append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/Enumerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/Enumerator";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

