/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public abstract class WeakReferenceDisposable<T>
extends WeakReference<T>
implements Disposable {
    private static final ReferenceQueue<Object> ourRefQueue = new ReferenceQueue();

    public WeakReferenceDisposable(@NotNull T referent) {
        if (referent == null) {
            WeakReferenceDisposable.$$$reportNull$$$0(0);
        }
        super(referent, ourRefQueue);
        WeakReferenceDisposable.reapCollectedRefs();
    }

    @Override
    public final void dispose() {
        Object referent = this.get();
        if (referent == null) {
            return;
        }
        this.clear();
        this.disposeReferent(referent);
    }

    protected abstract void disposeReferent(@NotNull T var1);

    private static void reapCollectedRefs() {
        Reference<Object> ref;
        while ((ref = ourRefQueue.poll()) != null) {
            if (!(ref instanceof WeakReferenceDisposable)) continue;
            Disposer.dispose((Disposable)((Object)ref));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/openapi/WeakReferenceDisposable", "<init>"));
    }
}

