/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.model.local;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.searchEverywhereMl.SearchEverywhereTabWithMlRanking;
import com.intellij.searchEverywhereMl.ranking.core.model.local.LocalCatBoostModelProvider;
import com.intellij.searchEverywhereMl.ranking.core.model.local.LocalModelProvider;
import com.intellij.searchEverywhereMl.ranking.core.model.local.LocalZipModelProvider;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/model/local/LocalRankingModelProviderUtil;", "", "()V", "getLocalModel", "Lcom/intellij/internal/ml/DecisionFunction;", "tab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTabWithMlRanking;", "getPath", "", "Lorg/jetbrains/annotations/NotNull;", "getRegistryKey", "isPathToLocalModelSpecified", "", "intellij.searchEverywhereMl.ranking.core"})
public final class LocalRankingModelProviderUtil {
    @NotNull
    public static final LocalRankingModelProviderUtil INSTANCE = new LocalRankingModelProviderUtil();

    private LocalRankingModelProviderUtil() {
    }

    @Nullable
    public final DecisionFunction getLocalModel(@NotNull SearchEverywhereTabWithMlRanking tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        if (!this.isPathToLocalModelSpecified(tab)) {
            return null;
        }
        String path = this.getPath(tab);
        LocalModelProvider provider = StringsKt.endsWith$default((String)path, (String)".zip", (boolean)false, (int)2, null) ? (LocalModelProvider)new LocalZipModelProvider() : (LocalModelProvider)new LocalCatBoostModelProvider();
        return provider.loadModel(path);
    }

    public final boolean isPathToLocalModelSpecified(@NotNull SearchEverywhereTabWithMlRanking tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        return Registry.get((String)this.getRegistryKey(tab)).isChangedFromDefault();
    }

    private final String getRegistryKey(SearchEverywhereTabWithMlRanking tab) {
        String string = tab.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "search.everywhere.ml." + string + ".model.path";
    }

    private final String getPath(SearchEverywhereTabWithMlRanking tab) {
        String string = Registry.stringValue((String)this.getRegistryKey(tab));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        return string;
    }
}

