/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.io.IOException;
import kotlin.Unit;
import org.jetbrains.sqlite.SqliteConnection;

public abstract class BusyHandler {
    protected abstract int callback(int var1);

    private static void commitHandler(SqliteConnection connection, BusyHandler busyHandler) throws IOException {
        if (connection.isClosed()) {
            throw new IOException("connection closed");
        }
        connection.useDb$intellij_platform_sqlite(db -> {
            db.busy_handler(busyHandler);
            return Unit.INSTANCE;
        });
    }

    public static void setHandler(SqliteConnection conn, BusyHandler busyHandler) throws IOException {
        BusyHandler.commitHandler(conn, busyHandler);
    }

    public static void clearHandler(SqliteConnection conn) throws IOException {
        BusyHandler.commitHandler(conn, null);
    }
}

