/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.thaiopensource.datatype.xsd.DatatypeLibraryFactoryImpl;
import com.thaiopensource.relaxng.impl.SchemaReaderImpl;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.xml.sax.Sax2XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.StringReader;
import java.util.concurrent.ConcurrentMap;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.kohsuke.rngom.ast.builder.BuildException;
import org.kohsuke.rngom.ast.builder.IncludedGrammar;
import org.kohsuke.rngom.ast.builder.SchemaBuilder;
import org.kohsuke.rngom.ast.om.ParsedPattern;
import org.kohsuke.rngom.binary.SchemaBuilderImpl;
import org.kohsuke.rngom.binary.SchemaPatternBuilder;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DSchemaBuilderImpl;
import org.kohsuke.rngom.dt.CachedDatatypeLibraryFactory;
import org.kohsuke.rngom.dt.CascadingDatatypeLibraryFactory;
import org.kohsuke.rngom.dt.DoNothingDatatypeLibraryFactoryImpl;
import org.kohsuke.rngom.dt.builtin.BuiltinDatatypeLibraryFactory;
import org.kohsuke.rngom.parse.IllegalSchemaException;
import org.kohsuke.rngom.parse.compact.CompactParseable;
import org.kohsuke.rngom.parse.xml.SAXParseable;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class RngParser {
    private static final Logger LOG = Logger.getInstance(RngParser.class);
    private static final NotNullLazyValue<DatatypeLibraryFactory> DT_LIBRARY_FACTORY = NotNullLazyValue.atomicLazy(() -> new BuiltinDatatypeLibraryFactory(new CachedDatatypeLibraryFactory(new CascadingDatatypeLibraryFactory(RngParser.createXsdDatatypeFactory(), new DatatypeLibraryLoader())){

        @Override
        public synchronized DatatypeLibrary createDatatypeLibrary(String namespaceURI) {
            return super.createDatatypeLibrary(namespaceURI);
        }
    }));
    private static final ConcurrentMap<String, DPattern> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    static final Key<CachedValue<Schema>> SCHEMA_KEY = Key.create((String)"SCHEMA");
    public static final DefaultHandler DEFAULT_HANDLER = new DefaultHandler(){

        @Override
        public void error(SAXParseException e) {
            LOG.info("e.getMessage() = " + e.getMessage() + " [" + e.getSystemId() + "]");
            LOG.info((Throwable)e);
        }
    };
    static final PropertyMap EMPTY_PROPS = new PropertyMapBuilder().toPropertyMap();

    private static DatatypeLibraryFactory createXsdDatatypeFactory() {
        try {
            return new DatatypeLibraryFactoryImpl();
        }
        catch (Throwable e) {
            LOG.error("Could not create DT library implementation 'com.thaiopensource.datatype.xsd.DatatypeLibraryFactoryImpl'. Plugin's classpath seems to be broken.", e);
            return new DoNothingDatatypeLibraryFactoryImpl();
        }
    }

    public static DPattern getCachedPattern(PsiFile descriptorFile, ErrorHandler eh) {
        VirtualFile file = descriptorFile.getVirtualFile();
        if (file == null) {
            return RngParser.parsePattern(descriptorFile, eh, false);
        }
        String url = file.getUrl();
        DPattern pattern2 = (DPattern)ourCache.get(url);
        if (pattern2 == null) {
            pattern2 = RngParser.parsePattern(descriptorFile, eh, false);
        }
        if (pattern2 != null) {
            ourCache.put(url, pattern2);
        }
        return pattern2;
    }

    public static DPattern parsePattern(PsiFile file, ErrorHandler eh, boolean checking) {
        block5: {
            try {
                org.kohsuke.rngom.parse.Parseable p = RngParser.createParsable(file, eh);
                if (!checking) {
                    return p.parse(new DSchemaBuilderImpl());
                }
                p.parse(new SchemaBuilderImpl(eh, (DatatypeLibraryFactory)DT_LIBRARY_FACTORY.getValue(), new SchemaPatternBuilder()));
            }
            catch (BuildException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalSchemaException e) {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) break block5;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invalid schema: " + virtualFile.getPresentableUrl(), (Throwable)e);
                }
                LOG.info("invalid schema: " + virtualFile.getPresentableUrl() + ". [" + e.getMessage() + "]");
            }
        }
        return null;
    }

    private static org.kohsuke.rngom.parse.Parseable createParsable(PsiFile file, ErrorHandler eh) {
        InputSource source2 = RngParser.makeInputSource(file);
        final VirtualFile virtualFile = file.getVirtualFile();
        if (file.getFileType() == RncFileType.getInstance()) {
            return new CompactParseable(source2, eh){

                @Override
                public ParsedPattern parseInclude(String uri, SchemaBuilder schemaBuilder, IncludedGrammar g, String inheritedNs) throws BuildException, IllegalSchemaException {
                    ProgressManager.checkCanceled();
                    return super.parseInclude(RngParser.resolveURI(virtualFile, uri), schemaBuilder, g, inheritedNs);
                }
            };
        }
        return new SAXParseable(source2, eh){

            @Override
            public ParsedPattern parseInclude(String uri, SchemaBuilder schemaBuilder, IncludedGrammar g, String inheritedNs) throws BuildException, IllegalSchemaException {
                ProgressManager.checkCanceled();
                return super.parseInclude(RngParser.resolveURI(virtualFile, uri), schemaBuilder, g, inheritedNs);
            }
        };
    }

    private static String resolveURI(VirtualFile descriptorFile, String s) {
        VirtualFile file = UriUtil.findRelativeFile(s, descriptorFile);
        if (file != null) {
            s = VfsUtilCore.fixIDEAUrl((String)file.getUrl());
        }
        return s;
    }

    public static Schema getCachedSchema(XmlFile descriptorFile) {
        CachedValue value = (CachedValue)descriptorFile.getUserData(SCHEMA_KEY);
        if (value == null) {
            CachedValueProvider provider = () -> {
                InputSource inputSource = RngParser.makeInputSource(descriptorFile);
                try {
                    Schema schema = new MySchemaReader(descriptorFile).createSchema(inputSource, EMPTY_PROPS);
                    PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements();
                    RelaxIncludeIndex.processForwardDependencies(descriptorFile, (PsiElementProcessor<? super XmlFile>)processor);
                    if (processor.getCollection().size() > 0) {
                        return CachedValueProvider.Result.create((Object)schema, (Object[])new Object[]{processor.toArray(), descriptorFile});
                    }
                    return CachedValueProvider.Result.createSingleDependency((Object)schema, (Object)descriptorFile);
                }
                catch (Exception e) {
                    VirtualFile vf = descriptorFile.getVirtualFile();
                    LOG.info("For descriptor file: " + (vf != null ? vf.getPath() : descriptorFile.getName()), (Throwable)e);
                    return CachedValueProvider.Result.createSingleDependency(null, (Object)descriptorFile);
                }
            };
            CachedValuesManager mgr = CachedValuesManager.getManager((Project)descriptorFile.getProject());
            value = mgr.createCachedValue(provider, false);
            descriptorFile.putUserData(SCHEMA_KEY, value);
        }
        return (Schema)value.getValue();
    }

    private static InputSource makeInputSource(PsiFile descriptorFile) {
        InputSource inputSource = new InputSource(new StringReader(descriptorFile.getText()));
        VirtualFile file = descriptorFile.getVirtualFile();
        if (file != null) {
            inputSource.setSystemId(VfsUtilCore.fixIDEAUrl((String)file.getUrl()));
        }
        return inputSource;
    }

    static class MySchemaReader
    extends SchemaReaderImpl {
        private final PsiFile myDescriptorFile;

        MySchemaReader(PsiFile descriptorFile) {
            this.myDescriptorFile = descriptorFile;
        }

        @Override
        protected Parseable createParseable(XMLReaderCreator xmlReaderCreator, InputSource inputSource, ErrorHandler errorHandler) {
            if (this.myDescriptorFile.getFileType() == RncFileType.getInstance()) {
                return new com.thaiopensource.relaxng.parse.compact.CompactParseable(inputSource, errorHandler);
            }
            return new com.thaiopensource.relaxng.parse.sax.SAXParseable(new Sax2XMLReaderCreator(), inputSource, errorHandler);
        }
    }
}

