/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncExternalRef;
import org.intellij.plugins.relaxNG.compact.psi.RncInclude;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.RncParentRef;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.jetbrains.annotations.NotNull;

public class ReferenceAnnotator
extends RncElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    public synchronized void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ReferenceAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ReferenceAnnotator.$$$reportNull$$$0(1);
        }
        this.myHolder = holder;
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitInclude(RncInclude include) {
        this.checkReferences(include.getReferences());
    }

    @Override
    public void visitExternalRef(RncExternalRef ref) {
        this.checkReferences(ref.getReferences());
    }

    @Override
    public void visitRef(RncRef pattern2) {
        this.checkReferences(pattern2.getReferences());
    }

    @Override
    public void visitParentRef(RncParentRef pattern2) {
        this.checkReferences(pattern2.getReferences());
    }

    @Override
    public void visitName(RncName name) {
        this.checkReferences(name.getReferences());
    }

    private void checkReferences(PsiReference[] references) {
        for (PsiReference reference : references) {
            if (reference.isSoft() || reference.resolve() != null) continue;
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference pvr = (PsiPolyVariantReference)reference;
                if (pvr.multiResolve(false).length != 0) continue;
                this.addError(reference);
                continue;
            }
            this.addError(reference);
        }
    }

    private void addError(PsiReference reference) {
        LocalQuickFix[] fixes;
        String description2;
        TextRange rangeInElement = reference.getRangeInElement();
        TextRange range = TextRange.from((int)(reference.getElement().getTextRange().getStartOffset() + rangeInElement.getStartOffset()), (int)rangeInElement.getLength());
        String message2 = reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description2 = BundleBase.format((String)message2, (Object[])new Object[]{reference.getCanonicalText()});
        }
        catch (IllegalArgumentException ex) {
            description2 = message2;
        }
        AnnotationBuilder builder2 = this.myHolder.newAnnotation(HighlightSeverity.ERROR, description2).range(range).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        if (reference instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)reference.getElement().getProject());
            for (LocalQuickFix fix : fixes) {
                ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(reference.getElement(), message2, fix, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true);
                builder2 = builder2.newLocalQuickFix(fix, descriptor).registerFix();
            }
        }
        builder2.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/relaxNG/compact/ReferenceAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

