/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.regexp.inspection.custom.RegExpSample;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpSampleTree;", "", "doubleClickConsumer", "Lkotlin/Function1;", "Lorg/intellij/lang/regexp/inspection/custom/RegExpSample;", "", "(Lkotlin/jvm/functions/Function1;)V", "getDoubleClickConsumer", "()Lkotlin/jvm/functions/Function1;", "panel", "Ljavax/swing/JComponent;", "getPanel", "()Ljavax/swing/JComponent;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "getTree", "()Lcom/intellij/ui/treeStructure/Tree;", "treeModel", "Ljavax/swing/tree/TreeModel;", "getTreeModel", "()Ljavax/swing/tree/TreeModel;", "MyTreeCellRenderer", "intellij.regexp"})
@SourceDebugExtension(value={"SMAP\nRegExpSampleTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegExpSampleTree.kt\norg/intellij/lang/regexp/inspection/custom/RegExpSampleTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class RegExpSampleTree {
    @NotNull
    private final Function1<RegExpSample, Unit> doubleClickConsumer;
    @NotNull
    private final TreeModel treeModel;
    @NotNull
    private final Tree tree;

    /*
     * WARNING - void declaration
     */
    public RegExpSampleTree(@NotNull Function1<? super RegExpSample, Unit> doubleClickConsumer) {
        void $this$_init__u24lambda_u242;
        Tree tree;
        Intrinsics.checkNotNullParameter(doubleClickConsumer, (String)"doubleClickConsumer");
        this.doubleClickConsumer = doubleClickConsumer;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        this.treeModel = new DefaultTreeModel(root);
        Tree tree2 = tree = new Tree(this.treeModel);
        RegExpSampleTree regExpSampleTree = this;
        boolean bl = false;
        $this$_init__u24lambda_u242.setRootVisible(false);
        $this$_init__u24lambda_u242.setShowsRootHandles(true);
        $this$_init__u24lambda_u242.setDragEnabled(false);
        $this$_init__u24lambda_u242.setEditable(false);
        $this$_init__u24lambda_u242.getSelectionModel().setSelectionMode(1);
        TreeSpeedSearch treeSpeedSearch = TreeSpeedSearch.installOn((JTree)((JTree)$this$_init__u24lambda_u242), (boolean)false, RegExpSampleTree::lambda$2$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)treeSpeedSearch, (String)"installOn(...)");
        TreeSpeedSearch speedSearch = treeSpeedSearch;
        $this$_init__u24lambda_u242.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer(speedSearch)));
        regExpSampleTree.tree = tree;
        DefaultMutableTreeNode groups = new DefaultMutableTreeNode("Groups");
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Capturing", "()", 1, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Named", "(?<name>)", 8, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Non-capturing", "(?:)", 3, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Lookahead", "(?=)", 3, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Negative lookahead", "(?!)", 3, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Lookbehind", "(?<=)", 4, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Negative lookbehind", "(?<!)", 4, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Atomic", "(?>)", 3, "Groups", false)));
        groups.add(new DefaultMutableTreeNode(new RegExpSample("Comment", "(?#)", 3, "Groups", false)));
        root.add(groups);
        DefaultMutableTreeNode anchors = new DefaultMutableTreeNode("Anchors");
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("String or line start", "^", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("String start", "\\A", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("String or line end", "$", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("String end", "\\Z", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("Word boundary", "\\b", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("Non-word boundary", "\\B", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("Word start", "\\<", -1, "Anchors", false)));
        anchors.add(new DefaultMutableTreeNode(new RegExpSample("Word end", "\\>", -1, "Anchors", false)));
        root.add(anchors);
        DefaultMutableTreeNode classes = new DefaultMutableTreeNode("Character Classes");
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Control character", "\\c", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Whitespace", "\\s", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Non-whitespace", "\\S", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Digit", "\\d", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Non-digit", "\\D", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Word", "\\w", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Non-word", "\\W", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Hexadecimal digit", "\\x", -1, "Classes", false)));
        classes.add(new DefaultMutableTreeNode(new RegExpSample("Octal digit", "\\O", -1, "Classes", false)));
        root.add(classes);
        ((DefaultTreeModel)this.treeModel).reload();
        new DefaultTreeExpander((JTree)this.tree).expandAll();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                DefaultMutableTreeNode node;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath treePath = this.getTree().getSelectionPath();
                if (treePath == null) {
                    return false;
                }
                TreePath path2 = treePath;
                TreeNode treeNode = TreePathUtil.toTreeNode((TreePath)path2);
                DefaultMutableTreeNode defaultMutableTreeNode = node = treeNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)treeNode : null;
                Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                RegExpSample regExpSample = object instanceof RegExpSample ? (RegExpSample)object : null;
                if (regExpSample == null) {
                    return false;
                }
                RegExpSample sample = regExpSample;
                this.getDoubleClickConsumer().invoke((Object)sample);
                return true;
            }
        }.installOn((Component)this.tree);
    }

    @NotNull
    public final Function1<RegExpSample, Unit> getDoubleClickConsumer() {
        return this.doubleClickConsumer;
    }

    @NotNull
    public final TreeModel getTreeModel() {
        return this.treeModel;
    }

    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    @NotNull
    public final JComponent getPanel() {
        JBScrollPane jBScrollPane;
        JBScrollPane $this$_get_panel__u24lambda_u240 = jBScrollPane = new JBScrollPane((Component)this.tree);
        boolean bl = false;
        $this$_get_panel__u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        return (JComponent)jBScrollPane;
    }

    private static final String lambda$2$lambda$1(TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        Object object = treePath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)object;
        Object userObject = treeNode.getUserObject();
        return userObject instanceof RegExpSample ? ((RegExpSample)userObject).getName() : userObject.toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpSampleTree$MyTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "mySpeedSearch", "Lcom/intellij/ui/TreeSpeedSearch;", "(Lorg/intellij/lang/regexp/inspection/custom/RegExpSampleTree;Lcom/intellij/ui/TreeSpeedSearch;)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.regexp"})
    private final class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final TreeSpeedSearch mySpeedSearch;

        public MyTreeCellRenderer(TreeSpeedSearch mySpeedSearch) {
            Intrinsics.checkNotNullParameter((Object)mySpeedSearch, (String)"mySpeedSearch");
            this.mySpeedSearch = mySpeedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object object = treeNode.getUserObject();
            if (object == null) {
                return;
            }
            Object userObject = object;
            Color color = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTreeBackground(...)");
            Color background = color;
            Color color2 = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTreeForeground(...)");
            Color foreground = color2;
            String text2 = null;
            int style = 0;
            if (userObject instanceof RegExpSample) {
                text2 = ((RegExpSample)userObject).getName();
                style = 0;
            } else {
                text2 = userObject.toString();
                style = 1;
            }
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)text2, (int)style, (Color)foreground, (Color)background, (SimpleColoredComponent)((SimpleColoredComponent)this));
            if (userObject instanceof RegExpSample) {
                this.append(ColoredText.singleFragment((String)(" " + ((RegExpSample)userObject).getSample()), (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES));
            }
        }
    }
}

