/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseChoice;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Include;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import java.util.List;
import java.util.Vector;

public class SchemaTransformer
implements SchemaVisitor,
ParticleVisitor,
ComplexTypeVisitor,
AttributeUseVisitor,
SimpleTypeVisitor {
    private final Schema schema;

    public SchemaTransformer(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void transform() {
        this.schema.accept(this);
    }

    public void visitGroup(GroupDefinition groupDefinition) {
        groupDefinition.setParticle((Particle)groupDefinition.getParticle().accept(this));
    }

    public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
        attributeGroupDefinition.setAttributeUses((AttributeUse)attributeGroupDefinition.getAttributeUses().accept(this));
    }

    public void visitSimpleType(SimpleTypeDefinition simpleTypeDefinition) {
        simpleTypeDefinition.setSimpleType((SimpleType)simpleTypeDefinition.getSimpleType().accept(this));
    }

    public void visitRoot(RootDeclaration rootDeclaration) {
        rootDeclaration.setParticle((Particle)rootDeclaration.getParticle().accept(this));
    }

    public void visitInclude(Include include) {
        include.getIncludedSchema().accept(this);
    }

    public void visitComment(Comment comment) {
    }

    public Object visitRepeat(ParticleRepeat particleRepeat) {
        Particle particle = (Particle)particleRepeat.getChild().accept(this);
        if (particle == particleRepeat.getChild()) {
            return particleRepeat;
        }
        return new ParticleRepeat(particleRepeat.getLocation(), particleRepeat.getAnnotation(), particle, particleRepeat.getOccurs());
    }

    public Object visitGroupRef(GroupRef groupRef) {
        return groupRef;
    }

    public Object visitElement(Element element) {
        ComplexType complexType = (ComplexType)element.getComplexType().accept(this);
        if (complexType == element.getComplexType()) {
            return element;
        }
        return new Element(element.getLocation(), element.getAnnotation(), element.getName(), complexType);
    }

    public Object visitWildcardElement(WildcardElement wildcardElement) {
        return wildcardElement;
    }

    public Object visitSequence(ParticleSequence particleSequence) {
        List list2 = this.transformParticleList(particleSequence.getChildren());
        if (list2 == particleSequence.getChildren()) {
            return particleSequence;
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        if (list2.size() == 0) {
            return null;
        }
        return new ParticleSequence(particleSequence.getLocation(), particleSequence.getAnnotation(), list2);
    }

    public Object visitChoice(ParticleChoice particleChoice) {
        List list2 = this.transformParticleList(particleChoice.getChildren());
        if (list2 == particleChoice.getChildren()) {
            return particleChoice;
        }
        return new ParticleChoice(particleChoice.getLocation(), particleChoice.getAnnotation(), list2);
    }

    public Object visitAll(ParticleAll particleAll) {
        List list2 = this.transformParticleList(particleAll.getChildren());
        if (list2 == particleAll.getChildren()) {
            return particleAll;
        }
        return new ParticleAll(particleAll.getLocation(), particleAll.getAnnotation(), list2);
    }

    public Object visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
        Particle particle = complexTypeComplexContent.getParticle();
        AttributeUse attributeUse = (AttributeUse)complexTypeComplexContent.getAttributeUses().accept(this);
        if (particle != null) {
            particle = (Particle)particle.accept(this);
        }
        if (particle == complexTypeComplexContent.getParticle() && attributeUse == complexTypeComplexContent.getAttributeUses()) {
            return complexTypeComplexContent;
        }
        return new ComplexTypeComplexContent(attributeUse, particle, complexTypeComplexContent.isMixed());
    }

    public Object visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
        SimpleType simpleType = (SimpleType)complexTypeSimpleContent.getSimpleType().accept(this);
        AttributeUse attributeUse = (AttributeUse)complexTypeSimpleContent.getAttributeUses().accept(this);
        if (simpleType == complexTypeSimpleContent.getSimpleType() && attributeUse == complexTypeSimpleContent.getAttributeUses()) {
            return complexTypeSimpleContent;
        }
        return new ComplexTypeSimpleContent(attributeUse, simpleType);
    }

    public Object visitNotAllowedContent(ComplexTypeNotAllowedContent complexTypeNotAllowedContent) {
        return complexTypeNotAllowedContent;
    }

    public Object visitAttribute(Attribute attribute) {
        SimpleType simpleType = attribute.getType();
        if (simpleType != null && ((simpleType = (SimpleType)simpleType.accept(this)) == null || simpleType != attribute.getType())) {
            return new Attribute(attribute.getLocation(), attribute.getAnnotation(), attribute.getName(), simpleType);
        }
        return attribute;
    }

    public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
        return wildcardAttribute;
    }

    public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        return attributeGroupRef;
    }

    public Object visitOptionalAttribute(OptionalAttribute optionalAttribute) {
        Attribute attribute = (Attribute)optionalAttribute.getAttribute().accept(this);
        if (attribute == optionalAttribute.getAttribute()) {
            return optionalAttribute;
        }
        return new OptionalAttribute(optionalAttribute.getLocation(), optionalAttribute.getAnnotation(), attribute, optionalAttribute.getDefaultValue());
    }

    public Object visitAttributeGroup(AttributeGroup attributeGroup) {
        List list2 = this.transformAttributeUseList(attributeGroup.getChildren());
        if (list2 == attributeGroup.getChildren()) {
            return attributeGroup;
        }
        return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), list2);
    }

    public Object visitAttributeUseChoice(AttributeUseChoice attributeUseChoice) {
        List list2 = this.transformAttributeUseList(attributeUseChoice.getChildren());
        if (list2 == attributeUseChoice.getChildren()) {
            return attributeUseChoice;
        }
        return new AttributeUseChoice(attributeUseChoice.getLocation(), attributeUseChoice.getAnnotation(), list2);
    }

    public Object visitRestriction(SimpleTypeRestriction simpleTypeRestriction) {
        return simpleTypeRestriction;
    }

    public Object visitUnion(SimpleTypeUnion simpleTypeUnion) {
        List list2 = this.transformSimpleTypeList(simpleTypeUnion.getChildren());
        if (list2 == simpleTypeUnion.getChildren()) {
            return simpleTypeUnion;
        }
        return new SimpleTypeUnion(simpleTypeUnion.getLocation(), simpleTypeUnion.getAnnotation(), list2);
    }

    public Object visitList(SimpleTypeList simpleTypeList) {
        SimpleType simpleType = (SimpleType)simpleTypeList.getItemType().accept(this);
        if (simpleType == simpleTypeList.getItemType()) {
            return simpleTypeList;
        }
        return new SimpleTypeList(simpleTypeList.getLocation(), simpleTypeList.getAnnotation(), simpleType, simpleTypeList.getOccurs());
    }

    public Object visitRef(SimpleTypeRef simpleTypeRef) {
        return simpleTypeRef;
    }

    public List transformAttributeUseList(List list2) {
        Vector<Object> vector = null;
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            Object object = ((AttributeUse)list2.get(n)).accept(this);
            if (vector != null) {
                vector.add(object);
            } else if (object != list2.get(n)) {
                vector = new Vector<Object>();
                int n3 = 0;
                while (n3 < n) {
                    vector.add(list2.get(n3));
                    ++n3;
                }
                if (!object.equals(AttributeGroup.EMPTY)) {
                    vector.add(object);
                }
            }
            ++n;
        }
        if (vector == null) {
            return list2;
        }
        return vector;
    }

    public List transformParticleList(List list2) {
        Vector<Object> vector = null;
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            Object object = ((Particle)list2.get(n)).accept(this);
            if (vector != null) {
                if (object != null) {
                    vector.add(object);
                }
            } else if (object != list2.get(n)) {
                vector = new Vector<Object>();
                int n3 = 0;
                while (n3 < n) {
                    vector.add(list2.get(n3));
                    ++n3;
                }
                if (object != null) {
                    vector.add(object);
                }
            }
            ++n;
        }
        if (vector == null) {
            return list2;
        }
        return vector;
    }

    public List transformSimpleTypeList(List list2) {
        Vector<Object> vector = null;
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            Object object = ((SimpleType)list2.get(n)).accept(this);
            if (vector != null) {
                vector.add(object);
            } else if (object != list2.get(n)) {
                vector = new Vector<Object>();
                int n3 = 0;
                while (n3 < n) {
                    vector.add(list2.get(n3));
                    ++n3;
                }
                vector.add(object);
            }
            ++n;
        }
        if (vector == null) {
            return list2;
        }
        return vector;
    }
}

