/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.StringPattern;
import org.relaxng.datatype.Datatype;

class ValuePattern
extends StringPattern {
    private final Object obj;
    private final Datatype dt;

    ValuePattern(Datatype datatype, Object object) {
        super(Pattern.combineHashCode(27, object.hashCode()));
        this.dt = datatype;
        this.obj = object;
    }

    boolean samePattern(Pattern pattern2) {
        if (this.getClass() != pattern2.getClass()) {
            return false;
        }
        if (!(pattern2 instanceof ValuePattern)) {
            return false;
        }
        return this.dt.equals(((ValuePattern)pattern2).dt) && this.dt.sameValue(this.obj, ((ValuePattern)pattern2).obj);
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitValue(this.dt, this.obj);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseValue(this);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_value");
            }
        }
    }

    Datatype getDatatype() {
        return this.dt;
    }

    Object getValue() {
        return this.obj;
    }
}

