/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringValidation
implements JsonSchemaValidation {
    public static final StringValidation INSTANCE = new StringValidation();

    @Override
    public boolean validate(@NotNull JsonValueAdapter propValue, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        if (propValue == null) {
            StringValidation.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            StringValidation.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            StringValidation.$$$reportNull$$$0(2);
        }
        if (options == null) {
            StringValidation.$$$reportNull$$$0(3);
        }
        return StringValidation.checkString(propValue.getDelegate(), schema, consumer, options);
    }

    private static boolean checkString(PsiElement propValue, JsonSchemaObject schema, JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        String v;
        if (options == null) {
            StringValidation.$$$reportNull$$$0(4);
        }
        if ((v = JsonSchemaAnnotatorChecker.getValue(propValue, schema)) == null) {
            return true;
        }
        String value = StringUtil.unquoteString((String)v);
        if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.string.shorter.than", schema.getMinLength()), propValue, JsonErrorPriority.LOW_PRIORITY);
            return false;
        }
        if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.string.longer.than", schema.getMaxLength()), propValue, JsonErrorPriority.LOW_PRIORITY);
            return false;
        }
        if (schema.getPattern() != null) {
            if (schema.getPatternError() != null) {
                consumer.error(JsonBundle.message("schema.validation.invalid.string.pattern", StringUtil.convertLineSeparators((String)schema.getPatternError())), propValue, JsonErrorPriority.LOW_PRIORITY);
                return false;
            }
            if (!schema.checkByPattern(value)) {
                consumer.error(JsonBundle.message("schema.validation.string.violates.pattern", StringUtil.convertLineSeparators((String)schema.getPattern())), propValue, JsonErrorPriority.LOW_PRIORITY);
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/StringValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

