/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Pair;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.Intersect;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.PrimaryKey;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelMergerImpl
implements ModelMerger {
    private final List<Pair<ModelMerger.InvocationStrategy, Class<?>>> myInvocationStrategies = new ArrayList();
    private final List<ModelMerger.MergingStrategy> myMergingStrategies = new ArrayList<ModelMerger.MergingStrategy>();
    private final List<Class<?>> myMergingStrategyClasses = new ArrayList();
    private static final Class<MergedObject> MERGED_OBJECT_CLASS = MergedObject.class;
    private final ConcurrentMap<Method, List<Pair<ModelMerger.InvocationStrategy, Class<?>>>> myAcceptsCache = ConcurrentFactoryMap.createMap(method -> {
        ArrayList result2 = new ArrayList();
        for (int i = this.myInvocationStrategies.size() - 1; i >= 0; --i) {
            Pair<ModelMerger.InvocationStrategy, Class<?>> pair = this.myInvocationStrategies.get(i);
            if (!((ModelMerger.InvocationStrategy)pair.first).accepts((Method)method)) continue;
            result2.add(pair);
        }
        return result2;
    });
    private static final Map<Class<?>, Method> ourPrimaryKeyMethods = new HashMap();

    public ModelMergerImpl() {
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return true;
            }

            @Override
            public Object invokeMethod(JavaMethod javaMethod, Object proxy, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                Method method = javaMethod.getMethod();
                List<Object> results = ModelMergerImpl.this.getMergedImplementations(method, args, method.getReturnType(), implementations, ModelMergerImpl.isIntersectionMethod(javaMethod));
                return results.isEmpty() ? null : results.get(0);
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return Collection.class.isAssignableFrom(method.getReturnType());
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<?> implementations) throws IllegalAccessException, InvocationTargetException {
                Type type2 = DomReflectionUtil.extractCollectionElementType(method.getGenericReturnType());
                assert (type2 != null) : "No generic return type in method " + method;
                return ModelMergerImpl.this.getMergedImplementations(method.getMethod(), args, ClassUtil.getRawType((Type)type2), implementations, ModelMergerImpl.isIntersectionMethod(method));
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return Object.class.equals(method.getDeclaringClass());
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<?> implementations) {
                @NonNls String methodName = method.getName();
                if ("toString".equals(methodName)) {
                    return "Merger: " + implementations;
                }
                if ("hashCode".equals(methodName)) {
                    int result2 = 1;
                    for (Object element : implementations) {
                        result2 = 31 * result2 + element.hashCode();
                    }
                    return result2;
                }
                if ("equals".equals(methodName)) {
                    Object arg = args[0];
                    return arg instanceof MergedObject && implementations.equals(((MergedObject)arg).getImplementations());
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return "isValid".equals(method.getName());
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<?> implementations) {
                for (Object implementation : implementations) {
                    if (((Boolean)method.invoke(implementation, args)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return Void.TYPE.equals(method.getReturnType());
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<?> implementations) {
                for (Object t : implementations) {
                    method.invoke(t, args);
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            @Override
            public boolean accepts(Method method) {
                return MERGED_OBJECT_CLASS.equals(method.getDeclaringClass());
            }

            @Override
            public Object invokeMethod(JavaMethod method, Object proxy, Object[] args, List<?> implementations) {
                assert ("getImplementations".equals(method.getName()));
                return implementations;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            @Override
            public boolean accepts(Method method) {
                return DomInvocationHandler.ACCEPT_METHOD.equals(method);
            }

            @Override
            public Object invokeMethod(JavaMethod method, DomElement proxy, Object[] args, List<? extends DomElement> implementations) {
                DomElementVisitor visitor = (DomElementVisitor)args[0];
                ((DomManagerImpl)implementations.get(0).getManager()).getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, proxy);
                return null;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            @Override
            public boolean accepts(Method method) {
                return DomInvocationHandler.ACCEPT_CHILDREN_METHOD.equals(method);
            }

            @Override
            public Object invokeMethod(JavaMethod method, DomElement proxy, Object[] args, List<? extends DomElement> implementations) {
                DomElementVisitor visitor = (DomElementVisitor)args[0];
                for (AbstractDomChildrenDescription abstractDomChildrenDescription : implementations.get(0).getGenericInfo().getChildrenDescriptions()) {
                    for (DomElement domElement : abstractDomChildrenDescription.getValues(proxy)) {
                        domElement.accept(visitor);
                    }
                }
                return null;
            }
        });
    }

    private static boolean isIntersectionMethod(JavaMethod javaMethod) {
        return javaMethod.getMethod().getAnnotation(Intersect.class) != null;
    }

    @Override
    public <T> void addInvocationStrategy(Class<T> aClass, ModelMerger.InvocationStrategy<T> strategy) {
        this.myInvocationStrategies.add(Pair.create(strategy, aClass));
    }

    @Override
    public <T> void addMergingStrategy(Class<T> aClass, ModelMerger.MergingStrategy<T> strategy) {
        this.myMergingStrategies.add(strategy);
        this.myMergingStrategyClasses.add(aClass);
    }

    @Override
    public <T> T mergeModels(Class<T> aClass, T ... implementations) {
        if (implementations.length == 1) {
            return implementations[0];
        }
        MergingInvocationHandler<T> handler2 = new MergingInvocationHandler<T>(aClass, Arrays.asList(implementations));
        return this._mergeModels(aClass, handler2, implementations);
    }

    @Override
    public <T> T mergeModels(Class<T> aClass, Collection<? extends T> implementations) {
        return (T)this.mergeModels(aClass, implementations.toArray());
    }

    private <T> T _mergeModels(Class<? super T> aClass, MergingInvocationHandler<T> handler2, T ... implementations) {
        Set commonClasses = ModelMergerImpl.getCommonClasses(new HashSet(), implementations);
        commonClasses.add(MERGED_OBJECT_CLASS);
        commonClasses.add(aClass);
        return AdvancedProxy.createProxy(handler2, null, commonClasses.toArray(ArrayUtil.EMPTY_CLASS_ARRAY));
    }

    private static <T extends Collection<Class<?>>> T getCommonClasses(T result2, Object ... implementations) {
        if (implementations.length > 0) {
            DomUtil.getAllInterfaces(implementations[0].getClass(), result2);
            for (int i = 1; i < implementations.length; ++i) {
                ArrayList list1 = new ArrayList();
                DomUtil.getAllInterfaces(implementations[i].getClass(), list1);
                result2.retainAll(list1);
            }
        }
        return result2;
    }

    @Nullable
    private static Object getPrimaryKey(Object implementation, boolean singleValuedInvocation) {
        Method method = ModelMergerImpl.getPrimaryKeyMethod(implementation.getClass());
        if (method != null) {
            Object o = DomReflectionUtil.invokeMethod(method, implementation, new Object[0]);
            return ReflectionUtil.isAssignable(GenericValue.class, method.getReturnType()) ? ((GenericValue)o).getValue() : o;
        }
        if (implementation instanceof GenericValue) {
            return singleValuedInvocation ? Boolean.TRUE : ((GenericValue)implementation).getValue();
        }
        return null;
    }

    @Nullable
    private static Method getPrimaryKeyMethod(Class<?> aClass) {
        Method method = ourPrimaryKeyMethods.get(aClass);
        if (method == null) {
            Method method1;
            if (ourPrimaryKeyMethods.containsKey(aClass)) {
                return null;
            }
            Iterator iterator = ReflectionUtil.getClassPublicMethods(aClass).iterator();
            while (iterator.hasNext() && (method = ModelMergerImpl.findPrimaryKeyAnnotatedMethod(method1 = (Method)iterator.next(), aClass)) == null) {
            }
            ourPrimaryKeyMethods.put(aClass, method);
        }
        return method;
    }

    @Nullable
    private static Method findPrimaryKeyAnnotatedMethod(@NotNull Method sampleMethod, @NotNull Class<?> aClass) {
        if (sampleMethod == null) {
            ModelMergerImpl.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            ModelMergerImpl.$$$reportNull$$$0(1);
        }
        if (sampleMethod.getParameterCount() != 0 || sampleMethod.getReturnType() == Void.TYPE) {
            return null;
        }
        return JavaMethodSignature.findMethod(sampleMethod, aClass, method -> method.isAnnotationPresent(PrimaryKey.class));
    }

    private List<Object> getMergedImplementations(Method method, Object[] args, Class returnType, List<?> implementations, boolean intersect) throws IllegalAccessException, InvocationTargetException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (returnType.isInterface()) {
            SmartList orderedPrimaryKeys = new SmartList();
            Map map = FactoryMap.create(arg_0 -> ModelMergerImpl.lambda$getMergedImplementations$2((List)orderedPrimaryKeys, arg_0));
            Map counts = FactoryMap.create(key2 -> new int[implementations.size()]);
            for (int i = 0; i < implementations.size(); ++i) {
                Object t = implementations.get(i);
                Object o = method.invoke(t, args);
                if (o instanceof Collection) {
                    for (Object o1 : (Collection)o) {
                        ModelMergerImpl.addToMaps(o1, counts, map, i, results, false, intersect);
                    }
                    continue;
                }
                if (o == null) continue;
                ModelMergerImpl.addToMaps(o, counts, map, i, results, true, intersect);
            }
            for (Object primaryKey : orderedPrimaryKeys) {
                for (Set objects : (List)map.get(primaryKey)) {
                    results.add(this.mergeImplementations(returnType, new ArrayList<Object>(objects)));
                }
            }
        } else {
            HashSet<Object> map = new HashSet<Object>();
            for (Object t : implementations) {
                Object o = method.invoke(t, args);
                if (o instanceof Collection) {
                    map.addAll((Collection)o);
                    continue;
                }
                if (o == null) continue;
                map.add(o);
                break;
            }
            results.addAll(map);
        }
        return results;
    }

    private Object mergeImplementations(Class returnType, List<Object> implementations) {
        for (int i = this.myMergingStrategies.size() - 1; i >= 0; --i) {
            Object o;
            if (!ReflectionUtil.isAssignable(this.myMergingStrategyClasses.get(i), (Class)returnType) || (o = this.myMergingStrategies.get(i).mergeChildren(returnType, implementations)) == null) continue;
            return o;
        }
        if (implementations.size() == 1) {
            return implementations.get(0);
        }
        return this.mergeModels((Class)returnType, (Collection)implementations);
    }

    private static boolean addToMaps(Object o, Map<Object, int[]> counts, Map<Object, List<Set<Object>>> map, int index, List<Object> results, boolean singleValuedInvocation, boolean intersect) {
        Object primaryKey = ModelMergerImpl.getPrimaryKey(o, singleValuedInvocation);
        if (primaryKey != null || singleValuedInvocation) {
            int n;
            List<Set<Object>> list2 = map.get(primaryKey);
            int[] indices = counts.get(primaryKey);
            if (intersect) {
                n = indices[index];
            } else {
                int n2 = index;
                int n3 = indices[n2];
                n = n3;
                indices[n2] = n3 + 1;
            }
            int objIndex = n;
            if (list2.size() <= objIndex) {
                list2.add(new LinkedHashSet());
            }
            list2.get(objIndex).add(o);
            return false;
        }
        results.add(o);
        return true;
    }

    private static /* synthetic */ List lambda$getMergedImplementations$2(List orderedPrimaryKeys, Object key2) {
        orderedPrimaryKeys.add(key2);
        return new SmartList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sampleMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/xml/ModelMergerImpl";
        objectArray[2] = "findPrimaryKeyAnnotatedMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class MergingInvocationHandler<T>
    implements InvocationHandler {
        private final Class<? super T> myClass;
        private List<? extends T> myImplementations;

        public MergingInvocationHandler(Class<T> aClass, List<? extends T> implementations) {
            this(aClass);
            for (T implementation : implementations) {
                if (implementation instanceof StableElement) {
                    throw new AssertionError((Object)("Stable values merging is prohibited: " + implementation));
                }
            }
            this.myImplementations = implementations;
        }

        public MergingInvocationHandler(Class<T> aClass) {
            this.myClass = aClass;
        }

        @NotNull
        private ModelMerger.InvocationStrategy findStrategy(Object proxy, Method method) {
            for (Pair pair : (List)ModelMergerImpl.this.myAcceptsCache.get(method)) {
                if (!Object.class.equals(pair.second) && !((Class)pair.second).isInstance(proxy)) continue;
                ModelMerger.InvocationStrategy invocationStrategy = (ModelMerger.InvocationStrategy)pair.first;
                if (invocationStrategy == null) {
                    MergingInvocationHandler.$$$reportNull$$$0(0);
                }
                return invocationStrategy;
            }
            throw new AssertionError((Object)"impossible");
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.findStrategy(proxy, method).invokeMethod(this.getJavaMethod(method), proxy, args, this.myImplementations);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private JavaMethod getJavaMethod(Method method) {
            if (ReflectionUtil.isAssignable(MERGED_OBJECT_CLASS, method.getDeclaringClass())) {
                return JavaMethod.getMethod(MERGED_OBJECT_CLASS, method);
            }
            if (ReflectionUtil.isAssignable(method.getDeclaringClass(), this.myClass)) {
                return JavaMethod.getMethod(this.myClass, method);
            }
            return JavaMethod.getMethod(method.getDeclaringClass(), method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ModelMergerImpl$MergingInvocationHandler", "findStrategy"));
        }
    }
}

