/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.filters.TagValueFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.XmlMatchingStrategy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class XmlCompilingVisitor
extends XmlRecursiveElementVisitor {
    @NotNull
    private final GlobalCompilingVisitor myCompilingVisitor;
    private final XmlWordOptimizer myOptimizer;

    public XmlCompilingVisitor(@NotNull GlobalCompilingVisitor compilingVisitor) {
        if (compilingVisitor == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(0);
        }
        this.myOptimizer = new XmlWordOptimizer();
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement @NotNull [] topLevelElements) {
        CompileContext context;
        CompiledPattern pattern2;
        if (topLevelElements == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(1);
        }
        if ((pattern2 = (context = this.myCompilingVisitor.getContext()).getPattern()).getStrategy() == null) {
            MatchOptions options = context.getOptions();
            pattern2.setStrategy(new XmlMatchingStrategy(options.getDialect()));
        }
        for (PsiElement element : topLevelElements) {
            element.accept((PsiElementVisitor)this);
            this.optimize(element);
            pattern2.setHandler(element, new TopLevelMatchingHandler(pattern2.getHandler(element)));
        }
    }

    public void optimize(@NotNull PsiElement element) {
        if (element == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(2);
        }
        element.accept((PsiElementVisitor)this.myOptimizer);
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(3);
        }
        if (!(element.getLanguage() instanceof XMLLanguage) && StructuralSearchUtil.compileForeignElement(element, this.myCompilingVisitor)) {
            return;
        }
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    @Override
    public void visitXmlToken(@NotNull XmlToken token) {
        IElementType tokenType;
        if (token == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(4);
        }
        if ((tokenType = token.getTokenType()) != XmlTokenType.XML_NAME && tokenType != XmlTokenType.XML_TAG_NAME && tokenType != XmlTokenType.XML_COMMENT_CHARACTERS && tokenType != XmlTokenType.XML_DATA_CHARACTERS) {
            return;
        }
        super.visitXmlToken(token);
        if (tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
            this.myCompilingVisitor.setFilterSimple(token, TagValueFilter.getInstance());
        }
    }

    @Override
    public void visitXmlText(@NotNull XmlText text2) {
        if (text2 == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(5);
        }
        super.visitXmlText(text2);
        if (this.myCompilingVisitor.getContext().getPattern().isRealTypedVar(text2)) {
            this.myCompilingVisitor.setFilterSimple(text2, TagValueFilter.getInstance());
        }
    }

    @Override
    public void visitXmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(6);
        }
        super.visitXmlTag(tag);
        this.myCompilingVisitor.setFilterSimple(tag, element -> element instanceof XmlTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilingVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/XmlCompilingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "optimize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlToken";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class XmlWordOptimizer
    extends XmlRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private XmlWordOptimizer() {
        }

        @Override
        public void visitXmlTag(@NotNull XmlTag tag) {
            if (tag == null) {
                XmlWordOptimizer.$$$reportNull$$$0(0);
            }
            if (!this.handleWord(tag.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitXmlTag(tag);
        }

        @Override
        public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
            if (attribute == null) {
                XmlWordOptimizer.$$$reportNull$$$0(1);
            }
            if (!this.handleWord(attribute.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            this.handleWord(attribute.getValue(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            super.visitXmlAttribute(attribute);
        }

        @Override
        public void visitXmlToken(@NotNull XmlToken token) {
            if (token == null) {
                XmlWordOptimizer.$$$reportNull$$$0(2);
            }
            super.visitXmlToken(token);
            IElementType tokenType = token.getTokenType();
            if (tokenType == XmlTokenType.XML_COMMENT_CHARACTERS || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
                this.handleWord(token.getText(), GlobalCompilingVisitor.OccurenceKind.TEXT, XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/XmlCompilingVisitor$XmlWordOptimizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlTag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlAttribute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlToken";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

