/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.filters.CompositeNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalCompilingVisitor {
    @NonNls
    private static final String SUBSTITUTION_PATTERN_STR = "\\b(__\\$_\\w+)\\b";
    private static final Pattern ourSubstitutionPattern = Pattern.compile("\\b(__\\$_\\w+)\\b");
    private static final NodeFilter ourFilter = LexicalNodesFilter.getInstance();
    private CompileContext context;
    private final List<PsiElement> myLexicalNodes = new SmartList();
    private int myCodeBlockLevel;

    @NotNull
    public static NodeFilter getFilter() {
        NodeFilter nodeFilter = ourFilter;
        if (nodeFilter == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(0);
        }
        return nodeFilter;
    }

    public void setHandler(@NotNull PsiElement element, @NotNull MatchingHandler handler2) {
        MatchingHandler realHandler;
        if (element == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(2);
        }
        if ((realHandler = this.context.getPattern().getHandlerSimple(element)) instanceof SubstitutionHandler) {
            ((SubstitutionHandler)realHandler).setMatchHandler(handler2);
        } else {
            this.context.getPattern().setHandler(element, handler2);
        }
    }

    public final void handle(@NotNull PsiElement element) {
        if (element == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(3);
        }
        if ((!ourFilter.accepts(element) || StructuralSearchUtil.isIdentifier(element)) && this.context.getPattern().isRealTypedVar(element) && this.context.getPattern().getHandlerSimple(element) == null) {
            String name;
            CompiledPattern pattern2 = this.context.getPattern();
            SubstitutionHandler handler2 = (SubstitutionHandler)pattern2.getHandler(name = pattern2.getTypedVarString(element));
            if (handler2 == null) {
                return;
            }
            pattern2.setHandler(element, handler2);
            if (this.context.getOptions().getVariableConstraint(handler2.getName()).isPartOfSearchResults()) {
                handler2.setTarget(true);
                PsiElement targetNode = pattern2.getTargetNode();
                if (targetNode == null || targetNode == element.getParent()) {
                    pattern2.setTargetNode(element);
                }
            }
        }
    }

    public CompileContext getContext() {
        return this.context;
    }

    public int getCodeBlockLevel() {
        return this.myCodeBlockLevel;
    }

    public void setCodeBlockLevel(int codeBlockLevel) {
        this.myCodeBlockLevel = codeBlockLevel;
    }

    public static void setFilter(@NotNull MatchingHandler handler2, @NotNull NodeFilter filter2) {
        if (handler2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(4);
        }
        if (filter2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(5);
        }
        if (handler2.getFilter() != null && handler2.getFilter().getClass() != filter2.getClass()) {
            handler2.setFilter(new CompositeNodeFilter(filter2, handler2.getFilter()));
        } else {
            handler2.setFilter(filter2);
        }
    }

    public void setFilterSimple(@NotNull PsiElement element, @NotNull NodeFilter filter2) {
        if (element == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(6);
        }
        if (filter2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(7);
        }
        this.context.getPattern().getHandler(element).setFilter(filter2);
    }

    @NotNull
    public List<PsiElement> getLexicalNodes() {
        List<PsiElement> list2 = this.myLexicalNodes;
        if (list2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void addLexicalNode(@NotNull PsiElement node) {
        if (node == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(9);
        }
        this.myLexicalNodes.add(node);
    }

    void compile(PsiElement @NotNull [] elements, @NotNull CompileContext context) {
        if (context == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(11);
        }
        if (elements.length == 0) {
            throw new MalformedPatternException();
        }
        this.myCodeBlockLevel = 0;
        this.context = context;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType());
        assert (profile != null);
        profile.compile(elements, this);
        assert (context.getPattern().getStrategy() != null);
    }

    public boolean hasFragments(@NotNull String pattern2) {
        if (pattern2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(12);
        }
        return ourSubstitutionPattern.matcher(pattern2).find();
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(@NotNull String pattern2, @NotNull OccurenceKind kind) {
        if (pattern2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(14);
        }
        return this.processPatternStringWithFragments(pattern2, kind, ourSubstitutionPattern);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(@NotNull String pattern2, @NotNull OccurenceKind kind, @NotNull Pattern substitutionPattern) {
        String word;
        String content;
        if (pattern2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(16);
        }
        if (substitutionPattern == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(17);
        }
        if (kind == OccurenceKind.LITERAL) {
            content = pattern2.substring(1, pattern2.length() - 1);
        } else if (kind == OccurenceKind.COMMENT || kind == OccurenceKind.TEXT) {
            content = pattern2;
        } else {
            assert (false);
            return null;
        }
        @NonNls StringBuilder buf = new StringBuilder(content.length());
        Matcher matcher = substitutionPattern.matcher(content);
        SmartList handlers = new SmartList();
        int start2 = 0;
        boolean hasLiteralContent = false;
        MatchingHandler handler2 = null;
        while (matcher.find()) {
            word = content.substring(start2, matcher.start());
            if (!word.isEmpty()) {
                hasLiteralContent = true;
                buf.append(MatchUtil.makeExtremeSpacesOptional(MatchUtil.shieldRegExpMetaChars(word)));
                this.processTokenizedName(word, kind);
            }
            if ((handler2 = (SubstitutionHandler)this.getContext().getPattern().getHandler(matcher.group(1))) == null) {
                throw new MalformedPatternException();
            }
            handlers.add(handler2);
            RegExpPredicate predicate = ((SubstitutionHandler)handler2).findPredicate(RegExpPredicate.class);
            if (predicate == null || !predicate.isWholeWords()) {
                buf.append("(.*?)");
            } else {
                buf.append(".*?\\b(").append(predicate.getRegExp()).append(")\\b.*?");
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(predicate, (SubstitutionHandler)handler2)) {
                this.processTokenizedName(predicate.getRegExp(), kind);
            }
            start2 = matcher.end();
        }
        word = content.substring(start2);
        if (!word.isEmpty()) {
            hasLiteralContent = true;
            buf.append(MatchUtil.makeExtremeSpacesOptional(MatchUtil.shieldRegExpMetaChars(word)));
            this.processTokenizedName(word, kind);
        }
        if (hasLiteralContent && kind == OccurenceKind.LITERAL) {
            buf.insert(0, "[\"']");
            buf.append("[\"']");
        }
        if (!handlers.isEmpty()) {
            return hasLiteralContent ? new LiteralWithSubstitutionHandler(buf.toString(), (List<? extends SubstitutionHandler>)handlers, this.context.getOptions().isCaseSensitiveMatch()) : handler2;
        }
        return null;
    }

    @Contract(value="null,_ -> false")
    public static boolean isSuitablePredicate(RegExpPredicate predicate, @NotNull SubstitutionHandler handler2) {
        if (handler2 == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(18);
        }
        return predicate != null && handler2.getMinOccurs() != 0 && predicate.couldBeOptimized();
    }

    public static void addFilesToSearchForGivenWord(@NotNull String word, boolean endTransaction, @NotNull OccurenceKind kind, @NotNull CompileContext compileContext) {
        if (word == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(20);
        }
        if (compileContext == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(21);
        }
        if (!compileContext.getSearchHelper().doOptimizing()) {
            return;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(compileContext.getOptions().getFileType());
        assert (profile != null);
        if (profile.getReservedWords().contains(word)) {
            return;
        }
        if (kind == OccurenceKind.CODE) {
            compileContext.getSearchHelper().addWordToSearchInCode(word);
        } else if (kind == OccurenceKind.COMMENT) {
            compileContext.getSearchHelper().addWordToSearchInComments(word);
        } else if (kind == OccurenceKind.LITERAL) {
            compileContext.getSearchHelper().addWordToSearchInLiterals(word);
        } else if (kind == OccurenceKind.TEXT) {
            compileContext.getSearchHelper().addWordToSearchInText(word);
        }
        if (endTransaction) {
            compileContext.getSearchHelper().endTransaction();
        }
    }

    public void processTokenizedName(@NotNull String name, @NotNull OccurenceKind kind) {
        if (name == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(22);
        }
        if (kind == null) {
            GlobalCompilingVisitor.$$$reportNull$$$0(23);
        }
        if (kind == OccurenceKind.LITERAL) {
            name = StringUtil.unescapeStringCharacters((String)name);
        }
        for (String word : StringUtil.getWordsInStringLongestFirst((String)name)) {
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(word, true, kind, this.getContext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/GlobalCompilingVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionPattern";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/GlobalCompilingVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFilterSimple";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLexicalNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasFragments";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processPatternStringWithFragments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSuitablePredicate";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToSearchForGivenWord";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processTokenizedName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> new IllegalArgumentException(string2);
        };
    }

    public static enum OccurenceKind {
        LITERAL,
        COMMENT,
        CODE,
        TEXT;

    }
}

