/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.inspectopedia.extractor.utils;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;

public final class HtmlUtils {
    private static final Safelist SAFELIST = new Safelist();
    private static final List<Pair<String, String>> RENAME_MAP;
    private static final List<String> REMOVE_MAP;
    private static final List<String> UNWRAP_MAP;

    @NotNull
    public static String cleanupHtml(@NotNull String source2, @Nullable String languageForCodeBlocks) {
        Elements paragraphsWithParagraphs;
        if (source2 == null) {
            HtmlUtils.$$$reportNull$$$0(0);
        }
        Document document2 = Jsoup.parse((String)source2);
        RENAME_MAP.forEach(map -> document2.select((String)map.first).tagName((String)map.second));
        Elements ol = document2.select("ol");
        ol.tagName("list");
        ol.attr("style", "decimal");
        UNWRAP_MAP.forEach(map -> document2.select(map).unwrap());
        Elements codeBlock = document2.select("pre > code");
        codeBlock.attr("style", "block");
        codeBlock.attr("lang", languageForCodeBlocks == null ? "Text" : languageForCodeBlocks);
        document2.select("code > *").stream().filter(element -> !element.tagName().equals("a")).forEach(Node::unwrap);
        document2.select("br").stream().map(Element::parent).distinct().forEach(parent -> {
            ArrayList<Pair> groups = new ArrayList<Pair>();
            ArrayList<Node> inlineElements = new ArrayList<Node>();
            Iterator childNodes = parent.childNodes().iterator();
            while (childNodes.hasNext()) {
                Node childNode = (Node)childNodes.next();
                if (!HtmlUtils.isBlockElement(childNode)) {
                    inlineElements.add(childNode);
                }
                if (!(!HtmlUtils.isBlockElement(childNode) && childNodes.hasNext() || inlineElements.isEmpty())) {
                    groups.add(Pair.create((Object)true, List.copyOf(inlineElements)));
                    inlineElements.clear();
                }
                if (!HtmlUtils.isBlockElement(childNode) || HtmlUtils.isBr(childNode)) continue;
                groups.add(Pair.create((Object)false, List.of(childNode)));
            }
            for (Pair group : groups) {
                Boolean shouldWrap = (Boolean)group.getFirst();
                List nodes = (List)group.getSecond();
                Element elementForNodes = shouldWrap != false ? document2.createElement("p") : parent;
                nodes.forEach(n -> {
                    n.remove();
                    elementForNodes.appendChild(n);
                });
                if (!shouldWrap.booleanValue()) continue;
                parent.appendChild((Node)elementForNodes);
            }
        });
        REMOVE_MAP.forEach(map -> document2.select(map).remove());
        do {
            paragraphsWithParagraphs = document2.select("p:has(p)");
            paragraphsWithParagraphs.unwrap();
        } while (!paragraphsWithParagraphs.isEmpty());
        Elements emptyParagraphs = document2.select("p:matches(^\\s*$)");
        emptyParagraphs.remove();
        Cleaner cleaner = new Cleaner(SAFELIST);
        cleaner.clean(document2);
        document2.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        document2.outputSettings().prettyPrint(false);
        String string2 = document2.body().html();
        if (string2 == null) {
            HtmlUtils.$$$reportNull$$$0(1);
        }
        return string2;
    }

    private static boolean isBlockElement(@NotNull Node node) {
        if (node == null) {
            HtmlUtils.$$$reportNull$$$0(2);
        }
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        return "list".equals(element.tagName()) || "code".equals(element.tagName()) && "block".equals(element.attr("style")) || HtmlUtils.isBr(node);
    }

    private static boolean isBr(@NotNull Node node) {
        Element element;
        if (node == null) {
            HtmlUtils.$$$reportNull$$$0(3);
        }
        return node instanceof Element && "br".equals((element = (Element)node).tagName());
    }

    static {
        SAFELIST.addTags(new String[]{"a", "b", "code", "i", "li", "list", "p", "s", "u"});
        RENAME_MAP = List.of(Pair.create((Object)"ul", (Object)"list"), Pair.create((Object)"th", (Object)"td"), Pair.create((Object)"c", (Object)"code"), Pair.create((Object)"strong", (Object)"b"), Pair.create((Object)"small", (Object)"font"), Pair.create((Object)"span", (Object)"control"), Pair.create((Object)"blockquote", (Object)"tip"), Pair.create((Object)"em", (Object)"i"));
        REMOVE_MAP = List.of("hr", "br", "code:matches(^\\s*$)");
        UNWRAP_MAP = List.of("tbody", "pre", "code[style=block] > *");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/inspectopedia/extractor/utils/HtmlUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/inspectopedia/extractor/utils/HtmlUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanupHtml";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBlockElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBr";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

