/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlDefaultAttributeValueInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlDefaultAttributeValueInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            @Override
            public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
                PsiElement parent;
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parent = value.getParent()) instanceof XmlAttribute)) {
                    return;
                }
                if (parent.getParent() instanceof HtmlTag || HtmlUtil.isHtmlFile(parent.getParent())) {
                    return;
                }
                XmlAttributeDescriptor descriptor = ((XmlAttribute)parent).getDescriptor();
                if (descriptor == null || descriptor.isRequired()) {
                    return;
                }
                String defaultValue2 = descriptor.getDefaultValue();
                if (defaultValue2 != null && defaultValue2.equals(value.getValue()) && !value.getTextRange().isEmpty()) {
                    holder.registerProblem((PsiElement)value, XmlAnalysisBundle.message("xml.inspections.redundant.default.attribute.value.assignment", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveAttributeIntentionFix(((XmlAttribute)parent).getLocalName())});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1", "visitXmlAttributeValue"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection", "buildVisitor"));
    }
}

