/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.junit5.TestDisposable;
import com.intellij.testFramework.junit5.impl.TestDisposableExtensionKt;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/junit5/impl/TestDisposableExtension;", "Lorg/junit/jupiter/api/extension/BeforeEachCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "Lorg/junit/jupiter/api/extension/ParameterResolver;", "()V", "afterEach", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "beforeEach", "resolveParameter", "", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "supportsParameter", "", "intellij.platform.testFramework.junit5"})
@TestOnly
public final class TestDisposableExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(@NotNull ExtensionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object instance2 = context2.getRequiredTestInstance();
        for (Field field : AnnotationUtils.findAnnotatedFields(instance2.getClass(), TestDisposable.class, ReflectionUtils::isNotStatic)) {
            ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(instance2, TestDisposableExtensionKt.access$testDisposable(context2));
        }
    }

    public void afterEach(@NotNull ExtensionContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            CheckedDisposable checkedDisposable = TestDisposableExtensionKt.access$testDisposableIfRequested(context2);
            if (checkedDisposable == null) break block0;
            CheckedDisposable disposable = checkedDisposable;
            boolean bl = false;
            Assertions.assertFalse((boolean)disposable.isDisposed());
            Disposer.dispose((Disposable)((Disposable)disposable));
        }
    }

    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        return parameterContext.getParameter().getType() == Disposable.class && parameterContext.isAnnotated(TestDisposable.class);
    }

    @NotNull
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        return TestDisposableExtensionKt.access$testDisposable(extensionContext);
    }
}

