/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.LightMultiFileTestCase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.util.ThrowableRunnable;

public abstract class MoveFileTestCase
extends LightMultiFileTestCase {
    protected void doTest(String targetDirName, String fileToMove) {
        this.doTest((ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
            VirtualFile child = this.myFixture.findFileInTempDir(fileToMove);
            MoveFileTestCase.assertNotNull((String)("File " + fileToMove + " not found"), (Object)child);
            PsiFile file2 = this.getPsiManager().findFile(child);
            MoveFileTestCase.assertNotNull((Object)file2);
            VirtualFile child1 = this.myFixture.findFileInTempDir(targetDirName);
            MoveFileTestCase.assertNotNull((String)("File " + targetDirName + " not found"), (Object)child1);
            PsiDirectory targetDirectory = this.getPsiManager().findDirectory(child1);
            MoveFileTestCase.assertNotNull((Object)targetDirectory);
            new MoveFilesOrDirectoriesProcessor(this.getProject(), new PsiElement[]{file2}, targetDirectory, false, false, null, null).run();
            int index = fileToMove.lastIndexOf("/");
            PsiFile psiFile = targetDirectory.findFile(index == -1 ? fileToMove : fileToMove.substring(index + 1));
            MoveFileTestCase.assertNotNull((Object)psiFile);
        }));
    }
}

