/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectWizardTestCase<T extends AbstractProjectWizard>
extends HeavyPlatformTestCase {
    protected static final String DEFAULT_SDK = "default";
    protected T myWizard;
    @Nullable
    private Project myCreatedProject;
    private Sdk myOldDefaultProjectSdk;
    private File contentRoot;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.contentRoot = this.createTempDirectoryWithSuffix("new").toFile();
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        this.myOldDefaultProjectSdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectSdk == jdk) continue;
            ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(jdk));
        }
        ProjectTypeStep.resetGroupForTests();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.setWizard(null);
            if (this.myCreatedProject != null) {
                PlatformTestUtil.forceCloseProjectWithoutSaving(this.myCreatedProject);
                this.myCreatedProject = null;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    LanguageLevelProjectExtensionImpl extension = LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectManager.getInstance().getDefaultProject());
                    extension.resetDefaults();
                    ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setProjectSdk(this.myOldDefaultProjectSdk);
                    JavaAwareProjectJdkTableImpl.removeInternalJdkInTests();
                });
                SelectTemplateSettings.getInstance().setLastTemplate(null, null);
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            });
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    super.tearDown();
                }
                catch (Exception e) {
                    this.addSuppressedException(e);
                }
            });
        }
    }

    void setWizard(@Nullable T wizard) {
        if (this.myWizard != null) {
            Disposer.dispose((Disposable)this.myWizard.getDisposable());
        }
        this.myWizard = wizard;
    }

    private Project createProjectFromWizard() {
        try {
            this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard);
        }
        catch (Throwable e) {
            this.myCreatedProject = (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project2 -> this.myWizard.getProjectName().equals(project2.getName()));
            throw new RuntimeException(e);
        }
        ProjectWizardTestCase.assertNotNull((Object)this.myCreatedProject);
        UIUtil.dispatchAllInvocationEvents();
        IndexingTestUtil.waitUntilIndexesAreReady(this.myCreatedProject);
        return this.myCreatedProject;
    }

    protected Project getCreatedProject() {
        return this.myCreatedProject;
    }

    private Module createModuleFromWizard(@NotNull Project project2) {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(0);
        }
        return new NewModuleAction().createModuleFromWizard(project2, null, this.myWizard);
    }

    private static void setSelectedTemplate(@NotNull Step step, @NotNull String group, @Nullable String name) {
        ProjectTypeStep projectTypeStep;
        if (step == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(1);
        }
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(2);
        }
        if (!(projectTypeStep = ProjectWizardTestCase.assertInstanceOf(step, ProjectTypeStep.class)).setSelectedTemplate(group, name)) {
            throw new IllegalArgumentException(group + "/" + name + " template not found. Available groups: " + projectTypeStep.availableTemplateGroupsToString());
        }
    }

    private static void adjustSelectedStep(@NotNull Step step, @NotNull Consumer<? super NewProjectWizardStep> adjuster) {
        if (step == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(3);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(4);
        }
        ProjectTypeStep projectTypeStep = ProjectWizardTestCase.assertInstanceOf(step, ProjectTypeStep.class);
        ModuleWizardStep moduleWizardStep = projectTypeStep.getCustomStep();
        ProjectWizardTestCase.assertInstanceOf(moduleWizardStep, NewProjectWizardStep.class);
        NewProjectWizardStep npwStep = (NewProjectWizardStep)moduleWizardStep;
        adjuster.accept((NewProjectWizardStep)npwStep);
    }

    protected void cancelWizardRun() {
        throw new CancelWizardException();
    }

    private void runWizard(@Nullable Consumer<? super Step> adjuster) {
        block5: {
            ModuleWizardStep currentStep;
            do {
                currentStep = (ModuleWizardStep)this.myWizard.getCurrentStepObject();
                if (adjuster != null) {
                    try {
                        adjuster.accept((Step)currentStep);
                    }
                    catch (CancelWizardException e) {
                        this.myWizard.doCancelAction();
                        return;
                    }
                }
                if (this.myWizard.isLast()) break block5;
                this.myWizard.doNextAction();
            } while (currentStep != this.myWizard.getCurrentStepObject());
            throw new RuntimeException(currentStep + " is not validated");
        }
        if (!this.myWizard.doFinishAction()) {
            throw new RuntimeException(this.myWizard.getCurrentStepObject() + " is not validated");
        }
    }

    protected void createWizard(@Nullable Project project2) throws IOException {
        this.setWizard(this.createWizard(project2, this.contentRoot));
        UIUtil.dispatchAllInvocationEvents();
    }

    protected Project createProject(Consumer<? super Step> adjuster) throws IOException {
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myWizard.disposeIfNeeded();
        return this.createProjectFromWizard();
    }

    protected Project createProjectFromTemplate(@NotNull String group, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(5);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(6);
        }
        return this.createProject(step -> {
            ProjectWizardTestCase.setSelectedTemplate(step, group, null);
            ProjectWizardTestCase.adjustSelectedStep(step, adjuster);
        });
    }

    protected Module createModule(@NotNull Project project2, @NotNull Consumer<? super Step> adjuster) throws IOException {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(7);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(8);
        }
        this.createWizard(project2);
        this.runWizard(adjuster);
        this.myWizard.disposeIfNeeded();
        return this.createModuleFromWizard(project2);
    }

    protected Module createModuleFromTemplate(@NotNull Project project2, @NotNull String group, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(9);
        }
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(10);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(11);
        }
        return this.createModule(project2, step -> {
            ProjectWizardTestCase.setSelectedTemplate(step, group, null);
            ProjectWizardTestCase.adjustSelectedStep(step, adjuster);
        });
    }

    protected File getContentRoot() {
        return this.contentRoot;
    }

    protected T createWizard(Project project2, File directory) {
        throw new RuntimeException();
    }

    protected void configureJdk() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.addSdk(new SimpleJavaSdkType().createJdk(DEFAULT_SDK, SystemProperties.getJavaHome()));
            this.addSdk(new SimpleJavaSdkType().createJdk("_other", SystemProperties.getJavaHome()));
            LOG.debug("ProjectWizardTestCase.configureJdk:");
            LOG.debug(String.valueOf(Arrays.asList(ProjectJdkTable.getInstance().getAllJdks())));
        });
    }

    protected void addSdk(Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
    }

    protected Module importModuleFrom(ProjectImportProvider provider, String path) {
        return this.importFrom(path, this.getProject(), null, provider);
    }

    protected Module importProjectFrom(String path, Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        Module module2 = this.importFrom(path, null, adjuster, providers);
        if (module2 != null) {
            this.myCreatedProject = module2.getProject();
        }
        return module2;
    }

    private Module importFrom(String path, @Nullable Project project2, Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        return ProjectWizardTestCase.computeInWriteSafeContext(() -> this.doImportModule(path, project2, adjuster, providers));
    }

    private Module doImportModule(String path, @Nullable Project project2, Consumer<? super Step> adjuster, ProjectImportProvider[] providers) {
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        ProjectWizardTestCase.assertNotNull((String)("Can't find " + path), (Object)file2);
        ProjectWizardTestCase.assertTrue((boolean)providers[0].canImport(file2, project2));
        this.setWizard(ImportModuleAction.createImportWizard((Project)project2, null, (VirtualFile)file2, (ProjectImportProvider[])providers));
        ProjectWizardTestCase.assertNotNull(this.myWizard);
        if (this.myWizard.getStepCount() > 0) {
            this.runWizard(adjuster);
        }
        return (Module)ContainerUtil.getFirstItem((List)ImportModuleAction.createFromWizard((Project)project2, this.myWizard));
    }

    private static <T> T computeInWriteSafeContext(Supplier<? extends T> supplier) {
        Ref module2 = Ref.create();
        ApplicationManager.getApplication().invokeLater(() -> module2.set(supplier.get()));
        UIUtil.dispatchAllInvocationEvents();
        return (T)module2.get();
    }

    protected Sdk createSdk(String name, SdkTypeId sdkType) {
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, sdkType);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
        return sdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjuster";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectWizard/ProjectWizardTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromWizard";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedTemplate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustSelectedStep";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createProjectFromTemplate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createModule";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CancelWizardException
    extends RuntimeException {
        private CancelWizardException() {
        }
    }
}

