/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.util.RevisionCollector;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\b2\f\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0002J\b\u0010%\u001a\u00020\u001fH\u0002J \u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000$\u0012\u0004\u0012\u00020\u00180'2\u0006\u0010(\u001a\u00020)R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lcom/intellij/vcs/log/util/RevisionCollectorTask;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "collector", "Lcom/intellij/vcs/log/util/RevisionCollector;", "mainIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "fastTaskIndicator", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/util/RevisionCollector;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "_revisions", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getCollector", "()Lcom/intellij/vcs/log/util/RevisionCollector;", "exception", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/vcs/VcsException;", "fastFuture", "Ljava/util/concurrent/Future;", "firstRevisionCollected", "Ljava/util/concurrent/atomic/AtomicBoolean;", "future", "isCancelled", "", "()Z", "lastSnapshotSize", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "cancel", "", "wait", "indicator", "taskFuture", "getRevisionsSnapshot", "", "throwOnError", "waitForRevisions", "Lkotlin/Pair;", "intervalMs", "", "intellij.platform.vcs.log.impl"})
public final class RevisionCollectorTask<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final RevisionCollector<T> collector;
    @NotNull
    private final ProgressIndicator mainIndicator;
    @Nullable
    private final ProgressIndicator fastTaskIndicator;
    @NotNull
    private final Future<?> future;
    @Nullable
    private final Future<?> fastFuture;
    @NotNull
    private final ConcurrentLinkedQueue<T> _revisions;
    @NotNull
    private final AtomicReference<VcsException> exception;
    @NotNull
    private final AtomicBoolean firstRevisionCollected;
    private volatile int lastSnapshotSize;

    public RevisionCollectorTask(@NotNull Project project, @NotNull RevisionCollector<T> collector, @NotNull ProgressIndicator mainIndicator, @Nullable ProgressIndicator fastTaskIndicator) {
        Future<?> future2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)mainIndicator, (String)"mainIndicator");
        this.project = project;
        this.collector = collector;
        this.mainIndicator = mainIndicator;
        this.fastTaskIndicator = fastTaskIndicator;
        this._revisions = new ConcurrentLinkedQueue();
        this.exception = new AtomicReference();
        this.firstRevisionCollected = new AtomicBoolean(false);
        Future<?> future3 = AppExecutorUtil.getAppExecutorService().submit(() -> RevisionCollectorTask._init_$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue(future3, (String)"submit(...)");
        this.future = future3;
        RevisionCollectorTask revisionCollectorTask = this;
        ProgressIndicator progressIndicator = this.fastTaskIndicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2 = progressIndicator;
            RevisionCollectorTask revisionCollectorTask2 = revisionCollectorTask;
            boolean bl = false;
            future2 = AppExecutorUtil.getAppExecutorService().submit(() -> RevisionCollectorTask.lambda$4$lambda$3(this));
            revisionCollectorTask = revisionCollectorTask2;
        } else {
            future2 = null;
        }
        revisionCollectorTask.fastFuture = future2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RevisionCollector<T> getCollector() {
        return this.collector;
    }

    public final boolean isCancelled() {
        return this.mainIndicator.isCanceled();
    }

    @NotNull
    public final Pair<List<T>, Boolean> waitForRevisions(long intervalMs) throws VcsException {
        this.throwOnError();
        while (this._revisions.size() == this.lastSnapshotSize) {
            try {
                this.future.get(intervalMs, TimeUnit.MILLISECONDS);
                ProgressManager.checkCanceled();
                this.throwOnError();
                return new Pair(this.getRevisionsSnapshot(), (Object)true);
            }
            catch (TimeoutException timeoutException) {
                ProgressManager.checkCanceled();
            }
        }
        return new Pair(this.getRevisionsSnapshot(), (Object)false);
    }

    private final List<T> getRevisionsSnapshot() {
        List list = CollectionsKt.toList((Iterable)this._revisions);
        this.lastSnapshotSize = list.size();
        return list;
    }

    private final void throwOnError() throws VcsException {
        if (this.exception.get() != null) {
            throw new VcsException((Throwable)this.exception.get());
        }
    }

    public final void cancel(boolean wait) {
        this.cancel(wait, this.mainIndicator, this.future);
        this.cancel(wait, this.fastTaskIndicator, this.fastFuture);
    }

    private final void cancel(boolean wait, ProgressIndicator indicator, Future<?> taskFuture) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        if (wait && taskFuture != null) {
            try {
                taskFuture.get(20L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final void lambda$1$lambda$0(RevisionCollectorTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.collector.collectRevisions((Function1)new Function1<T, Unit>(this$0){
                final /* synthetic */ RevisionCollectorTask<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(T it) {
                    AtomicBoolean atomicBoolean = RevisionCollectorTask.access$getFirstRevisionCollected$p(this.this$0);
                    RevisionCollectorTask<T> revisionCollectorTask = this.this$0;
                    AtomicBoolean atomicBoolean2 = atomicBoolean;
                    synchronized (atomicBoolean2) {
                        boolean bl = false;
                        if (!RevisionCollectorTask.access$getFirstRevisionCollected$p(revisionCollectorTask).getAndSet(true)) {
                            RevisionCollectorTask.access$get_revisions$p(revisionCollectorTask).clear();
                        }
                        RevisionCollectorTask.access$get_revisions$p(revisionCollectorTask).add(it);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            });
        }
        catch (VcsException e) {
            this$0.exception.set(e);
        }
    }

    private static final void _init_$lambda$1(RevisionCollectorTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProgressManager.getInstance().runProcess(() -> RevisionCollectorTask.lambda$1$lambda$0(this$0), this$0.mainIndicator);
    }

    private static final void lambda$4$lambda$3$lambda$2(RevisionCollectorTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.collector.collectRevisionsFast((Function1)new Function1<T, Unit>(this$0){
                final /* synthetic */ RevisionCollectorTask<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(T it) {
                    AtomicBoolean atomicBoolean = RevisionCollectorTask.access$getFirstRevisionCollected$p(this.this$0);
                    RevisionCollectorTask<T> revisionCollectorTask = this.this$0;
                    AtomicBoolean atomicBoolean2 = atomicBoolean;
                    synchronized (atomicBoolean2) {
                        boolean bl = false;
                        if (RevisionCollectorTask.access$getFirstRevisionCollected$p(revisionCollectorTask).get()) {
                            RevisionCollectorTask.access$getFastTaskIndicator$p(revisionCollectorTask).cancel();
                            return;
                        }
                        RevisionCollectorTask.access$get_revisions$p(revisionCollectorTask).add(it);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            });
        }
        catch (VcsException e) {
            this$0.exception.set(e);
        }
    }

    private static final void lambda$4$lambda$3(RevisionCollectorTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProgressManager.getInstance().executeProcessUnderProgress(() -> RevisionCollectorTask.lambda$4$lambda$3$lambda$2(this$0), this$0.fastTaskIndicator);
    }

    public static final /* synthetic */ AtomicBoolean access$getFirstRevisionCollected$p(RevisionCollectorTask $this) {
        return $this.firstRevisionCollected;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$get_revisions$p(RevisionCollectorTask $this) {
        return $this._revisions;
    }

    public static final /* synthetic */ ProgressIndicator access$getFastTaskIndicator$p(RevisionCollectorTask $this) {
        return $this.fastTaskIndicator;
    }
}

