/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String DIFF_SPLITTER_PROPORTION = "vcs.log.diff.splitter.proportion";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "vcs.log.details.splitter.proportion";
    @NonNls
    private static final String CHANGES_SPLITTER_PROPORTION = "vcs.log.changes.splitter.proportion";
    @NonNls
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final VcsLogFilterUiEx myFilterUi;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final CommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final EditorNotificationPanel myNotificationLabel;
    @NotNull
    private final History myHistory;
    private boolean myIsLoading;
    @Nullable
    private FilePath myPathToSelect;
    @NotNull
    private final FrameDiffPreview myDiffPreview;

    public MainFrame(@NotNull VcsLogData logData, @NotNull AbstractVcsLogUi logUi2, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi, @NotNull VcsLogColorManager colorManager, boolean withEditorDiffPreview, @NotNull Disposable disposable) {
        if (logData == null) {
            MainFrame.$$$reportNull$$$0(0);
        }
        if (logUi2 == null) {
            MainFrame.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            MainFrame.$$$reportNull$$$0(2);
        }
        if (filterUi == null) {
            MainFrame.$$$reportNull$$$0(3);
        }
        if (colorManager == null) {
            MainFrame.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            MainFrame.$$$reportNull$$$0(5);
        }
        this.myPathToSelect = null;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
        this.myGraphTable = new MyVcsLogGraphTable(logUi2.getId(), logData, logUi2.getProperties(), colorManager, () -> logUi2.getRefresher().onRefresh(), () -> logUi2.requestMore(EmptyRunnable.INSTANCE), disposable);
        String vcsDisplayName = VcsLogUtil.getVcsDisplayName(logData.getProject(), logData.getLogProviders().values());
        this.myGraphTable.getAccessibleContext().setAccessibleName(VcsLogBundle.message("vcs.log.table.accessible.name", vcsDisplayName));
        PopupHandler.installPopupMenu((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new CommitDetailsListPanel(logData.getProject(), this, (Function0<CommitDetailsPanel>)((Function0)() -> new CommitDetailsPanel((Function1<? super CommitId, Unit>)((Function1)commit -> {
            VcsLogNavigationUtil.jumpToCommit(logUi2, commit.getHash(), commit.getRoot(), false, true);
            return Unit.INSTANCE;
        }))));
        VcsLogCommitSelectionListenerForDetails.install(this.myGraphTable, this.myDetailsPanel, this);
        this.myChangesBrowser = new VcsLogChangesBrowser(logData.getProject(), this.myUiProperties, (Function1<? super CommitId, ? extends VcsShortCommitDetails>)((Function1)commitId2 -> {
            int index = this.myLogData.getCommitIndex(commitId2.getHash(), commitId2.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCachedDataOrPlaceholder(index);
        }), withEditorDiffPreview, this);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        JBLoadingPanel changesLoadingPane = new JBLoadingPanel(new BorderLayout(), this, 300){

            public Dimension getMinimumSize() {
                return VcsLogUiUtil.expandToFitToolbar(super.getMinimumSize(), MainFrame.this.myChangesBrowser.getToolbar().getComponent());
            }
        };
        changesLoadingPane.add((Component)((Object)this.myChangesBrowser));
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        MyCommitSelectionListenerForDiff listenerForDiff = new MyCommitSelectionListenerForDiff(changesLoadingPane);
        this.myGraphTable.getSelectionModel().addListSelectionListener(listenerForDiff);
        Disposer.register((Disposable)this, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(listenerForDiff));
        this.myNotificationLabel = new EditorNotificationPanel(UIUtil.getPanelBackground(), EditorNotificationPanel.Status.Warning);
        this.myNotificationLabel.setVisible(false);
        this.myNotificationLabel.setBorder((Border)new CompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0), (Border)ObjectUtils.notNull((Object)this.myNotificationLabel.getBorder(), (Object)JBUI.Borders.empty())));
        BorderLayoutPanel toolbars = new BorderLayoutPanel();
        toolbars.add((Component)this.myToolbar, "North");
        toolbars.add((Component)this.myNotificationLabel, "Center");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        JComponent tableWithProgress = VcsLogUiUtil.installScrollingAndProgress(this.myGraphTable, this);
        toolbarsAndTable.add((Component)tableWithProgress, "Center");
        this.myDetailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)changesLoadingPane);
        this.showDetails(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, CHANGES_SPLITTER_PROPORTION, 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        this.myDiffPreview = new FrameDiffPreview(this.myUiProperties, (JComponent)this.myChangesBrowserSplitter, DIFF_SPLITTER_PROPORTION, 0.7f, this){

            @Override
            @NotNull
            protected DiffEditorViewer createViewer() {
                DiffEditorViewer processor = MainFrame.this.myChangesBrowser.createChangeProcessor(false);
                processor.setToolbarVerticalSizeReferent(MainFrame.this.getToolbar());
                DiffEditorViewer diffEditorViewer = processor;
                if (diffEditorViewer == null) {
                    2.$$$reportNull$$$0(0);
                }
                return diffEditorViewer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$2", "createViewer"));
            }
        };
        this.add(this.myDiffPreview.getMainComponent());
        this.myHistory = VcsLogUiUtil.installNavigationHistory(logUi2, this.myGraphTable);
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusPolicy()));
    }

    public void setExplanationHtml(@Nullable @NlsContexts.LinkLabel String text) {
        this.myNotificationLabel.setText(Objects.requireNonNullElse(text, ""));
        this.myNotificationLabel.setVisible(text != null);
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            MainFrame.$$$reportNull$$$0(6);
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myChangesBrowser.setAffectedPaths(VcsLogUtil.getAffectedPaths(dataPack));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            MainFrame.$$$reportNull$$$0(7);
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        VcsLogFilterUiEx vcsLogFilterUiEx = this.myFilterUi;
        if (vcsLogFilterUiEx == null) {
            MainFrame.$$$reportNull$$$0(8);
        }
        return vcsLogFilterUiEx;
    }

    @NotNull
    protected JComponent createActionsToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup toolbarGroup = (DefaultActionGroup)actionManager.getAction("Vcs.Log.Toolbar.Internal");
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar2 = actionManager.createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar2.setTargetComponent((JComponent)this);
        Wrapper textFilter = new Wrapper(this.myFilterUi.getTextFilterComponent().getComponent());
        textFilter.setVerticalSizeReferent(toolbar2.getComponent());
        String vcsDisplayName = VcsLogUtil.getVcsDisplayName(this.myLogData.getProject(), this.myLogData.getLogProviders().values());
        textFilter.getAccessibleContext().setAccessibleName(VcsLogBundle.message("vcs.log.text.filter.accessible.name", vcsDisplayName));
        ActionGroup rightCornerGroup = (ActionGroup)Objects.requireNonNull(CustomActionsSchema.getInstance().getCorrectedAction("Vcs.Log.Toolbar.RightCorner"));
        ActionToolbar rightCornerToolbar = actionManager.createActionToolbar("Vcs.Log.Toolbar", rightCornerGroup, true);
        rightCornerToolbar.setTargetComponent((JComponent)this);
        rightCornerToolbar.setReservePlaceAutoPopupIcon(false);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[pref:pref, right]", "center"));
        GuiUtils.installVisibilityReferent((JComponent)panel, (JComponent)toolbar2.getComponent());
        panel.add((Component)textFilter);
        panel.add(toolbar2.getComponent());
        panel.add(rightCornerToolbar.getComponent());
        JPanel jPanel = panel;
        if (jPanel == null) {
            MainFrame.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            MainFrame.$$$reportNull$$$0(10);
        }
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return this.myChangesBrowser.getDirectChanges().toArray(Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUiProperties;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            return VfsUtilCore.toVirtualFileArray(roots);
        }
        if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            if (roots.size() != 1) {
                return null;
            }
            return this.myLogData.getLogProvider(Objects.requireNonNull((VirtualFile)ContainerUtil.getFirstItem(roots))).getDiffHandler();
        }
        if (VcsLogInternalDataKeys.VCS_LOG_VISIBLE_ROOTS.is(dataId)) {
            return VcsLogUtil.getAllVisibleRoots(this.myLogData.getRoots(), this.myFilterUi.getFilters());
        }
        if (QuickActionProvider.KEY.is(dataId)) {
            return new QuickActionProvider(){

                @NotNull
                public List<AnAction> getActions(boolean originalProvider) {
                    AnAction textFilterAction = ActionUtil.wrap((String)"Vcs.Log.FocusTextFilter");
                    textFilterAction.getTemplatePresentation().setText(VcsLogBundle.message("vcs.log.text.filter.action.text", new Object[0]));
                    ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
                    actions2.add(textFilterAction);
                    actions2.addAll(SimpleToolWindowPanel.collectActions((JComponent)MainFrame.this.myToolbar));
                    ArrayList<AnAction> arrayList = actions2;
                    if (arrayList == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return arrayList;
                }

                public JComponent getComponent() {
                    return MainFrame.this;
                }

                @NlsActions.ActionText
                @Nullable
                public String getName() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$3", "getActions"));
                }
            };
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (History.KEY.is(dataId)) {
            return this.myHistory;
        }
        return null;
    }

    @NotNull
    private Collection<VirtualFile> getSelectedRoots() {
        Collection<VirtualFile> roots = this.myLogData.getRoots();
        if (roots.size() == 1) {
            Collection<VirtualFile> collection = roots;
            if (collection == null) {
                MainFrame.$$$reportNull$$$0(11);
            }
            return collection;
        }
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, this.myFilterUi.getFilters());
            if (set == null) {
                MainFrame.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.myGraphTable.getModel().getRootAtRow((int)row2));
        if (set == null) {
            MainFrame.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            MainFrame.$$$reportNull$$$0(14);
        }
        return jComponent;
    }

    @NotNull
    public VcsLogChangesBrowser getChangesBrowser() {
        VcsLogChangesBrowser vcsLogChangesBrowser = this.myChangesBrowser;
        if (vcsLogChangesBrowser == null) {
            MainFrame.$$$reportNull$$$0(15);
        }
        return vcsLogChangesBrowser;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(state ? this.myDetailsPanel : null)));
    }

    public void selectFilePath(@NotNull FilePath filePath, boolean requestFocus) {
        if (filePath == null) {
            MainFrame.$$$reportNull$$$0(16);
        }
        if (this.myIsLoading) {
            this.myPathToSelect = filePath;
        } else {
            this.myChangesBrowser.selectFile(filePath);
            this.myPathToSelect = null;
        }
        if (requestFocus) {
            this.myChangesBrowser.getViewer().requestFocus();
        }
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private class MyVcsLogGraphTable
    extends VcsLogGraphTable {
        @NotNull
        private final Runnable myRefresh;

        MyVcsLogGraphTable(@NotNull String logId, @NotNull VcsLogData logData, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @NotNull Runnable refresh, @NotNull Runnable requestMore, Disposable disposable) {
            if (logId == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(0);
            }
            if (logData == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(1);
            }
            if (uiProperties == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(2);
            }
            if (colorManager == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(3);
            }
            if (refresh == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(4);
            }
            if (requestMore == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(5);
            }
            if (disposable == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(6);
            }
            super(logId, logData, uiProperties, colorManager, requestMore, disposable);
            this.myRefresh = refresh;
            IndexSpeedSearch speedSearch = new IndexSpeedSearch(MainFrame.this.myLogData.getProject(), MainFrame.this.myLogData.getIndex(), MainFrame.this.myLogData.getStorage(), this){

                @Override
                protected boolean isSpeedSearchEnabled() {
                    return Registry.is((String)"vcs.log.speedsearch") && super.isSpeedSearchEnabled();
                }
            };
            speedSearch.setupListeners();
        }

        @Override
        protected void updateEmptyText() {
            StatusText statusText2 = this.getEmptyText();
            VisiblePack visiblePack = this.getModel().getVisiblePack();
            DataPackBase dataPack = visiblePack.getDataPack();
            if (dataPack instanceof DataPack.ErrorDataPack) {
                this.setErrorEmptyText(((DataPack.ErrorDataPack)dataPack).getError(), VcsLogBundle.message("vcs.log.error.loading.commits.status", new Object[0]));
                this.appendActionToEmptyText(VcsLogBundle.message("vcs.log.refresh.status.action", new Object[0]), () -> MainFrame.this.myLogData.refresh(MainFrame.this.myLogData.getLogProviders().keySet()));
            } else if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                this.setErrorEmptyText(((VisiblePack.ErrorVisiblePack)visiblePack).getError(), VcsLogBundle.message("vcs.log.error.filtering.status", new Object[0]));
                if (visiblePack.getFilters().isEmpty()) {
                    this.appendActionToEmptyText(VcsLogBundle.message("vcs.log.refresh.status.action", new Object[0]), this.myRefresh);
                } else {
                    VcsLogUiUtil.appendResetFiltersActionToEmptyText(MainFrame.this.myFilterUi, this.getEmptyText());
                }
            } else if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                if (visiblePack.getFilters().isEmpty()) {
                    statusText2.setText(VcsLogBundle.message("vcs.log.no.commits.status", new Object[0])).appendSecondaryText(VcsLogBundle.message("vcs.log.commit.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                    if (!shortcutText.isEmpty()) {
                        statusText2.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                    }
                } else {
                    MainFrame.this.myFilterUi.setCustomEmptyText(this.getEmptyText());
                }
            } else {
                statusText2.setText(VcsLogBundle.message("vcs.log.default.status", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "uiProperties";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "colorManager";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refresh";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requestMore";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyVcsLogGraphTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListener<VcsFullCommitDetails> {
        @NotNull
        private final JBLoadingPanel myChangesLoadingPane;

        protected MyCommitSelectionListenerForDiff(JBLoadingPanel changesLoadingPane) {
            if (changesLoadingPane == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(0);
            }
            super(MainFrame.this.myGraphTable, MainFrame.this.myLogData.getCommitDetailsGetter());
            this.myChangesLoadingPane = changesLoadingPane;
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
            int maxSize;
            if (detailsList == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(1);
            }
            if ((maxSize = VcsLogUtil.getMaxSize(detailsList)) > VcsLogUtil.getShownChangesLimit()) {
                String sizeText = VcsLogUtil.getSizeText(maxSize);
                MainFrame.this.myChangesBrowser.setEmptyWithText(statusText2 -> {
                    statusText2.setText(VcsLogBundle.message("vcs.log.changes.too.many.status", detailsList.size(), sizeText));
                    statusText2.appendSecondaryText(VcsLogBundle.message("vcs.log.changes.too.many.show.anyway.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList));
                });
            } else {
                MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList);
            }
        }

        @Override
        protected int @NotNull [] onSelection(int @NotNull [] selection) {
            if (selection == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(2);
            }
            MainFrame.this.myChangesBrowser.setEmpty();
            if (selection == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(3);
            }
            return selection;
        }

        @Override
        protected void onLoadingScheduled() {
            MainFrame.this.myIsLoading = true;
            MainFrame.this.myPathToSelect = null;
        }

        @Override
        protected void onLoadingStarted() {
            this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void onLoadingStopped() {
            this.myChangesLoadingPane.stopLoading();
            MainFrame.this.myIsLoading = false;
            if (MainFrame.this.myPathToSelect != null) {
                MainFrame.this.myChangesBrowser.selectFile(MainFrame.this.myPathToSelect);
                MainFrame.this.myPathToSelect = null;
            }
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            if (error == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(4);
            }
            MainFrame.this.myChangesBrowser.setEmptyWithText(statusText2 -> statusText2.setText(VcsLogBundle.message("vcs.log.error.loading.changes.status", new Object[0])));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesLoadingPane";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/MainFrame$MyCommitSelectionListenerForDiff";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyCommitSelectionListenerForDiff";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "onSelection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onDetailsLoaded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onSelection";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onError";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            List list = ContainerUtil.skipNulls(Arrays.asList(MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myDiffPreview.getPreferredFocusedComponent(), MainFrame.this.myFilterUi.getTextFilterComponent().getFocusedComponent()));
            if (list == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
        }
    }
}

