/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogEditorTabsWatcher;
import com.intellij.vcs.log.impl.VcsLogEditorUtil;
import com.intellij.vcs.log.impl.VcsLogTabsWatcherExtension;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u0000 \u00192\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0003\u0019\u001a\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001c\u0010\u0010\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u001c\u0010\u0017\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher;", "Lcom/intellij/vcs/log/impl/VcsLogTabsWatcherExtension;", "Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$VcsLogEditorTab;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "tabSelectedCallback", "Lkotlin/Function1;", "", "", "closeTabs", "tabs", "", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "createLogTab", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "isClosedOnDispose", "", "isOwnerOf", "tab", "setTabSelectedCallback", "callback", "Companion", "MyFileManagerListener", "VcsLogEditorTab", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogEditorTabsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogEditorTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n800#2,11:68\n766#2:79\n857#2,2:80\n1549#2:82\n1620#2,3:83\n*S KotlinDebug\n*F\n+ 1 VcsLogEditorTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher\n*L\n35#1:68,11\n35#1:79\n35#1:80,2\n35#1:82\n35#1:83,3\n*E\n"})
public final class VcsLogEditorTabsWatcher
implements VcsLogTabsWatcherExtension<VcsLogEditorTab> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private Function1<? super String, Unit> tabSelectedCallback;
    @NotNull
    private static final Logger LOG;

    public VcsLogEditorTabsWatcher(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.tabSelectedCallback = tabSelectedCallback.1.INSTANCE;
        MessageBusConnection connection = this.project.getMessageBus().connect(parentDisposable);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)new MyFileManagerListener());
    }

    @Override
    public void setTabSelectedCallback(@NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.tabSelectedCallback = callback;
    }

    @Override
    @NotNull
    public VcsLogEditorTab createLogTab(@NotNull VcsLogUiEx ui2, boolean isClosedOnDispose) {
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        return new VcsLogEditorTab(ui2, isClosedOnDispose);
    }

    @Override
    public boolean isOwnerOf(@NotNull PostponableLogRefresher.VcsLogWindow tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        return tab instanceof VcsLogEditorTab;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeTabs(@NotNull List<? extends PostponableLogRefresher.VcsLogWindow> tabs) {
        void $this$mapTo$iv$iv;
        VcsLogEditorTab it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
        Iterable $this$filterIsInstance$iv = tabs;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VcsLogEditorTab)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VcsLogEditorTab)element$iv$iv;
            boolean bl = false;
            if (!it.isClosedOnDispose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VcsLogEditorTab)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List editorTabs = (List)destination$iv$iv;
        boolean closed = VcsLogEditorUtil.INSTANCE.closeLogTabs$intellij_platform_vcs_log_impl(this.project, editorTabs);
        LOG.assertTrue(closed, (Object)("Could not close tabs: " + editorTabs));
    }

    static {
        Logger logger = Logger.getInstance(VcsLogEditorTabsWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getSelectedEditorTabIds", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> getSelectedEditorTabIds(Project project) {
            return VcsLogEditorUtil.INSTANCE.findSelectedLogIds$intellij_platform_vcs_log_impl(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$MyFileManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "(Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher;)V", "selectionChanged", "", "e", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.vcs.log.impl"})
    private final class MyFileManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileEditor fileEditor = e.getNewEditor();
                if (fileEditor == null) break block1;
                FileEditor fileEditor2 = fileEditor;
                VcsLogEditorTabsWatcher vcsLogEditorTabsWatcher = VcsLogEditorTabsWatcher.this;
                FileEditor editor = fileEditor2;
                boolean bl = false;
                for (String tabId : VcsLogEditorUtil.INSTANCE.getLogIds$intellij_platform_vcs_log_impl(editor)) {
                    vcsLogEditorTabsWatcher.tabSelectedCallback.invoke((Object)tabId);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\u0005H\u0016J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$VcsLogEditorTab;", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "isClosedOnDispose", "", "(Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher;Lcom/intellij/vcs/log/ui/VcsLogUiEx;Z)V", "()Z", "isVisible", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.log.impl"})
    public final class VcsLogEditorTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean isClosedOnDispose;

        public VcsLogEditorTab(VcsLogUiEx ui2, boolean isClosedOnDispose) {
            Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
            super(ui2);
            this.isClosedOnDispose = isClosedOnDispose;
        }

        public final boolean isClosedOnDispose() {
            return this.isClosedOnDispose;
        }

        @Override
        public boolean isVisible() {
            return Companion.getSelectedEditorTabIds(VcsLogEditorTabsWatcher.this.project).contains(this.getId());
        }

        @Override
        @NotNull
        public String toString() {
            return "VcsLogEditorTab '" + this.getId() + "'";
        }
    }
}

