/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.LoadingDetailsImpl;
import com.intellij.vcs.log.data.LoadingDetailsWithRoot;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\b\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002CDBC\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fJ\u0018\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0017H\u0003J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0015J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0017H\u0002J\b\u0010,\u001a\u00020\"H\u0016J*\u0010-\u001a\u00020\"2\u0006\u0010(\u001a\u00020.2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"00H\u0007J \u0010-\u001a\u00020\"2\u0006\u0010(\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000201H\u0015J6\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\t2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u000e\u0010/\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000201H\u0015J\u0012\u00108\u001a\u0004\u0018\u00010\u00022\u0006\u0010+\u001a\u00020\u0014H\u0016J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u0002092\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001406H\u0014J\u000e\u0010:\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0014J\u001e\u0010;\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00142\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00140=H\u0007J\u0012\u0010>\u001a\u0004\u0018\u00010\u00022\u0006\u0010+\u001a\u00020\u0014H\u0002J\b\u0010?\u001a\u00020\"H\u0014J\u000e\u0010@\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fJ\u0018\u0010A\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u0002H\u0014RN\u0010\u0012\u001aB\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00020\u0002 \u0015* \u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u001c0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/vcs/log/data/MiniDetailsGetter;", "Lcom/intellij/vcs/log/data/AbstractDataGetter;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "topCommitsDetailsCache", "Lcom/intellij/vcs/log/data/TopCommitsCache;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;Lcom/intellij/vcs/log/data/TopCommitsCache;Lcom/intellij/vcs/log/data/index/VcsLogIndex;Lcom/intellij/openapi/Disposable;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "currentTaskIndex", "", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "loader", "Lcom/intellij/vcs/log/util/SequentialLimitedLifoExecutor;", "Lcom/intellij/vcs/log/data/MiniDetailsGetter$TaskDescriptor;", "loadingFinishedListeners", "Ljava/util/ArrayList;", "Ljava/lang/Runnable;", "Lkotlin/collections/ArrayList;", "addDetailsLoadedListener", "", "runnable", "cacheCommit", "commitId", "taskNumber", "cacheCommits", "commits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "createPlaceholderCommit", "commit", "dispose", "doLoadCommitsData", "Lit/unimi/dsi/fastutil/ints/IntSet;", "consumer", "Lkotlin/Function2;", "Lcom/intellij/util/Consumer;", "doLoadCommitsDataFromProvider", "logProvider", "root", "hashes", "", "", "getCachedData", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "getCachedDataOrPlaceholder", "getCommitData", "commitsToLoad", "", "getFromCacheAndCleanOldPlaceholder", "notifyLoaded", "removeDetailsLoadedListener", "saveInCache", "details", "Companion", "TaskDescriptor", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nMiniDetailsGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter$Companion\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,203:1\n23#2:204\n1#3:205\n189#4,6:206\n215#5,2:212\n*S KotlinDebug\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter\n*L\n56#1:204\n94#1:206,6\n130#1:212,2\n*E\n"})
public final class MiniDetailsGetter
extends AbstractDataGetter<VcsCommitMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TopCommitsCache topCommitsDetailsCache;
    @NotNull
    private final VcsLogIndex index;
    private final VcsLogObjectsFactory factory;
    private final Cache<Integer, VcsCommitMetadata> cache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> loader;
    private long currentTaskIndex;
    @NotNull
    private final ArrayList<Runnable> loadingFinishedListeners;
    private static final int MAX_LOADING_TASKS = 10;

    public MiniDetailsGetter(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)topCommitsDetailsCache, (String)"topCommitsDetailsCache");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(storage, logProviders, parentDisposable);
        this.topCommitsDetailsCache = topCommitsDetailsCache;
        this.index = index;
        this.factory = (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
        this.cache = Caffeine.newBuilder().maximumSize(10000L).build();
        this.loader = new SequentialLimitedLifoExecutor(this, 10, arg_0 -> MiniDetailsGetter.loader$lambda$0((Function1)new Function1<TaskDescriptor, Unit>(this){
            final /* synthetic */ MiniDetailsGetter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TaskDescriptor task2) {
                Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                this.this$0.doLoadCommitsData(task2.getCommits(), (Function2<? super Integer, ? super VcsCommitMetadata, Unit>)((Function2)new Function2<Integer, VcsCommitMetadata, Unit>(this.this$0){
                    final /* synthetic */ MiniDetailsGetter this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(int commitId2, @NotNull VcsCommitMetadata data) {
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        this.this$0.saveInCache(commitId2, data);
                    }
                }));
                this.this$0.notifyLoaded();
            }
        }, arg_0));
        this.loadingFinishedListeners = new ArrayList();
    }

    @NotNull
    public final VcsCommitMetadata getCachedDataOrPlaceholder(int commit) {
        return this.getCommitData(commit, SetsKt.emptySet());
    }

    @ApiStatus.Internal
    @NotNull
    public final VcsCommitMetadata getCommitData(int commit, @NotNull Iterable<Integer> commitsToLoad) {
        VcsCommitMetadata details;
        Intrinsics.checkNotNullParameter(commitsToLoad, (String)"commitsToLoad");
        VcsCommitMetadata vcsCommitMetadata = details = this.getFromCacheAndCleanOldPlaceholder(commit);
        if (vcsCommitMetadata != null) {
            return vcsCommitMetadata;
        }
        if (!EventQueue.isDispatchThread()) {
            MiniDetailsGetter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MiniDetailsGetter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.assertTrue(CollectionsKt.none(commitsToLoad), (Object)"Requesting loading commits in background thread is not supported.");
            return this.createPlaceholderCommit(commit, 0L);
        }
        IntOpenHashSet toLoad = new IntOpenHashSet(commitsToLoad.iterator());
        if (toLoad.isEmpty()) {
            VcsCommitMetadata vcsCommitMetadata2 = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
            if (vcsCommitMetadata2 == null) {
                vcsCommitMetadata2 = this.createPlaceholderCommit(commit, 0L);
            }
            return vcsCommitMetadata2;
        }
        long l = this.currentTaskIndex;
        this.currentTaskIndex = l + 1L;
        long taskNumber = l;
        toLoad.forEach(arg_0 -> MiniDetailsGetter.getCommitData$lambda$1(this, taskNumber, arg_0));
        this.loader.queue(new TaskDescriptor((IntSet)toLoad));
        VcsCommitMetadata vcsCommitMetadata3 = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
        if (vcsCommitMetadata3 == null) {
            vcsCommitMetadata3 = this.createPlaceholderCommit(commit, taskNumber);
        }
        return vcsCommitMetadata3;
    }

    private final VcsCommitMetadata getFromCacheAndCleanOldPlaceholder(int commit) {
        if (!EventQueue.isDispatchThread()) {
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
            if (vcsCommitMetadata == null) {
                vcsCommitMetadata = this.topCommitsDetailsCache.get(commit);
            }
            return vcsCommitMetadata;
        }
        VcsCommitMetadata details = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
        if (details != null) {
            if (details instanceof LoadingDetailsImpl && ((LoadingDetailsImpl)details).getLoadingTaskIndex() <= this.currentTaskIndex - (long)10) {
                this.cache.asMap().remove(commit, details);
                return null;
            }
            return details;
        }
        return this.topCommitsDetailsCache.get(commit);
    }

    @Nullable
    public VcsCommitMetadata getCachedData(int commit) {
        Object object = this.cache.getIfPresent((Object)commit);
        VcsCommitMetadata it = (VcsCommitMetadata)object;
        boolean bl = false;
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)(!(it instanceof LoadingDetails) ? object : null);
        if (vcsCommitMetadata == null) {
            vcsCommitMetadata = this.topCommitsDetailsCache.get(commit);
        }
        return vcsCommitMetadata;
    }

    @Override
    @NotNull
    protected Int2ObjectMap<VcsCommitMetadata> getCachedData(@NotNull List<Integer> commits2) {
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Companion companion = Companion;
        Iterable $this$associateNotNull$iv = commits2;
        boolean $i$f$associateNotNull = false;
        Int2ObjectOpenHashMap result$iv = new Int2ObjectOpenHashMap();
        Iterator iterator = $this$associateNotNull$iv.iterator();
        while (iterator.hasNext()) {
            VcsCommitMetadata value$iv;
            int element$iv;
            int it = element$iv = ((Number)iterator.next()).intValue();
            boolean bl = false;
            if (this.getCachedData(it) == null) continue;
            Integer n = element$iv;
            ((Map)result$iv).put(n, value$iv);
        }
        return (Int2ObjectMap)result$iv;
    }

    @Override
    protected void saveInCache(int commit, @NotNull VcsCommitMetadata details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.cache.put((Object)commit, (Object)details);
    }

    @RequiresEdt
    private final void cacheCommit(int commitId2, long taskNumber) {
        if (this.cache.getIfPresent((Object)commitId2) == null) {
            this.cache.put((Object)commitId2, (Object)this.createPlaceholderCommit(commitId2, taskNumber));
        }
    }

    @Override
    @RequiresEdt
    protected void cacheCommits(@NotNull IntOpenHashSet commits2) {
        Intrinsics.checkNotNullParameter((Object)commits2, (String)"commits");
        long l = this.currentTaskIndex;
        this.currentTaskIndex = l + 1L;
        long taskNumber = l;
        commits2.forEach(arg_0 -> MiniDetailsGetter.cacheCommits$lambda$4(this, taskNumber, arg_0));
    }

    @Override
    @RequiresBackgroundThread
    protected void doLoadCommitsData(@NotNull IntSet commits2, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.doLoadCommitsData(commits2, (Function2<? super Integer, ? super VcsCommitMetadata, Unit>)((Function2)new Function2<Integer, VcsCommitMetadata, Unit>(consumer){
            final /* synthetic */ Consumer<? super VcsCommitMetadata> $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(int n, @NotNull VcsCommitMetadata metadata) {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                this.$consumer.consume((Object)metadata);
            }
        }));
    }

    @RequiresBackgroundThread
    public final void doLoadCommitsData(@NotNull IntSet commits2, @NotNull Function2<? super Integer, ? super VcsCommitMetadata, Unit> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IndexDataGetter dataGetter = this.index.getDataGetter();
        if (dataGetter == null) {
            super.doLoadCommitsData(commits2, arg_0 -> MiniDetailsGetter.doLoadCommitsData$lambda$5((Function1)new Function1<VcsCommitMetadata, Unit>(consumer, this){
                final /* synthetic */ Function2<Integer, VcsCommitMetadata, Unit> $consumer;
                final /* synthetic */ MiniDetailsGetter this$0;
                {
                    this.$consumer = $consumer;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(VcsCommitMetadata data) {
                    VcsLogStorage vcsLogStorage = this.this$0.getStorage();
                    Object object = data.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
                    Hash hash = (Hash)object;
                    VirtualFile virtualFile = data.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    Integer n = vcsLogStorage.getCommitIndex(hash, virtualFile);
                    Intrinsics.checkNotNull((Object)data);
                    this.$consumer.invoke((Object)n, (Object)data);
                }
            }, arg_0));
            return;
        }
        Set set = (Set)commits2;
        VcsLogStorage vcsLogStorage = this.getStorage();
        VcsLogObjectsFactory vcsLogObjectsFactory = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogObjectsFactory, (String)"factory");
        Int2ObjectMap<VcsCommitMetadata> metadata = IndexedDetails.Companion.createMetadata(set, dataGetter, vcsLogStorage, vcsLogObjectsFactory);
        Map $this$forEach$iv = (Map)metadata;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Integer commit = (Integer)entry.getKey();
            VcsCommitMetadata metadata2 = (VcsCommitMetadata)entry.getValue();
            Intrinsics.checkNotNull((Object)commit);
            Intrinsics.checkNotNull((Object)metadata2);
            consumer.invoke((Object)commit, (Object)metadata2);
        }
        Set set2 = metadata.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        IntSet notIndexed = MiniDetailsGetter.Companion.minus(commits2, (IntSet)set2);
        if (!notIndexed.isEmpty()) {
            super.doLoadCommitsData(notIndexed, arg_0 -> MiniDetailsGetter.doLoadCommitsData$lambda$7((Function1)new Function1<VcsCommitMetadata, Unit>(consumer, this){
                final /* synthetic */ Function2<Integer, VcsCommitMetadata, Unit> $consumer;
                final /* synthetic */ MiniDetailsGetter this$0;
                {
                    this.$consumer = $consumer;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(VcsCommitMetadata data) {
                    VcsLogStorage vcsLogStorage = this.this$0.getStorage();
                    Object object = data.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
                    Hash hash = (Hash)object;
                    VirtualFile virtualFile = data.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    Integer n = vcsLogStorage.getCommitIndex(hash, virtualFile);
                    Intrinsics.checkNotNull((Object)data);
                    this.$consumer.invoke((Object)n, (Object)data);
                }
            }, arg_0));
        }
    }

    @Override
    @RequiresBackgroundThread
    protected void doLoadCommitsDataFromProvider(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)logProvider, (String)"logProvider");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes2, (String)"hashes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        logProvider.readMetadata(root, hashes2, consumer);
    }

    private final VcsCommitMetadata createPlaceholderCommit(int commit, long taskNumber) {
        VcsCommitMetadata vcsCommitMetadata;
        IndexDataGetter dataGetter = this.index.getDataGetter();
        if (dataGetter != null && Registry.is((String)"vcs.log.use.indexed.details")) {
            vcsCommitMetadata = (VcsCommitMetadata)new IndexedDetails(dataGetter, this.getStorage(), commit, taskNumber);
        } else {
            LoadingDetailsImpl loadingDetailsImpl;
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((Iterable)this.getLogProviders().keySet());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                loadingDetailsImpl = new LoadingDetailsWithRoot(this.getStorage(), commit, it, taskNumber);
            } else {
                loadingDetailsImpl = new LoadingDetailsImpl(this.getStorage(), commit, taskNumber);
            }
            vcsCommitMetadata = (VcsCommitMetadata)loadingDetailsImpl;
        }
        return vcsCommitMetadata;
    }

    public final void addDetailsLoadedListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.loadingFinishedListeners.add(runnable);
    }

    public final void removeDetailsLoadedListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.loadingFinishedListeners.remove(runnable);
    }

    @Override
    protected void notifyLoaded() {
        BaseSingleTaskControllerKt.runInEdt(this.getDisposableFlag(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MiniDetailsGetter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                for (Runnable loadingFinishedListener : MiniDetailsGetter.access$getLoadingFinishedListeners$p(this.this$0)) {
                    loadingFinishedListener.run();
                }
            }
        }));
    }

    public void dispose() {
        this.loadingFinishedListeners.clear();
    }

    private static final void loader$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void getCommitData$lambda$1(MiniDetailsGetter this$0, long $taskNumber, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cacheCommit(it, $taskNumber);
    }

    private static final void cacheCommits$lambda$4(MiniDetailsGetter this$0, long $taskNumber, int commit) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cacheCommit(commit, $taskNumber);
    }

    private static final void doLoadCommitsData$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void doLoadCommitsData$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ArrayList access$getLoadingFinishedListeners$p(MiniDetailsGetter $this) {
        return $this.loadingFinishedListeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u00020\u00040\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\nH\u0082\bJ\u0015\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0082\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/data/MiniDetailsGetter$Companion;", "", "()V", "MAX_LOADING_TASKS", "", "associateNotNull", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "V", "", "transform", "Lkotlin/Function1;", "minus", "Lit/unimi/dsi/fastutil/ints/IntSet;", "other", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nMiniDetailsGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n847#2,2:204\n*S KotlinDebug\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter$Companion\n*L\n199#1:204,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final <V> Int2ObjectMap<V> associateNotNull(Iterable<Integer> $this$associateNotNull, Function1<? super Integer, ? extends V> transform) {
            boolean $i$f$associateNotNull = false;
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
            Iterator<Integer> iterator = $this$associateNotNull.iterator();
            while (iterator.hasNext()) {
                Object value;
                int element = ((Number)iterator.next()).intValue();
                if (transform.invoke((Object)element) == null) continue;
                Integer n = element;
                ((Map)result2).put(n, value);
            }
            return (Int2ObjectMap)result2;
        }

        /*
         * WARNING - void declaration
         */
        private final IntSet minus(IntSet $this$minus, IntSet other) {
            void $this$filterNotTo$iv;
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
            if (other.isEmpty()) {
                return $this$minus;
            }
            Iterable iterable = (Iterable)$this$minus;
            Collection destination$iv = (Collection)new IntOpenHashSet();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv : $this$filterNotTo$iv) {
                Integer it = (Integer)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (other.contains(it.intValue())) continue;
                destination$iv.add(element$iv);
            }
            return (IntSet)destination$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/data/MiniDetailsGetter$TaskDescriptor;", "", "commits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "(Lit/unimi/dsi/fastutil/ints/IntSet;)V", "getCommits", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "intellij.platform.vcs.log.impl"})
    private static final class TaskDescriptor {
        @NotNull
        private final IntSet commits;

        public TaskDescriptor(@NotNull IntSet commits2) {
            Intrinsics.checkNotNullParameter((Object)commits2, (String)"commits");
            this.commits = commits2;
        }

        @NotNull
        public final IntSet getCommits() {
            return this.commits;
        }
    }
}

